/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.config;

import de.bluecolored.shadow.configurate.objectmapping.ConfigSerializable;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

@ConfigSerializable
public class WebappConfig {
    private boolean enabled = true;
    private boolean updateSettingsFile = true;
    private Path webroot = Path.of("bluemap", "web");
    private boolean useCookies = true;
    private boolean enableFreeFlight = true;
    private boolean defaultToFlatView = false;
    private String startLocation = null;
    private float resolutionDefault = 1.0f;
    private int minZoomDistance = 5;
    private int maxZoomDistance = 100000;
    private int hiresSliderMax = 500;
    private int hiresSliderDefault = 100;
    private int hiresSliderMin = 0;
    private int lowresSliderMax = 7000;
    private int lowresSliderDefault = 2000;
    private int lowresSliderMin = 500;
    private Set<String> scripts = new HashSet<String>();
    private Set<String> styles = new HashSet<String>();

    public boolean isEnabled() {
        return this.enabled;
    }

    public Path getWebroot() {
        return this.webroot;
    }

    public boolean isUpdateSettingsFile() {
        return this.updateSettingsFile;
    }

    public boolean isUseCookies() {
        return this.useCookies;
    }

    public boolean isEnableFreeFlight() {
        return this.enableFreeFlight;
    }

    public boolean isDefaultToFlatView() {
        return this.defaultToFlatView;
    }

    public Optional<String> getStartLocation() {
        return Optional.ofNullable(this.startLocation);
    }

    public float getResolutionDefault() {
        return this.resolutionDefault;
    }

    public int getMinZoomDistance() {
        return this.minZoomDistance;
    }

    public int getMaxZoomDistance() {
        return this.maxZoomDistance;
    }

    public int getHiresSliderMax() {
        return this.hiresSliderMax;
    }

    public int getHiresSliderDefault() {
        return this.hiresSliderDefault;
    }

    public int getHiresSliderMin() {
        return this.hiresSliderMin;
    }

    public int getLowresSliderMax() {
        return this.lowresSliderMax;
    }

    public int getLowresSliderDefault() {
        return this.lowresSliderDefault;
    }

    public int getLowresSliderMin() {
        return this.lowresSliderMin;
    }

    public Set<String> getScripts() {
        return this.scripts;
    }

    public Set<String> getStyles() {
        return this.styles;
    }
}

