/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.plugin.commands;

import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.plugin.text.Text;
import de.bluecolored.bluemap.common.plugin.text.TextColor;
import de.bluecolored.bluemap.common.plugin.text.TextFormat;
import de.bluecolored.bluemap.common.rendermanager.RenderManager;
import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.StringJoiner;

public class CommandHelper {
    private static final DateTimeFormatter TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withLocale(Locale.ROOT).withZone(ZoneId.systemDefault());
    private final Plugin plugin;
    private final Map<String, WeakReference<RenderTask>> taskRefMap;

    public CommandHelper(Plugin plugin) {
        this.plugin = plugin;
        this.taskRefMap = new HashMap<String, WeakReference<RenderTask>>();
    }

    public List<Text> createStatusMessage() {
        ArrayList<Text> lines;
        block8: {
            List<RenderTask> tasks;
            block9: {
                lines = new ArrayList<Text>();
                RenderManager renderer = this.plugin.getRenderManager();
                tasks = renderer.getScheduledRenderTasks();
                lines.add(Text.of(TextColor.BLUE, "BlueMap - Status:"));
                if (!renderer.isRunning()) break block9;
                Text status = tasks.isEmpty() ? Text.of(TextColor.GRAY, "idle") : Text.of(TextColor.GREEN, "running");
                status.setHoverText(Text.of("click to stop rendering"));
                status.setClickAction(Text.ClickAction.RUN_COMMAND, "/bluemap stop");
                lines.add(Text.of(new Object[]{TextColor.WHITE, " Render-Threads are ", status, TextColor.WHITE, "!"}));
                if (tasks.isEmpty()) {
                    lines.add(Text.of(new Object[]{TextColor.GRAY, " Last time running: ", TextColor.DARK_GRAY, this.formatTime(renderer.getLastTimeBusy())}));
                } else {
                    lines.add(Text.of(TextColor.WHITE, " Queued Tasks (" + tasks.size() + "):"));
                    for (int i = 0; i < tasks.size(); ++i) {
                        if (i >= 10) {
                            lines.add(Text.of(TextColor.GRAY, "..."));
                            break block8;
                        }
                        RenderTask task = tasks.get(i);
                        lines.add(Text.of(new Object[]{TextColor.GRAY, "\u00a0\u00a0[" + this.getRefForTask(task) + "] ", TextColor.GOLD, task.getDescription()}));
                        if (i != 0) continue;
                        task.getDetail().ifPresent(detail -> lines.add(Text.of(new Object[]{TextColor.GRAY, "\u00a0\u00a0\u00a0Detail: ", TextColor.WHITE, detail})));
                        lines.add(Text.of(new Object[]{TextColor.GRAY, "\u00a0\u00a0\u00a0Progress: ", TextColor.WHITE, (double)Math.round(task.estimateProgress() * 10000.0) / 100.0 + "%"}));
                        long etaMs = renderer.estimateCurrentRenderTaskTimeRemaining();
                        if (etaMs <= 0L) continue;
                        Duration eta = Duration.of(etaMs, ChronoUnit.MILLIS);
                        String etaString = "%d:%02d:%02d".formatted(eta.toHours(), eta.toMinutesPart(), eta.toSecondsPart());
                        lines.add(Text.of(new Object[]{TextColor.GRAY, "\u00a0\u00a0\u00a0ETA: ", TextColor.WHITE, etaString}));
                    }
                }
                break block8;
            }
            if (this.plugin.checkPausedByPlayerCount()) {
                lines.add(Text.of(new Object[]{TextColor.WHITE, " Render-Threads are ", Text.of(TextColor.GOLD, "paused")}));
                lines.add(Text.of(new Object[]{TextColor.GRAY, TextFormat.ITALIC, "\u00a0\u00a0\u00a0(there are " + this.plugin.getBlueMap().getConfig().getPluginConfig().getPlayerRenderLimit() + " or more players online)"}));
            } else {
                lines.add(Text.of(new Object[]{TextColor.WHITE, " Render-Threads are ", Text.of(TextColor.RED, "stopped").setHoverText(Text.of("click to start rendering")).setClickAction(Text.ClickAction.RUN_COMMAND, "/bluemap start"), TextColor.GRAY, "!"}));
            }
            if (tasks.isEmpty()) break block8;
            lines.add(Text.of(TextColor.WHITE, " Queued Tasks (" + tasks.size() + "):"));
            for (int i = 0; i < tasks.size(); ++i) {
                if (i >= 10) {
                    lines.add(Text.of(TextColor.GRAY, "..."));
                    break;
                }
                RenderTask task = tasks.get(i);
                lines.add(Text.of(new Object[]{TextColor.GRAY, " - ", TextColor.WHITE, task.getDescription()}));
            }
        }
        return lines;
    }

    public Text worldHelperHover() {
        StringJoiner joiner = new StringJoiner("\n");
        for (String worldId : this.plugin.getBlueMap().getWorlds().keySet()) {
            joiner.add(worldId);
        }
        return Text.of(new Object[]{TextFormat.UNDERLINED, "world"}).setHoverText(Text.of(new Object[]{TextColor.WHITE, "Available worlds: \n", TextColor.GRAY, joiner.toString()}));
    }

    public Text mapHelperHover() {
        StringJoiner joiner = new StringJoiner("\n");
        for (String mapId : this.plugin.getBlueMap().getMaps().keySet()) {
            joiner.add(mapId);
        }
        return Text.of(new Object[]{TextFormat.UNDERLINED, "map"}).setHoverText(Text.of(new Object[]{TextColor.WHITE, "Available maps: \n", TextColor.GRAY, joiner.toString()}));
    }

    public synchronized Optional<RenderTask> getTaskForRef(String ref) {
        return Optional.ofNullable(this.taskRefMap.get(ref)).map(Reference::get);
    }

    public synchronized Collection<String> getTaskRefs() {
        return new ArrayList<String>(this.taskRefMap.keySet());
    }

    private synchronized String getRefForTask(RenderTask task) {
        Iterator<Map.Entry<String, WeakReference<RenderTask>>> iterator = this.taskRefMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, WeakReference<RenderTask>> entry = iterator.next();
            if (entry.getValue().get() == null) {
                iterator.remove();
            }
            if (entry.getValue().get() != task) continue;
            return entry.getKey();
        }
        String newRef = this.safeRandomRef();
        this.taskRefMap.put(newRef, new WeakReference<RenderTask>(task));
        return newRef;
    }

    private synchronized String safeRandomRef() {
        String ref = this.randomRef();
        while (this.taskRefMap.containsKey(ref)) {
            ref = this.randomRef();
        }
        return ref;
    }

    private String randomRef() {
        StringBuilder ref = new StringBuilder(Integer.toString(Math.abs(new Random().nextInt()), 16));
        while (ref.length() < 4) {
            ref.insert(0, "0");
        }
        return ref.subSequence(0, 4).toString();
    }

    public String formatTime(long timestamp) {
        if (timestamp < 0L) {
            return "-";
        }
        return TIME_FORMAT.format(Instant.ofEpochMilli(timestamp));
    }
}

