/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.plugin.commands;

import com.flowpowered.math.vector.Vector2d;
import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3d;
import com.flowpowered.math.vector.Vector3i;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.bluecolored.bluemap.common.config.ConfigurationException;
import de.bluecolored.bluemap.common.config.storage.StorageConfig;
import de.bluecolored.bluemap.common.debug.StateDumper;
import de.bluecolored.bluemap.common.plugin.Plugin;
import de.bluecolored.bluemap.common.plugin.PluginState;
import de.bluecolored.bluemap.common.plugin.commands.CommandHelper;
import de.bluecolored.bluemap.common.plugin.commands.MapSuggestionProvider;
import de.bluecolored.bluemap.common.plugin.commands.StorageSuggestionProvider;
import de.bluecolored.bluemap.common.plugin.commands.TaskRefSuggestionProvider;
import de.bluecolored.bluemap.common.plugin.commands.WorldOrMapSuggestionProvider;
import de.bluecolored.bluemap.common.plugin.commands.WorldSuggestionProvider;
import de.bluecolored.bluemap.common.plugin.text.Text;
import de.bluecolored.bluemap.common.plugin.text.TextColor;
import de.bluecolored.bluemap.common.plugin.text.TextFormat;
import de.bluecolored.bluemap.common.rendermanager.MapPurgeTask;
import de.bluecolored.bluemap.common.rendermanager.MapUpdateTask;
import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import de.bluecolored.bluemap.common.rendermanager.StorageDeleteTask;
import de.bluecolored.bluemap.common.rendermanager.WorldRegionRenderTask;
import de.bluecolored.bluemap.common.serverinterface.CommandSource;
import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.map.renderstate.TileInfoRegion;
import de.bluecolored.bluemap.core.map.renderstate.TileState;
import de.bluecolored.bluemap.core.storage.MapStorage;
import de.bluecolored.bluemap.core.storage.Storage;
import de.bluecolored.bluemap.core.util.Grid;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.ChunkConsumer;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.bluemap.core.world.block.Block;
import de.bluecolored.bluemap.core.world.block.entity.BlockEntity;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class Commands<S> {
    private final Plugin plugin;
    private final CommandDispatcher<S> dispatcher;
    private final Function<S, CommandSource> commandSourceInterface;
    private final CommandHelper helper;

    public Commands(Plugin plugin, CommandDispatcher<S> dispatcher, Function<S, CommandSource> commandSourceInterface) {
        this.plugin = plugin;
        this.dispatcher = dispatcher;
        this.commandSourceInterface = commandSourceInterface;
        this.helper = new CommandHelper(plugin);
        this.init();
    }

    public void init() {
        LiteralCommandNode baseCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("bluemap").requires(this.requirementsUnloaded("bluemap.status"))).executes(this::statusCommand)).build();
        LiteralCommandNode versionCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("version").requires(this.requirementsUnloaded("bluemap.version"))).executes(this::versionCommand)).build();
        LiteralCommandNode helpCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("help").requires(this.requirementsUnloaded("bluemap.help"))).executes(this::helpCommand)).build();
        LiteralCommandNode reloadCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("reload").requires(this.requirementsUnloaded("bluemap.reload"))).executes(context -> this.reloadCommand(context, false))).then(this.literal("light").executes(context -> this.reloadCommand(context, true)))).build();
        LiteralCommandNode debugCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("debug").requires(this.requirementsUnloaded("bluemap.debug"))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("block").requires(this.requirements("bluemap.debug"))).executes(this::debugBlockCommand)).then(this.argument("world", (ArgumentType)StringArgumentType.string()).suggests(new WorldSuggestionProvider(this.plugin)).then(this.argument("x", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("y", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("z", (ArgumentType)DoubleArgumentType.doubleArg()).executes(this::debugBlockCommand))))))).then(((LiteralArgumentBuilder)this.literal("map").requires(this.requirements("bluemap.debug"))).then(((RequiredArgumentBuilder)this.argument("map", (ArgumentType)StringArgumentType.string()).suggests(new MapSuggestionProvider(this.plugin)).executes(this::debugMapCommand)).then(this.argument("x", (ArgumentType)IntegerArgumentType.integer()).then(this.argument("z", (ArgumentType)IntegerArgumentType.integer()).executes(this::debugMapCommand)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("flush").requires(this.requirements("bluemap.debug"))).executes(this::debugFlushCommand)).then(this.argument("world", (ArgumentType)StringArgumentType.string()).suggests(new WorldSuggestionProvider(this.plugin)).executes(this::debugFlushCommand)))).then(((LiteralArgumentBuilder)this.literal("cache").requires(this.requirements("bluemap.debug"))).executes(this::debugClearCacheCommand))).then(this.literal("dump").executes(this::debugDumpCommand))).build();
        LiteralCommandNode stopCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("stop").requires(this.requirements("bluemap.stop"))).executes(this::stopCommand)).build();
        LiteralCommandNode startCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("start").requires(this.requirements("bluemap.start"))).executes(this::startCommand)).build();
        LiteralCommandNode freezeCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("freeze").requires(this.requirements("bluemap.freeze"))).then(this.argument("map", (ArgumentType)StringArgumentType.string()).suggests(new MapSuggestionProvider(this.plugin)).executes(this::freezeCommand))).build();
        LiteralCommandNode unfreezeCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("unfreeze").requires(this.requirements("bluemap.freeze"))).then(this.argument("map", (ArgumentType)StringArgumentType.string()).suggests(new MapSuggestionProvider(this.plugin)).executes(this::unfreezeCommand))).build();
        LiteralCommandNode forceUpdateCommand = this.addRenderArguments((LiteralArgumentBuilder)this.literal("force-update").requires(this.requirements("bluemap.update.force")), this::forceUpdateCommand).build();
        LiteralCommandNode fixEdgesCommand = this.addRenderArguments((LiteralArgumentBuilder)this.literal("fix-edges").requires(this.requirements("bluemap.update.force")), this::fixEdgesCommand).build();
        LiteralCommandNode updateCommand = this.addRenderArguments((LiteralArgumentBuilder)this.literal("update").requires(this.requirements("bluemap.update")), this::updateCommand).build();
        LiteralCommandNode purgeCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("purge").requires(this.requirements("bluemap.purge"))).then(this.argument("map", (ArgumentType)StringArgumentType.string()).suggests(new MapSuggestionProvider(this.plugin)).executes(this::purgeCommand))).build();
        LiteralCommandNode cancelCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("cancel").requires(this.requirements("bluemap.cancel"))).executes(this::cancelCommand)).then(this.argument("task-ref", (ArgumentType)StringArgumentType.string()).suggests(new TaskRefSuggestionProvider(this.helper)).executes(this::cancelCommand))).build();
        LiteralCommandNode worldsCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("worlds").requires(this.requirements("bluemap.status"))).executes(this::worldsCommand)).build();
        LiteralCommandNode mapsCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("maps").requires(this.requirements("bluemap.status"))).executes(this::mapsCommand)).build();
        LiteralCommandNode storagesCommand = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.literal("storages").requires(this.requirements("bluemap.status"))).executes(this::storagesCommand)).then(((RequiredArgumentBuilder)this.argument("storage", (ArgumentType)StringArgumentType.string()).suggests(new StorageSuggestionProvider(this.plugin)).executes(this::storagesInfoCommand)).then(((LiteralArgumentBuilder)this.literal("delete").requires(this.requirements("bluemap.delete"))).then(this.argument("map", (ArgumentType)StringArgumentType.string()).executes(this::storagesDeleteMapCommand))))).build();
        this.dispatcher.getRoot().addChild((CommandNode)baseCommand);
        baseCommand.addChild((CommandNode)versionCommand);
        baseCommand.addChild((CommandNode)helpCommand);
        baseCommand.addChild((CommandNode)reloadCommand);
        baseCommand.addChild((CommandNode)debugCommand);
        baseCommand.addChild((CommandNode)stopCommand);
        baseCommand.addChild((CommandNode)startCommand);
        baseCommand.addChild((CommandNode)freezeCommand);
        baseCommand.addChild((CommandNode)unfreezeCommand);
        baseCommand.addChild((CommandNode)forceUpdateCommand);
        baseCommand.addChild((CommandNode)fixEdgesCommand);
        baseCommand.addChild((CommandNode)updateCommand);
        baseCommand.addChild((CommandNode)cancelCommand);
        baseCommand.addChild((CommandNode)purgeCommand);
        baseCommand.addChild((CommandNode)worldsCommand);
        baseCommand.addChild((CommandNode)mapsCommand);
        baseCommand.addChild((CommandNode)storagesCommand);
    }

    private <B extends ArgumentBuilder<S, B>> B addRenderArguments(B builder, Command<S> command) {
        return (B)builder.executes(command).then(this.argument("radius", (ArgumentType)IntegerArgumentType.integer()).executes(command)).then(this.argument("x", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("z", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("radius", (ArgumentType)IntegerArgumentType.integer()).executes(command)))).then(((RequiredArgumentBuilder)this.argument("world|map", (ArgumentType)StringArgumentType.string()).suggests(new WorldOrMapSuggestionProvider(this.plugin)).executes(command)).then(this.argument("x", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("z", (ArgumentType)DoubleArgumentType.doubleArg()).then(this.argument("radius", (ArgumentType)IntegerArgumentType.integer()).executes(command)))));
    }

    private Predicate<S> requirements(String permission) {
        return s2 -> {
            CommandSource source = this.commandSourceInterface.apply(s2);
            return this.plugin.isLoaded() && source.hasPermission(permission);
        };
    }

    private Predicate<S> requirementsUnloaded(String permission) {
        return s2 -> {
            CommandSource source = this.commandSourceInterface.apply(s2);
            return source.hasPermission(permission);
        };
    }

    private LiteralArgumentBuilder<S> literal(String name) {
        return LiteralArgumentBuilder.literal((String)name);
    }

    private <T> RequiredArgumentBuilder<S, T> argument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }

    private <T> Optional<T> getOptionalArgument(CommandContext<S> context, String argumentName, Class<T> type) {
        try {
            return Optional.of(context.getArgument(argumentName, type));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    private Optional<World> parseWorld(String worldId) {
        for (Map.Entry<String, World> entry : this.plugin.getBlueMap().getWorlds().entrySet()) {
            if (!entry.getKey().equals(worldId)) continue;
            return Optional.of(entry.getValue());
        }
        return Optional.empty();
    }

    private Optional<BmMap> parseMap(String mapId) {
        for (BmMap map : this.plugin.getBlueMap().getMaps().values()) {
            if (!map.getId().equals(mapId)) continue;
            return Optional.of(map);
        }
        return Optional.empty();
    }

    public int statusCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        if (!this.plugin.isLoaded()) {
            source.sendMessage(Text.of(TextColor.RED, "BlueMap is not loaded! Try /bluemap reload"));
            return 0;
        }
        new Thread(() -> source.sendMessages(this.helper.createStatusMessage()), "BlueMap-Plugin-StatusCommand").start();
        return 1;
    }

    public int versionCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        int renderThreadCount = 0;
        if (this.plugin.isLoaded()) {
            renderThreadCount = this.plugin.getRenderManager().getWorkerThreadCount();
        }
        String minecraftVersion = this.plugin.getServerInterface().getMinecraftVersion();
        source.sendMessage(Text.of(new Object[]{TextFormat.BOLD, TextColor.BLUE, "Version: ", TextColor.WHITE, BlueMap.VERSION}));
        source.sendMessage(Text.of(new Object[]{TextColor.GRAY, "Commit: ", TextColor.WHITE, BlueMap.GIT_HASH}));
        source.sendMessage(Text.of(new Object[]{TextColor.GRAY, "Implementation: ", TextColor.WHITE, this.plugin.getImplementationType()}));
        source.sendMessage(Text.of(new Object[]{TextColor.GRAY, "Minecraft: ", TextColor.WHITE, minecraftVersion}));
        source.sendMessage(Text.of(new Object[]{TextColor.GRAY, "Render-threads: ", TextColor.WHITE, renderThreadCount}));
        source.sendMessage(Text.of(new Object[]{TextColor.GRAY, "Available processors: ", TextColor.WHITE, Runtime.getRuntime().availableProcessors()}));
        source.sendMessage(Text.of(new Object[]{TextColor.GRAY, "Available memory: ", TextColor.WHITE, Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MiB"}));
        String clipboardValue = "Version: " + BlueMap.VERSION + "\nCommit: " + BlueMap.GIT_HASH + "\nImplementation: " + this.plugin.getImplementationType() + "\nMinecraft: " + minecraftVersion + "\nRender-threads: " + renderThreadCount + "\nAvailable processors: " + Runtime.getRuntime().availableProcessors() + "\nAvailable memory: " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + " MiB";
        source.sendMessage(Text.of(TextColor.DARK_GRAY, "[copy to clipboard]").setClickAction(Text.ClickAction.COPY_TO_CLIPBOARD, clipboardValue).setHoverText(Text.of(new Object[]{TextColor.GRAY, "click to copy the above text .. ", TextFormat.ITALIC, TextColor.GRAY, "duh!"})));
        return 1;
    }

    public int helpCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        source.sendMessage(Text.of(TextColor.BLUE, "BlueMap Commands:"));
        for (String usage : this.dispatcher.getAllUsage(this.dispatcher.getRoot().getChild("bluemap"), context.getSource(), true)) {
            String[] arguments;
            Text usageText = Text.of(TextColor.GREEN, "/bluemap");
            for (String arg : arguments = usage.split(" ")) {
                if (arg.isEmpty()) continue;
                if (arg.charAt(0) == '<' && arg.charAt(arg.length() - 1) == '>') {
                    usageText.addChild(Text.of(TextColor.GRAY, " " + arg));
                    continue;
                }
                usageText.addChild(Text.of(TextColor.WHITE, " " + arg));
            }
            source.sendMessage(usageText);
        }
        source.sendMessage(Text.of(TextColor.BLUE, "\nOpen this link to get a description for each command:\n").addChild(Text.of(TextColor.GRAY, "https://bluecolo.red/bluemap-commands").setClickAction(Text.ClickAction.OPEN_URL, "https://bluecolo.red/bluemap-commands")));
        return 1;
    }

    public int reloadCommand(CommandContext<S> context, boolean light) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        source.sendMessage(Text.of(TextColor.GOLD, "Reloading BlueMap..."));
        new Thread(() -> {
            try {
                if (light) {
                    this.plugin.lightReload();
                } else {
                    this.plugin.reload();
                }
                if (this.plugin.isLoaded()) {
                    source.sendMessage(Text.of(TextColor.GREEN, "BlueMap reloaded!"));
                } else {
                    source.sendMessage(Text.of(TextColor.RED, "Could not load BlueMap! See the console for details!"));
                }
            }
            catch (Exception ex) {
                Logger.global.logError("Failed to reload BlueMap!", ex);
                source.sendMessage(Text.of(TextColor.RED, "There was an error reloading BlueMap! See the console for details!"));
            }
        }, "BlueMap-Plugin-ReloadCommand").start();
        return 1;
    }

    public int debugClearCacheCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        for (World world : this.plugin.getBlueMap().getWorlds().values()) {
            world.invalidateChunkCache();
        }
        source.sendMessage(Text.of(TextColor.GREEN, "All caches cleared!"));
        return 1;
    }

    public int debugFlushCommand(CommandContext<S> context) {
        World world;
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        Optional<String> worldName = this.getOptionalArgument(context, "world", String.class);
        if (worldName.isPresent()) {
            world = this.parseWorld(worldName.get()).orElse(null);
            if (world == null) {
                source.sendMessage(Text.of(new Object[]{TextColor.RED, "There is no ", this.helper.worldHelperHover(), " with this id: ", TextColor.WHITE, worldName.get()}));
                return 0;
            }
        } else {
            world = source.getWorld().orElse(null);
            if (world == null) {
                source.sendMessage(Text.of(TextColor.RED, "Can't detect a location from this command-source, you'll have to define a world!"));
                return 0;
            }
        }
        new Thread(() -> {
            source.sendMessage(Text.of(TextColor.GOLD, "Saving world and flushing changes..."));
            try {
                if (this.plugin.flushWorldUpdates(world)) {
                    source.sendMessage(Text.of(TextColor.GREEN, "Successfully saved and flushed all changes."));
                } else {
                    source.sendMessage(Text.of(TextColor.RED, "This operation is not supported by this implementation (" + this.plugin.getImplementationType() + ")"));
                }
            }
            catch (IOException ex) {
                source.sendMessage(Text.of(TextColor.RED, "There was an unexpected exception trying to save the world. Please check the console for more details..."));
                Logger.global.logError("Unexpected exception trying to save the world!", ex);
            }
        }, "BlueMap-Plugin-DebugFlushCommand").start();
        return 1;
    }

    public int debugMapCommand(CommandContext<S> context) {
        Vector2i position;
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        String mapId = (String)context.getArgument("map", String.class);
        Optional<Integer> x = this.getOptionalArgument(context, "x", Integer.class);
        Optional<Integer> z = this.getOptionalArgument(context, "z", Integer.class);
        BmMap map = this.parseMap(mapId).orElse(null);
        if (map == null) {
            source.sendMessage(Text.of(new Object[]{TextColor.RED, "There is no ", this.helper.mapHelperHover(), " with this id: ", TextColor.WHITE, mapId}));
            return 0;
        }
        if (x.isPresent() && z.isPresent()) {
            position = new Vector2i(x.get(), z.get());
        } else {
            position = source.getPosition().map(v -> v.toVector2(true)).map(Vector2d::floor).map(Vector2d::toInt).orElse(null);
            if (position == null) {
                source.sendMessage(Text.of(TextColor.RED, "Can't detect a location from this command-source, you'll have to define a position!"));
                return 0;
            }
        }
        new Thread(() -> {
            Grid chunkGrid = map.getWorld().getChunkGrid();
            Grid regionGrid = map.getWorld().getRegionGrid();
            Grid tileGrid = map.getHiresModelManager().getTileGrid();
            Vector2i regionPos = regionGrid.getCell(position);
            final Vector2i chunkPos = chunkGrid.getCell(position);
            Vector2i tilePos = tileGrid.getCell(position);
            TileInfoRegion.TileInfo tileInfo = map.getMapTileState().get(tilePos.getX(), tilePos.getY());
            int lastChunkHash = map.getMapChunkState().get(chunkPos.getX(), chunkPos.getY());
            int currentChunkHash = 0;
            try {
                class FindHashConsumer
                implements ChunkConsumer.ListOnly {
                    public int timestamp = 0;

                    FindHashConsumer() {
                    }

                    @Override
                    public void accept(int chunkX, int chunkZ, int timestamp) {
                        if (chunkPos.getX() == chunkX && chunkPos.getY() == chunkZ) {
                            this.timestamp = timestamp;
                        }
                    }
                }
                FindHashConsumer findHashConsumer = new FindHashConsumer();
                map.getWorld().getRegion(regionPos.getX(), regionPos.getY()).iterateAllChunks(findHashConsumer);
                currentChunkHash = findHashConsumer.timestamp;
            }
            catch (IOException e) {
                Logger.global.logError("Failed to load chunk-hash.", e);
            }
            LinkedHashMap<String, Object> lines = new LinkedHashMap<String, Object>();
            lines.put("region-pos", regionPos);
            lines.put("chunk-pos", chunkPos);
            lines.put("chunk-curr-hash", currentChunkHash);
            lines.put("chunk-last-hash", lastChunkHash);
            lines.put("tile-pos", tilePos);
            lines.put("tile-render-time", tileInfo.getRenderTime());
            lines.put("tile-state", tileInfo.getState().getKey().getFormatted());
            source.sendMessage(Text.of(TextColor.GOLD, "Map tile info:"));
            source.sendMessage(this.formatMap(lines));
        }, "BlueMap-Plugin-DebugMapCommand").start();
        return 1;
    }

    public int debugBlockCommand(CommandContext<S> context) {
        Vector3d position;
        World world;
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        Optional<String> worldName = this.getOptionalArgument(context, "world", String.class);
        Optional<Double> x = this.getOptionalArgument(context, "x", Double.class);
        Optional<Double> y = this.getOptionalArgument(context, "y", Double.class);
        Optional<Double> z = this.getOptionalArgument(context, "z", Double.class);
        if (worldName.isPresent() && x.isPresent() && y.isPresent() && z.isPresent()) {
            world = this.parseWorld(worldName.get()).orElse(null);
            position = new Vector3d(x.get(), y.get(), z.get());
            if (world == null) {
                source.sendMessage(Text.of(new Object[]{TextColor.RED, "There is no ", this.helper.worldHelperHover(), " with this id: ", TextColor.WHITE, worldName.get()}));
                return 0;
            }
        } else {
            world = source.getWorld().orElse(null);
            position = source.getPosition().orElse(null);
            if (world == null || position == null) {
                source.sendMessage(Text.of(TextColor.RED, "Can't detect a location from this command-source, you'll have to define a world and position!"));
                return 0;
            }
        }
        new Thread(() -> {
            Vector3i blockPos = position.floor().toInt();
            Block block = new Block(world, blockPos.getX(), blockPos.getY(), blockPos.getZ());
            Block blockBelow = new Block(world, blockPos.getX(), blockPos.getY() - 1, blockPos.getZ());
            source.sendMessages(Arrays.asList(Text.of(new Object[]{TextColor.GOLD, "Block at you: \n", this.formatBlock(block)}), Text.of(new Object[]{TextColor.GOLD, "Block below you: \n", this.formatBlock(blockBelow)})));
        }, "BlueMap-Plugin-DebugBlockCommand").start();
        return 1;
    }

    private Text formatBlock(Block<?> block) {
        World world = block.getWorld();
        Chunk chunk = block.getChunk();
        LinkedHashMap<String, Object> lines = new LinkedHashMap<String, Object>();
        lines.put("world-id", world.getId());
        lines.put("world-name", world.getName());
        lines.put("chunk-is-generated", chunk.isGenerated());
        lines.put("chunk-has-lightdata", chunk.hasLightData());
        lines.put("chunk-inhabited-time", chunk.getInhabitedTime());
        lines.put("block-state", block.getBlockState());
        lines.put("biome", block.getBiome().getKey());
        lines.put("position", block.getX() + " | " + block.getY() + " | " + block.getZ());
        lines.put("block-light", block.getBlockLightLevel());
        lines.put("sun-light", block.getSunLightLevel());
        BlockEntity blockEntity = block.getBlockEntity();
        if (blockEntity != null) {
            lines.put("block-entity", blockEntity);
        }
        return this.formatMap(lines);
    }

    private Text formatMap(Map<String, Object> lines) {
        Object[] textElements = lines.entrySet().stream().flatMap(e -> Stream.of(new Object[]{TextColor.GRAY, e.getKey(), ": ", TextColor.WHITE, e.getValue(), "\n"})).toArray(Object[]::new);
        textElements[textElements.length - 1] = "";
        return Text.of(textElements);
    }

    public int debugDumpCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        try {
            Path file = this.plugin.getBlueMap().getConfig().getCoreConfig().getData().resolve("dump.json");
            StateDumper.global().dump(file);
            source.sendMessage(Text.of(TextColor.GREEN, "Dump created at: " + String.valueOf(file)));
            return 1;
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to create dump!", ex);
            source.sendMessage(Text.of(TextColor.RED, "Exception trying to create dump! See console for details."));
            return 0;
        }
    }

    public int stopCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        if (!this.plugin.getRenderManager().isRunning()) {
            source.sendMessage(Text.of(TextColor.RED, "Render-Threads are already stopped!"));
            return 0;
        }
        new Thread(() -> {
            this.plugin.getPluginState().setRenderThreadsEnabled(false);
            this.plugin.getRenderManager().stop();
            source.sendMessage(Text.of(TextColor.GREEN, "Render-Threads stopped!"));
            this.plugin.save();
        }, "BlueMap-Plugin-StopCommand").start();
        return 1;
    }

    public int startCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        if (this.plugin.getRenderManager().isRunning()) {
            source.sendMessage(Text.of(TextColor.RED, "Render-Threads are already running!"));
            return 0;
        }
        new Thread(() -> {
            this.plugin.getPluginState().setRenderThreadsEnabled(true);
            this.plugin.getRenderManager().start(this.plugin.getBlueMap().getConfig().getCoreConfig().resolveRenderThreadCount());
            source.sendMessage(Text.of(TextColor.GREEN, "Render-Threads started!"));
            this.plugin.save();
        }, "BlueMap-Plugin-StartCommand").start();
        return 1;
    }

    public int freezeCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        String mapString = (String)context.getArgument("map", String.class);
        BmMap map = this.parseMap(mapString).orElse(null);
        if (map == null) {
            source.sendMessage(Text.of(new Object[]{TextColor.RED, "There is no ", this.helper.mapHelperHover(), " with this id: ", TextColor.WHITE, mapString}));
            return 0;
        }
        PluginState.MapState mapState = this.plugin.getPluginState().getMapState(map);
        if (!mapState.isUpdateEnabled()) {
            source.sendMessage(Text.of(TextColor.RED, "This map is already frozen!"));
            return 0;
        }
        new Thread(() -> {
            mapState.setUpdateEnabled(false);
            this.plugin.stopWatchingMap(map);
            this.plugin.getRenderManager().removeRenderTasksIf(task -> {
                if (task instanceof MapUpdateTask) {
                    return ((MapUpdateTask)task).getMap().equals(map);
                }
                if (task instanceof WorldRegionRenderTask) {
                    return ((WorldRegionRenderTask)task).getMap().equals(map);
                }
                return false;
            });
            source.sendMessage(Text.of(new Object[]{TextColor.GREEN, "Map ", TextColor.WHITE, mapString, TextColor.GREEN, " is now frozen and will no longer be automatically updated!"}));
            source.sendMessage(Text.of(TextColor.GRAY, "Any currently scheduled updates for this map have been cancelled."));
            this.plugin.save();
        }, "BlueMap-Plugin-FreezeCommand").start();
        return 1;
    }

    public int unfreezeCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        String mapString = (String)context.getArgument("map", String.class);
        BmMap map = this.parseMap(mapString).orElse(null);
        if (map == null) {
            source.sendMessage(Text.of(new Object[]{TextColor.RED, "There is no ", this.helper.mapHelperHover(), " with this id: ", TextColor.WHITE, mapString}));
            return 0;
        }
        PluginState.MapState mapState = this.plugin.getPluginState().getMapState(map);
        if (mapState.isUpdateEnabled()) {
            source.sendMessage(Text.of(TextColor.RED, "This map is not frozen!"));
            return 0;
        }
        new Thread(() -> {
            mapState.setUpdateEnabled(true);
            this.plugin.startWatchingMap(map);
            this.plugin.getRenderManager().scheduleRenderTask(new MapUpdateTask(map));
            source.sendMessage(Text.of(new Object[]{TextColor.GREEN, "Map ", TextColor.WHITE, mapString, TextColor.GREEN, " is no longer frozen and will be automatically updated!"}));
            this.plugin.save();
        }, "BlueMap-Plugin-UnfreezeCommand").start();
        return 1;
    }

    public int forceUpdateCommand(CommandContext<S> context) {
        return this.updateCommand(context, s2 -> true);
    }

    public int fixEdgesCommand(CommandContext<S> context) {
        return this.updateCommand(context, s2 -> s2 == TileState.RENDERED_EDGE);
    }

    public int updateCommand(CommandContext<S> context) {
        return this.updateCommand(context, s2 -> false);
    }

    public int updateCommand(CommandContext<S> context, Predicate<TileState> force) {
        Vector2i center;
        int radius;
        BmMap mapToRender;
        World worldToRender;
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        Optional<String> worldOrMap = this.getOptionalArgument(context, "world|map", String.class);
        if (worldOrMap.isPresent()) {
            worldToRender = this.parseWorld(worldOrMap.get()).orElse(null);
            if (worldToRender == null) {
                mapToRender = this.parseMap(worldOrMap.get()).orElse(null);
                if (mapToRender == null) {
                    source.sendMessage(Text.of(new Object[]{TextColor.RED, "There is no ", this.helper.worldHelperHover(), " or ", this.helper.mapHelperHover(), " with this id: ", TextColor.WHITE, worldOrMap.get()}));
                    return 0;
                }
            } else {
                mapToRender = null;
            }
        } else {
            worldToRender = source.getWorld().orElse(null);
            mapToRender = null;
            if (worldToRender == null) {
                source.sendMessage(Text.of(TextColor.RED, "Can't detect a world from this command-source, you'll have to define a world or a map to update!"));
                return 0;
            }
        }
        if ((radius = this.getOptionalArgument(context, "radius", Integer.class).orElse(-1).intValue()) >= 0) {
            Optional<Double> x = this.getOptionalArgument(context, "x", Double.class);
            Optional<Double> z = this.getOptionalArgument(context, "z", Double.class);
            if (x.isPresent() && z.isPresent()) {
                center = new Vector2i(x.get(), z.get());
            } else {
                Vector3d position = source.getPosition().orElse(null);
                if (position == null) {
                    source.sendMessage(Text.of(TextColor.RED, "Can't detect a position from this command-source, you'll have to define x,z coordinates to update with a radius!"));
                    return 0;
                }
                center = position.toVector2(true).floor().toInt();
            }
        } else {
            center = null;
        }
        new Thread(() -> {
            try {
                ArrayList<BmMap> maps = new ArrayList<BmMap>();
                if (worldToRender != null) {
                    this.plugin.flushWorldUpdates(worldToRender);
                    for (BmMap map : this.plugin.getBlueMap().getMaps().values()) {
                        if (!map.getWorld().equals(worldToRender)) continue;
                        maps.add(map);
                    }
                } else {
                    this.plugin.flushWorldUpdates(mapToRender.getWorld());
                    maps.add(mapToRender);
                }
                if (maps.isEmpty()) {
                    source.sendMessage(Text.of(TextColor.RED, "No map has been found for this world that could be updated!"));
                    return;
                }
                for (BmMap map : maps) {
                    MapUpdateTask updateTask = new MapUpdateTask(map, center, radius, force);
                    this.plugin.getRenderManager().scheduleRenderTask(updateTask);
                    source.sendMessage(Text.of(new Object[]{TextColor.GREEN, "Created new Update-Task for map '" + map.getId() + "' ", TextColor.GRAY, "(" + updateTask.getRegions().size() + " regions, ~" + (long)updateTask.getRegions().size() * 1024L + " chunks)"}));
                }
                source.sendMessage(Text.of(new Object[]{TextColor.GREEN, "Use ", TextColor.GRAY, "/bluemap", TextColor.GREEN, " to see the progress."}));
            }
            catch (IOException ex) {
                source.sendMessage(Text.of(TextColor.RED, "There was an unexpected exception trying to save the world. Please check the console for more details..."));
                Logger.global.logError("Unexpected exception trying to save the world!", ex);
            }
        }, "BlueMap-Plugin-UpdateCommand").start();
        return 1;
    }

    public int cancelCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        Optional<String> ref = this.getOptionalArgument(context, "task-ref", String.class);
        if (ref.isEmpty()) {
            this.plugin.getRenderManager().removeAllRenderTasks();
            source.sendMessage(Text.of(TextColor.GREEN, "All tasks cancelled!"));
            source.sendMessage(Text.of(TextColor.GRAY, "(Note, that an already started task might not be removed immediately. Some tasks needs to do some tidying-work first)"));
            return 1;
        }
        Optional<RenderTask> task = this.helper.getTaskForRef(ref.get());
        if (task.isEmpty()) {
            source.sendMessage(Text.of(TextColor.RED, "There is no task with this reference '" + ref.get() + "'!"));
            return 0;
        }
        if (this.plugin.getRenderManager().removeRenderTask(task.get())) {
            source.sendMessage(Text.of(TextColor.GREEN, "Task cancelled!"));
            source.sendMessage(Text.of(TextColor.GRAY, "(Note, that an already started task might not be removed immediately. Some tasks needs to do some tidying-work first)"));
            return 1;
        }
        source.sendMessage(Text.of(TextColor.RED, "This task is either completed or got cancelled already!"));
        return 0;
    }

    public int purgeCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        String mapString = (String)context.getArgument("map", String.class);
        BmMap map = this.parseMap(mapString).orElse(null);
        if (map == null) {
            source.sendMessage(Text.of(new Object[]{TextColor.RED, "There is no ", this.helper.mapHelperHover(), " with this id: ", TextColor.WHITE, mapString}));
            return 0;
        }
        new Thread(() -> {
            try {
                MapPurgeTask purgeTask = new MapPurgeTask(map);
                this.plugin.getRenderManager().scheduleRenderTaskNext(purgeTask);
                source.sendMessage(Text.of(TextColor.GREEN, "Created new Task to purge map '" + map.getId() + "'"));
                RenderTask currentRenderTask = this.plugin.getRenderManager().getCurrentRenderTask();
                if (currentRenderTask instanceof MapUpdateTask && ((MapUpdateTask)currentRenderTask).getMap().getId().equals(map.getId())) {
                    currentRenderTask.cancel();
                }
                if (this.plugin.getPluginState().getMapState(map).isUpdateEnabled()) {
                    MapUpdateTask updateTask = new MapUpdateTask(map);
                    this.plugin.getRenderManager().scheduleRenderTask(updateTask);
                    source.sendMessage(Text.of(TextColor.GREEN, "Created new Update-Task for map '" + map.getId() + "'"));
                    source.sendMessage(Text.of(new Object[]{TextColor.GRAY, "If you don't want this map to render again after the purge, use ", TextColor.DARK_GRAY, "/bluemap freeze " + map.getId(), TextColor.GRAY, " first!"}));
                }
                source.sendMessage(Text.of(new Object[]{TextColor.GREEN, "Use ", TextColor.GRAY, "/bluemap", TextColor.GREEN, " to see the progress."}));
            }
            catch (IllegalArgumentException e) {
                source.sendMessage(Text.of(TextColor.RED, "There was an error trying to purge '" + map.getId() + "', see console for details."));
                Logger.global.logError("Failed to purge map '" + map.getId() + "'!", e);
            }
        }, "BlueMap-Plugin-PurgeCommand").start();
        return 1;
    }

    public int worldsCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        source.sendMessage(Text.of(TextColor.BLUE, "Worlds loaded by BlueMap:"));
        for (Map.Entry<String, World> entry : this.plugin.getBlueMap().getWorlds().entrySet()) {
            source.sendMessage(Text.of(new Object[]{TextColor.GRAY, " - ", TextColor.WHITE, entry.getKey()}));
        }
        return 1;
    }

    public int mapsCommand(CommandContext<S> context) {
        ArrayList<Text> lines = new ArrayList<Text>();
        lines.add(Text.of(TextColor.BLUE, "Maps loaded by BlueMap:"));
        for (BmMap map : this.plugin.getBlueMap().getMaps().values()) {
            boolean frozen = !this.plugin.getPluginState().getMapState(map).isUpdateEnabled();
            lines.add(Text.of(new Object[]{TextColor.GRAY, " - ", TextColor.WHITE, map.getId(), TextColor.GRAY, " (" + map.getName() + ")"}));
            lines.add(Text.of(new Object[]{TextColor.GRAY, "\u00a0\u00a0\u00a0World: ", TextColor.DARK_GRAY, map.getWorld().getId()}));
            lines.add(Text.of(new Object[]{TextColor.GRAY, "\u00a0\u00a0\u00a0Last Update: ", TextColor.DARK_GRAY, this.helper.formatTime((long)map.getMapTileState().getLastRenderTime() * 1000L)}));
            if (!frozen) continue;
            lines.add(Text.of(new Object[]{TextColor.AQUA, TextFormat.ITALIC, "\u00a0\u00a0\u00a0This map is frozen!"}));
        }
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        source.sendMessages(lines);
        return 1;
    }

    public int storagesCommand(CommandContext<S> context) {
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        source.sendMessage(Text.of(TextColor.BLUE, "Storages loaded by BlueMap:"));
        for (Map.Entry<String, StorageConfig> entry : this.plugin.getBlueMap().getConfig().getStorageConfigs().entrySet()) {
            String storageTypeKey = "?";
            try {
                storageTypeKey = entry.getValue().getStorageType().getKey().getFormatted();
            }
            catch (ConfigurationException configurationException) {
                // empty catch block
            }
            source.sendMessage(Text.of(new Object[]{TextColor.GRAY, " - ", TextColor.WHITE, entry.getKey()}).setHoverText(Text.of(storageTypeKey)).setClickAction(Text.ClickAction.RUN_COMMAND, "/bluemap storages " + entry.getKey()));
        }
        return 1;
    }

    public int storagesInfoCommand(CommandContext<S> context) {
        List<String> mapIds;
        Storage storage;
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        String storageId = (String)context.getArgument("storage", String.class);
        try {
            storage = this.plugin.getBlueMap().getOrLoadStorage(storageId);
        }
        catch (ConfigurationException | InterruptedException ex) {
            Logger.global.logError("Unexpected exception trying to load storage '" + storageId + "'!", ex);
            source.sendMessage(Text.of(TextColor.RED, "There was an unexpected exception trying to load this storage. Please check the console for more details..."));
            return 0;
        }
        try {
            mapIds = storage.mapIds().toList();
        }
        catch (IOException ex) {
            Logger.global.logError("Unexpected exception trying to load mapIds from storage '" + storageId + "'!", ex);
            source.sendMessage(Text.of(TextColor.RED, "There was an unexpected exception trying to access this storage. Please check the console for more details..."));
            return 0;
        }
        source.sendMessage(Text.of(new Object[]{TextColor.BLUE, "Storage '", storageId, "':"}));
        if (mapIds.isEmpty()) {
            source.sendMessage(Text.of(TextColor.GRAY, " <empty storage>"));
        } else {
            for (String mapId : mapIds) {
                boolean isLoaded;
                BmMap map = this.plugin.getBlueMap().getMaps().get(mapId);
                boolean bl = isLoaded = map != null && map.getStorage().equals(storage.map(mapId));
                if (isLoaded) {
                    source.sendMessage(Text.of(new Object[]{TextColor.GRAY, " - ", TextColor.WHITE, mapId, TextColor.GREEN, TextFormat.ITALIC, " (loaded)"}));
                    continue;
                }
                source.sendMessage(Text.of(new Object[]{TextColor.GRAY, " - ", TextColor.WHITE, mapId, TextColor.DARK_GRAY, TextFormat.ITALIC, " (unloaded/static/remote)"}));
            }
        }
        return 1;
    }

    public int storagesDeleteMapCommand(CommandContext<S> context) {
        boolean isLoaded;
        MapStorage storage;
        CommandSource source = this.commandSourceInterface.apply(context.getSource());
        String storageId = (String)context.getArgument("storage", String.class);
        String mapId = (String)context.getArgument("map", String.class);
        try {
            storage = this.plugin.getBlueMap().getOrLoadStorage(storageId).map(mapId);
        }
        catch (ConfigurationException | InterruptedException ex) {
            Logger.global.logError("Unexpected exception trying to load storage '" + storageId + "'!", ex);
            source.sendMessage(Text.of(TextColor.RED, "There was an unexpected exception trying to load this storage. Please check the console for more details..."));
            return 0;
        }
        BmMap map = this.plugin.getBlueMap().getMaps().get(mapId);
        boolean bl = isLoaded = map != null && map.getStorage().equals(storage);
        if (isLoaded) {
            Text purgeCommand = Text.of(TextColor.WHITE, "/bluemap purge " + mapId).setClickAction(Text.ClickAction.SUGGEST_COMMAND, "/bluemap purge " + mapId);
            source.sendMessage(Text.of(new Object[]{TextColor.RED, "Can't delete a loaded map!\nUnload the map by removing its config-file first,\nor use ", purgeCommand, " if you want to purge it."}));
            return 0;
        }
        StorageDeleteTask deleteTask = new StorageDeleteTask(storage, mapId);
        this.plugin.getRenderManager().scheduleRenderTaskNext(deleteTask);
        source.sendMessage(Text.of(TextColor.GREEN, "Created new Task to delete map '" + mapId + "' from storage '" + storageId + "'"));
        return 1;
    }
}

