/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.rendermanager;

import de.bluecolored.bluemap.common.debug.DebugDump;
import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import de.bluecolored.bluemap.core.map.BmMap;
import java.util.Objects;

public class MapPurgeTask
implements RenderTask {
    private final BmMap map;
    private volatile double progress;
    private volatile boolean hasMoreWork;
    private volatile boolean cancelled;

    public MapPurgeTask(BmMap map) {
        this.map = Objects.requireNonNull(map);
        this.progress = 0.0;
        this.hasMoreWork = true;
        this.cancelled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doWork() throws Exception {
        MapPurgeTask mapPurgeTask = this;
        synchronized (mapPurgeTask) {
            if (!this.hasMoreWork) {
                return;
            }
            this.hasMoreWork = false;
        }
        if (this.cancelled) {
            return;
        }
        this.map.getLowresTileManager().discard();
        this.map.getStorage().delete(progress -> {
            this.progress = progress;
            return !this.cancelled;
        });
        this.map.resetTextureGallery();
        this.map.getMapTileState().reset();
        this.map.getMapChunkState().reset();
    }

    @Override
    public boolean hasMoreWork() {
        return this.hasMoreWork && !this.cancelled;
    }

    @Override
    @DebugDump
    public double estimateProgress() {
        return this.progress;
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    @Override
    public boolean contains(RenderTask task) {
        if (task == this) {
            return true;
        }
        if (task instanceof MapPurgeTask) {
            return this.map.equals(((MapPurgeTask)task).map);
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Purge map " + this.map.getId();
    }
}

