/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.rendermanager;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.common.rendermanager.CombinedRenderTask;
import de.bluecolored.bluemap.common.rendermanager.MapSaveTask;
import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import de.bluecolored.bluemap.common.rendermanager.WorldRegionRenderTask;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.BmMap;
import de.bluecolored.bluemap.core.map.renderstate.MapTileState;
import de.bluecolored.bluemap.core.map.renderstate.TileInfoRegion;
import de.bluecolored.bluemap.core.map.renderstate.TileState;
import de.bluecolored.bluemap.core.storage.GridStorage;
import de.bluecolored.bluemap.core.storage.compression.CompressedInputStream;
import de.bluecolored.bluemap.core.util.Grid;
import de.bluecolored.bluemap.core.world.World;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class MapUpdateTask
extends CombinedRenderTask<RenderTask> {
    private final BmMap map;
    private final Collection<Vector2i> regions;

    public MapUpdateTask(BmMap map) {
        this(map, MapUpdateTask.getRegions(map));
    }

    public MapUpdateTask(BmMap map, Predicate<TileState> force) {
        this(map, MapUpdateTask.getRegions(map), force);
    }

    public MapUpdateTask(BmMap map, Vector2i center, int radius) {
        this(map, MapUpdateTask.getRegions(map, center, radius));
    }

    public MapUpdateTask(BmMap map, Vector2i center, int radius, Predicate<TileState> force) {
        this(map, MapUpdateTask.getRegions(map, center, radius), force);
    }

    public MapUpdateTask(BmMap map, Collection<Vector2i> regions) {
        this(map, regions, s2 -> false);
    }

    public MapUpdateTask(BmMap map, Collection<Vector2i> regions, Predicate<TileState> force) {
        super("Update map '" + map.getId() + "'", MapUpdateTask.createTasks(map, regions, force));
        this.map = map;
        this.regions = Collections.unmodifiableCollection(new ArrayList<Vector2i>(regions));
    }

    public BmMap getMap() {
        return this.map;
    }

    public Collection<Vector2i> getRegions() {
        return this.regions;
    }

    private static Collection<RenderTask> createTasks(BmMap map, Collection<Vector2i> regions, Predicate<TileState> force) {
        ArrayList<WorldRegionRenderTask> regionTasks = new ArrayList<WorldRegionRenderTask>(regions.size());
        regions.forEach(region -> regionTasks.add(new WorldRegionRenderTask(map, (Vector2i)region, force)));
        World world = map.getWorld();
        Vector2i spawnPoint = world.getSpawnPoint().toVector2(true);
        Grid regionGrid = world.getRegionGrid();
        Vector2i spawnRegion = regionGrid.getCell(spawnPoint);
        regionTasks.sort(WorldRegionRenderTask.defaultComparator(spawnRegion));
        ArrayList<RenderTask> tasks = new ArrayList<RenderTask>(regionTasks.size() + 2);
        tasks.add(new MapSaveTask(map));
        tasks.addAll(regionTasks);
        tasks.add(new MapSaveTask(map));
        return tasks;
    }

    private static Collection<Vector2i> getRegions(BmMap map) {
        return MapUpdateTask.getRegions(map, null, -1);
    }

    private static Collection<Vector2i> getRegions(BmMap map, Vector2i center, int radius) {
        Predicate<Vector2i> regionRadiusFilter;
        World world = map.getWorld();
        Grid regionGrid = world.getRegionGrid();
        Predicate<Vector2i> regionBoundsFilter = map.getMapSettings().getCellRenderBoundariesFilter(regionGrid, true);
        if (center == null || radius < 0) {
            regionRadiusFilter = r -> true;
        } else {
            Vector2i halfCell = regionGrid.getGridSize().div(2);
            long increasedRadiusSquared = (long)Math.pow((double)radius + Math.ceil(halfCell.length()), 2.0);
            regionRadiusFilter = r -> {
                Vector2i min2 = regionGrid.getCellMin((Vector2i)r);
                Vector2i regionCenter = min2.add(halfCell);
                return regionCenter.toLong().distanceSquared(center.toLong()) <= increasedRadiusSquared;
            };
        }
        HashSet<Vector2i> regions = new HashSet<Vector2i>();
        world.listRegions().stream().filter(regionBoundsFilter).filter(regionRadiusFilter).forEach(regions::add);
        Grid tileGrid = map.getHiresModelManager().getTileGrid();
        Grid cellGrid = MapTileState.GRID.multiply(tileGrid);
        try (Stream<GridStorage.Cell> stream = map.getStorage().tileState().stream();){
            stream.filter(c -> {
                try (CompressedInputStream in = c.read();){
                    TileState[] states;
                    if (in == null) {
                        boolean bl = false;
                        return bl;
                    }
                    for (TileState state : states = TileInfoRegion.loadPalette(in.decompress())) {
                        if (state == TileState.UNKNOWN || state == TileState.NOT_GENERATED) continue;
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                catch (IOException ignore) {
                    return true;
                }
            }).map(c -> new Vector2i(c.getX(), c.getZ())).flatMap(v -> cellGrid.getIntersecting((Vector2i)v, regionGrid).stream()).filter(regionRadiusFilter).forEach(regions::add);
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to load map tile state!", ex);
        }
        return regions;
    }
}

