/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.common.rendermanager;

import de.bluecolored.bluemap.common.rendermanager.ProgressTracker;
import de.bluecolored.bluemap.common.rendermanager.RenderTask;
import de.bluecolored.bluemap.core.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;

public class RenderManager {
    private static final AtomicInteger nextRenderManagerIndex = new AtomicInteger(0);
    private final int id = nextRenderManagerIndex.getAndIncrement();
    private volatile boolean running = false;
    private long lastTimeBusy = -1L;
    private final AtomicInteger nextWorkerThreadIndex = new AtomicInteger(0);
    private final Collection<WorkerThread> workerThreads = new ConcurrentLinkedDeque<WorkerThread>();
    private final AtomicInteger busyCount = new AtomicInteger(0);
    private ProgressTracker progressTracker = null;
    private volatile boolean newTask = true;
    private final LinkedList<RenderTask> renderTasks = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int threadCount) throws IllegalStateException {
        if (threadCount <= 0) {
            throw new IllegalArgumentException("threadCount has to be 1 or more!");
        }
        Collection<WorkerThread> collection = this.workerThreads;
        synchronized (collection) {
            if (this.isRunning()) {
                throw new IllegalStateException("RenderManager is already running!");
            }
            this.workerThreads.clear();
            this.busyCount.set(0);
            if (this.progressTracker != null) {
                this.progressTracker.cancel();
            }
            this.progressTracker = new ProgressTracker(5000L, 12);
            this.newTask = true;
            this.running = true;
            for (int i = 0; i < threadCount; ++i) {
                WorkerThread worker = new WorkerThread();
                this.workerThreads.add(worker);
                worker.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Collection<WorkerThread> collection = this.workerThreads;
        synchronized (collection) {
            this.running = false;
            for (WorkerThread worker : this.workerThreads) {
                worker.interrupt();
            }
            if (this.progressTracker != null) {
                this.progressTracker.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Collection<WorkerThread> collection = this.workerThreads;
        synchronized (collection) {
            for (WorkerThread worker : this.workerThreads) {
                if (!worker.isAlive()) continue;
                return true;
            }
            return false;
        }
    }

    public void awaitIdle() throws InterruptedException {
        this.awaitIdle(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitIdle(boolean log) throws InterruptedException {
        LinkedList<RenderTask> linkedList = this.renderTasks;
        synchronized (linkedList) {
            while (!this.renderTasks.isEmpty()) {
                RenderTask task;
                this.renderTasks.wait(5000L);
                if (!log || (task = this.getCurrentRenderTask()) == null) continue;
                Logger.global.logInfo("Waiting for task '" + task.getDescription() + "' to stop.. (" + (double)Math.round(task.estimateProgress() * 10000.0) / 100.0 + "%)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitShutdown() throws InterruptedException {
        Collection<WorkerThread> collection = this.workerThreads;
        synchronized (collection) {
            while (this.isRunning()) {
                this.workerThreads.wait(10000L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleRenderTask(RenderTask task) {
        LinkedList<RenderTask> linkedList = this.renderTasks;
        synchronized (linkedList) {
            if (this.containsRenderTask(task)) {
                return false;
            }
            this.removeTasksThatAreContainedIn(task);
            this.renderTasks.addLast(task);
            this.renderTasks.notifyAll();
            return true;
        }
    }

    public int scheduleRenderTasks(RenderTask ... tasks) {
        return this.scheduleRenderTasks(Arrays.asList(tasks));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scheduleRenderTasks(Collection<RenderTask> tasks) {
        LinkedList<RenderTask> linkedList = this.renderTasks;
        synchronized (linkedList) {
            int count = 0;
            for (RenderTask task : tasks) {
                if (!this.scheduleRenderTask(task)) continue;
                ++count;
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scheduleRenderTaskNext(RenderTask task) {
        LinkedList<RenderTask> linkedList = this.renderTasks;
        synchronized (linkedList) {
            if (this.renderTasks.size() <= 1) {
                return this.scheduleRenderTask(task);
            }
            if (this.containsRenderTask(task)) {
                return false;
            }
            this.removeTasksThatAreContainedIn(task);
            this.renderTasks.add(1, task);
            this.renderTasks.notifyAll();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reorderRenderTasks(Comparator<RenderTask> taskComparator) {
        LinkedList<RenderTask> linkedList = this.renderTasks;
        synchronized (linkedList) {
            if (this.renderTasks.size() <= 2) {
                return;
            }
            RenderTask currentTask = this.renderTasks.removeFirst();
            this.renderTasks.sort(taskComparator);
            this.renderTasks.addFirst(currentTask);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRenderTask(RenderTask task) {
        LinkedList<RenderTask> linkedList = this.renderTasks;
        synchronized (linkedList) {
            if (this.renderTasks.isEmpty()) {
                return false;
            }
            RenderTask first = this.renderTasks.getFirst();
            if (first.equals(task)) {
                first.cancel();
                return true;
            }
            return this.renderTasks.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRenderTasksIf(Predicate<RenderTask> removeCondition) {
        LinkedList<RenderTask> linkedList = this.renderTasks;
        synchronized (linkedList) {
            if (this.renderTasks.isEmpty()) {
                return;
            }
            RenderTask first = this.renderTasks.removeFirst();
            if (removeCondition.test(first)) {
                first.cancel();
            }
            this.renderTasks.removeIf(removeCondition);
            this.renderTasks.addFirst(first);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRenderTasks() {
        LinkedList<RenderTask> linkedList = this.renderTasks;
        synchronized (linkedList) {
            if (this.renderTasks.isEmpty()) {
                return;
            }
            RenderTask first = this.renderTasks.removeFirst();
            first.cancel();
            this.renderTasks.clear();
            this.renderTasks.addFirst(first);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long estimateCurrentRenderTaskTimeRemaining() {
        if (this.progressTracker == null) {
            return 0L;
        }
        LinkedList<RenderTask> linkedList = this.renderTasks;
        synchronized (linkedList) {
            RenderTask task = this.getCurrentRenderTask();
            if (task == null) {
                return 0L;
            }
            double progress = task.estimateProgress();
            long timePerProgress = this.progressTracker.getAverageTimePerProgress();
            return (long)((1.0 - progress) * (double)timePerProgress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderTask getCurrentRenderTask() {
        LinkedList<RenderTask> linkedList = this.renderTasks;
        synchronized (linkedList) {
            if (this.renderTasks.isEmpty()) {
                return null;
            }
            return this.renderTasks.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RenderTask> getScheduledRenderTasks() {
        LinkedList<RenderTask> linkedList = this.renderTasks;
        synchronized (linkedList) {
            return new ArrayList<RenderTask>(this.renderTasks);
        }
    }

    public int getScheduledRenderTaskCount() {
        return this.renderTasks.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsRenderTask(RenderTask task) {
        LinkedList<RenderTask> linkedList = this.renderTasks;
        synchronized (linkedList) {
            Iterator iterator = this.renderTasks.iterator();
            if (!iterator.hasNext()) {
                return false;
            }
            iterator.next();
            while (iterator.hasNext()) {
                if (!((RenderTask)iterator.next()).contains(task)) continue;
                return true;
            }
            return false;
        }
    }

    public int getWorkerThreadCount() {
        return this.workerThreads.size();
    }

    public long getLastTimeBusy() {
        return this.lastTimeBusy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTasksThatAreContainedIn(RenderTask containingTask) {
        LinkedList<RenderTask> linkedList = this.renderTasks;
        synchronized (linkedList) {
            if (this.renderTasks.size() < 2) {
                return;
            }
            RenderTask first = this.renderTasks.removeFirst();
            if (containingTask.contains(first)) {
                first.cancel();
            }
            this.renderTasks.removeIf(containingTask::contains);
            this.renderTasks.addFirst(first);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() throws Exception {
        RenderTask task;
        LinkedList<RenderTask> linkedList = this.renderTasks;
        synchronized (linkedList) {
            while (this.renderTasks.isEmpty()) {
                this.renderTasks.wait(10000L);
            }
            task = this.renderTasks.getFirst();
            if (this.newTask) {
                this.newTask = false;
                this.progressTracker.resetAndStart(task::estimateProgress);
            }
            if (!task.hasMoreWork()) {
                if (this.busyCount.get() <= 0) {
                    this.renderTasks.removeFirst();
                    this.renderTasks.notifyAll();
                    this.newTask = true;
                    this.busyCount.set(0);
                } else {
                    this.renderTasks.wait(10000L);
                }
                return;
            }
            this.busyCount.incrementAndGet();
            this.lastTimeBusy = System.currentTimeMillis();
        }
        try {
            task.doWork();
        }
        finally {
            linkedList = this.renderTasks;
            synchronized (linkedList) {
                int busyCount = this.busyCount.decrementAndGet();
                if (busyCount > 0) {
                    this.lastTimeBusy = System.currentTimeMillis();
                }
                this.renderTasks.notifyAll();
            }
        }
    }

    public class WorkerThread
    extends Thread {
        private final int id;

        private WorkerThread() {
            this.id = RenderManager.this.nextWorkerThreadIndex.getAndIncrement();
            this.setName("RenderManager-" + RenderManager.this.id + "-" + this.id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (RenderManager.this.running) {
                    try {
                        RenderManager.this.doWork();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        Logger.global.logError("RenderManager(" + RenderManager.this.id + "): WorkerThread(" + this.id + "): Exception while doing some work!", e);
                        try {
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                return;
            }
            finally {
                Collection<WorkerThread> collection = RenderManager.this.workerThreads;
                synchronized (collection) {
                    RenderManager.this.workerThreads.remove(this);
                    RenderManager.this.workerThreads.notifyAll();
                }
            }
        }
    }
}

