/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.logger;

import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.shadow.benmanes.caffeine.cache.Cache;
import de.bluecolored.shadow.benmanes.caffeine.cache.Caffeine;
import java.util.concurrent.TimeUnit;

public abstract class AbstractLogger
extends Logger {
    private static final Object DUMMY = new Object();
    private Cache<String, Object> noFloodCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).expireAfterWrite(10L, TimeUnit.MINUTES).maximumSize(10000L).build();

    @Override
    public void noFloodError(String key, String message, Throwable throwable) {
        if (this.check(key)) {
            this.logError(message, throwable);
        }
    }

    @Override
    public void noFloodWarning(String key, String message) {
        if (this.check(key)) {
            this.logWarning(message);
        }
    }

    @Override
    public void noFloodInfo(String key, String message) {
        if (this.check(key)) {
            this.logInfo(message);
        }
    }

    @Override
    public void noFloodDebug(String key, String message) {
        if (this.check(key)) {
            this.logDebug(message);
        }
    }

    @Override
    public void clearNoFloodLog() {
        this.noFloodCache.invalidateAll();
        this.noFloodCache.cleanUp();
    }

    @Override
    public void removeNoFloodKey(String key) {
        this.noFloodCache.invalidate(key);
    }

    private boolean check(String key) {
        if (this.noFloodCache.getIfPresent(key) == null) {
            this.noFloodCache.put(key, DUMMY);
            return true;
        }
        return false;
    }
}

