/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.TileMetaConsumer;
import de.bluecolored.bluemap.core.map.hires.HiresModelRenderer;
import de.bluecolored.bluemap.core.map.hires.PRBMWriter;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.TileModel;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.storage.GridStorage;
import de.bluecolored.bluemap.core.util.Grid;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.World;
import java.io.IOException;
import java.io.OutputStream;

public class HiresModelManager {
    private final GridStorage storage;
    private final HiresModelRenderer renderer;
    private final Grid tileGrid;

    public HiresModelManager(GridStorage storage, ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings, Grid tileGrid) {
        this(storage, new HiresModelRenderer(resourcePack, textureGallery, renderSettings), tileGrid);
    }

    public HiresModelManager(GridStorage storage, HiresModelRenderer renderer, Grid tileGrid) {
        this.storage = storage;
        this.renderer = renderer;
        this.tileGrid = tileGrid;
    }

    public void render(World world, Vector2i tile, TileMetaConsumer tileMetaConsumer, boolean save) {
        Vector2i tileMin = this.tileGrid.getCellMin(tile);
        Vector2i tileMax = this.tileGrid.getCellMax(tile);
        Vector3i modelMin = new Vector3i(tileMin.getX(), Integer.MIN_VALUE, tileMin.getY());
        Vector3i modelMax = new Vector3i(tileMax.getX(), Integer.MAX_VALUE, tileMax.getY());
        TileModel model = TileModel.instancePool().claimInstance();
        this.renderer.render(world, modelMin, modelMax, model, tileMetaConsumer);
        if (save) {
            model.sort();
            this.save(model, tile);
        }
        TileModel.instancePool().recycleInstance(model);
    }

    public void unrender(Vector2i tile, TileMetaConsumer tileMetaConsumer) {
        try {
            this.storage.delete(tile.getX(), tile.getY());
        }
        catch (IOException ex) {
            Logger.global.logError("Failed to delete hires model: " + String.valueOf(tile), ex);
        }
        Color color = new Color();
        this.tileGrid.forEachIntersecting(tile, Grid.UNIT, (x, z) -> tileMetaConsumer.set(x, z, color, 0, 0));
    }

    private void save(TileModel model, Vector2i tile) {
        try (OutputStream out = this.storage.write(tile.getX(), tile.getY());
             PRBMWriter modelWriter = new PRBMWriter(out);){
            modelWriter.write(model);
        }
        catch (IOException e) {
            Logger.global.logError("Failed to save hires model: " + String.valueOf(tile), e);
        }
    }

    public Grid getTileGrid() {
        return this.tileGrid;
    }
}

