/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.map.TextureGallery;
import de.bluecolored.bluemap.core.map.TileMetaConsumer;
import de.bluecolored.bluemap.core.map.hires.BlockModelView;
import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.map.hires.TileModel;
import de.bluecolored.bluemap.core.map.hires.blockmodel.BlockStateModelFactory;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.util.math.Color;
import de.bluecolored.bluemap.core.world.Chunk;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.bluemap.core.world.block.BlockNeighborhood;

public class HiresModelRenderer {
    private final ResourcePack resourcePack;
    private final TextureGallery textureGallery;
    private final RenderSettings renderSettings;

    public HiresModelRenderer(ResourcePack resourcePack, TextureGallery textureGallery, RenderSettings renderSettings) {
        this.resourcePack = resourcePack;
        this.textureGallery = textureGallery;
        this.renderSettings = renderSettings;
    }

    public void render(World world, Vector3i modelMin, Vector3i modelMax, TileModel model) {
        this.render(world, modelMin, modelMax, model, (x, z, c, h2, l) -> {});
    }

    public void render(World world, Vector3i modelMin, Vector3i modelMax, TileModel model, TileMetaConsumer tileMetaConsumer) {
        Vector3i min2 = modelMin.max(this.renderSettings.getMinPos());
        Vector3i max = modelMax.min(this.renderSettings.getMaxPos());
        Vector3i modelAnchor = new Vector3i(modelMin.getX(), 0, modelMin.getZ());
        BlockStateModelFactory modelFactory = new BlockStateModelFactory(this.resourcePack, this.textureGallery, this.renderSettings);
        Color columnColor = new Color();
        Color blockColor = new Color();
        BlockNeighborhood block = new BlockNeighborhood(this.resourcePack, this.renderSettings, world, 0, 0, 0);
        BlockModelView blockModel = new BlockModelView(model);
        for (int x = modelMin.getX(); x <= modelMax.getX(); ++x) {
            for (int z = modelMin.getZ(); z <= modelMax.getZ(); ++z) {
                int maxHeight = Integer.MIN_VALUE;
                double topBlockLight = 0.0;
                columnColor.set(0.0f, 0.0f, 0.0f, 0.0f, true);
                if (this.renderSettings.isInsideRenderBoundaries(x, z)) {
                    int maxY;
                    Chunk chunk = world.getChunkAtBlock(x, z);
                    int minY = Math.max(min2.getY(), chunk.getMinY(x, z));
                    for (int y = maxY = Math.min(max.getY(), chunk.getMaxY(x, z)); y >= minY; --y) {
                        block.set(x, y, z);
                        if (!block.isInsideRenderBounds()) continue;
                        blockModel.initialize();
                        modelFactory.render(block, blockModel, blockColor);
                        topBlockLight = Math.max(topBlockLight, (double)((float)block.getBlockLightLevel() * (1.0f - columnColor.a)));
                        if (blockModel.getSize() <= 0) continue;
                        blockModel.translate(x - modelAnchor.getX(), y - modelAnchor.getY(), z - modelAnchor.getZ());
                        if (!(blockColor.a > 0.0f)) continue;
                        if (maxHeight < y) {
                            maxHeight = y;
                        }
                        columnColor.underlay(blockColor.premultiplied());
                    }
                }
                if (maxHeight == Integer.MIN_VALUE) {
                    maxHeight = 0;
                }
                tileMetaConsumer.set(x, z, columnColor, maxHeight, (int)topBlockLight);
            }
        }
    }
}

