/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import de.bluecolored.bluemap.core.map.hires.TileModel;
import de.bluecolored.bluemap.core.util.math.VectorM3f;
import de.bluecolored.bluemap.core.util.stream.CountingOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class PRBMWriter
implements Closeable {
    private static final int FORMAT_VERSION = 1;
    private static final int HEADER_BITS = 7;
    private static final int ATTRIBUTE_TYPE_FLOAT = 0;
    private static final int ATTRIBUTE_TYPE_INTEGER = 128;
    private static final int ATTRIBUTE_NOT_NORMALIZED = 0;
    private static final int ATTRIBUTE_NORMALIZED = 64;
    private static final int ATTRIBUTE_CARDINALITY_SCALAR = 0;
    private static final int ATTRIBUTE_CARDINALITY_2D_VEC = 16;
    private static final int ATTRIBUTE_CARDINALITY_3D_VEC = 32;
    private static final int ATTRIBUTE_CARDINALITY_4D_VEC = 48;
    private static final int ATTRIBUTE_ENCODING_SIGNED_32BIT_FLOAT = 1;
    private static final int ATTRIBUTE_ENCODING_SIGNED_8BIT_INT = 3;
    private static final int ATTRIBUTE_ENCODING_SIGNED_16BIT_INT = 4;
    private static final int ATTRIBUTE_ENCODING_SIGNED_32BIT_INT = 6;
    private static final int ATTRIBUTE_ENCODING_UNSIGNED_8BIT_INT = 7;
    private static final int ATTRIBUTE_ENCODING_UNSIGNED_16BIT_INT = 8;
    private static final int ATTRIBUTE_ENCODING_UNSIGNED_32BIT_INT = 10;
    private final CountingOutputStream out;

    public PRBMWriter(OutputStream out) {
        this.out = new CountingOutputStream(out);
    }

    public void write(TileModel model) throws IOException {
        this.out.write(1);
        this.out.write(7);
        this.write3byteValue(model.size * 3);
        this.write3byteValue(0);
        this.writePositionArray(model);
        this.writeNormalArray(model);
        this.writeColorArray(model);
        this.writeUvArray(model);
        this.writeAoArray(model);
        this.writeBlocklightArray(model);
        this.writeSunlightArray(model);
        this.writeMaterialGroups(model);
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    private void writePositionArray(TileModel model) throws IOException {
        float[] position = model.position;
        this.writeString("position");
        this.out.write(33);
        this.writePadding();
        int posSize = model.size * 9;
        for (int i = 0; i < posSize; ++i) {
            this.writeFloat(position[i]);
        }
    }

    private void writeNormalArray(TileModel model) throws IOException {
        VectorM3f normal = new VectorM3f(0.0f, 0.0f, 0.0f);
        float[] position = model.position;
        this.writeString("normal");
        this.out.write(99);
        this.writePadding();
        for (int i = 0; i < model.size; ++i) {
            int pi = i * 9;
            this.calculateSurfaceNormal(position[pi], position[pi + 1], position[pi + 2], position[pi + 3], position[pi + 4], position[pi + 5], position[pi + 6], position[pi + 7], position[pi + 8], normal);
            for (int j = 0; j < 3; ++j) {
                this.writeNormalizedSignedByteValue(normal.x);
                this.writeNormalizedSignedByteValue(normal.y);
                this.writeNormalizedSignedByteValue(normal.z);
            }
        }
    }

    private void writeColorArray(TileModel model) throws IOException {
        float[] color = model.color;
        this.writeString("color");
        this.out.write(103);
        this.writePadding();
        int colorSize = model.size * 3;
        for (int i = 0; i < colorSize; i += 3) {
            for (int j = 0; j < 3; ++j) {
                this.writeNormalizedUnsignedByteValue(color[i]);
                this.writeNormalizedUnsignedByteValue(color[i + 1]);
                this.writeNormalizedUnsignedByteValue(color[i + 2]);
            }
        }
    }

    private void writeUvArray(TileModel model) throws IOException {
        float[] uv = model.uv;
        this.writeString("uv");
        this.out.write(17);
        this.writePadding();
        int uvSize = model.size * 6;
        for (int i = 0; i < uvSize; ++i) {
            this.writeFloat(uv[i]);
        }
    }

    private void writeAoArray(TileModel model) throws IOException {
        float[] ao = model.ao;
        this.writeString("ao");
        this.out.write(71);
        this.writePadding();
        int uvSize = model.size * 3;
        for (int i = 0; i < uvSize; ++i) {
            this.writeNormalizedUnsignedByteValue(ao[i]);
        }
    }

    private void writeBlocklightArray(TileModel model) throws IOException {
        byte[] blocklight = model.blocklight;
        this.writeString("blocklight");
        this.out.write(3);
        this.writePadding();
        int blSize = model.size * 1;
        for (int i = 0; i < blSize; ++i) {
            this.out.write(blocklight[i]);
            this.out.write(blocklight[i]);
            this.out.write(blocklight[i]);
        }
    }

    private void writeSunlightArray(TileModel model) throws IOException {
        byte[] sunlight = model.sunlight;
        this.writeString("sunlight");
        this.out.write(3);
        this.writePadding();
        int slSize = model.size * 1;
        for (int i = 0; i < slSize; ++i) {
            this.out.write(sunlight[i]);
            this.out.write(sunlight[i]);
            this.out.write(sunlight[i]);
        }
    }

    private void writeMaterialGroups(TileModel model) throws IOException {
        this.writePadding();
        if (model.size > 0) {
            int lastMaterial;
            int[] materialIndex = model.materialIndex;
            int miSize = model.size * 1;
            int material = lastMaterial = materialIndex[0];
            int groupStart = 0;
            this.write4byteValue(material);
            this.write4byteValue(0);
            for (int i = 1; i < miSize; ++i) {
                material = materialIndex[i];
                if (material != lastMaterial) {
                    this.write4byteValue((i - groupStart) * 3);
                    groupStart = i;
                    this.write4byteValue(material);
                    this.write4byteValue(groupStart * 3);
                }
                lastMaterial = material;
            }
            this.write4byteValue((miSize - groupStart) * 3);
        }
        this.write4byteValue(-1);
    }

    private void writePadding() throws IOException {
        int paddingBytes = (int)(-this.out.getCount() & 3L);
        for (int i = 0; i < paddingBytes; ++i) {
            this.out.write(0);
        }
    }

    private void write2byteValue(int value) throws IOException {
        if (value > 65535) {
            throw new IOException("Value too high: " + value);
        }
        this.out.write(value & 0xFF);
        this.out.write(value >> 8 & 0xFF);
    }

    private void write3byteValue(int value) throws IOException {
        if (value > 0xFFFFFF) {
            throw new IOException("Value too high: " + value);
        }
        this.out.write(value & 0xFF);
        this.out.write(value >> 8 & 0xFF);
        this.out.write(value >> 16 & 0xFF);
    }

    private void write4byteValue(int value) throws IOException {
        this.out.write(value & 0xFF);
        this.out.write(value >> 8 & 0xFF);
        this.out.write(value >> 16 & 0xFF);
        this.out.write(value >> 24 & 0xFF);
    }

    private void writeFloat(float value) throws IOException {
        this.write4byteValue(Float.floatToIntBits(value));
    }

    private void writeNormalizedSignedByteValue(float value) throws IOException {
        byte normalized = (byte)((double)(value * 128.0f) - 0.5);
        this.out.write(normalized & 0xFF);
    }

    private void writeNormalizedUnsignedByteValue(float value) throws IOException {
        int normalized = (int)(value * 255.0f);
        this.out.write(normalized & 0xFF);
    }

    private void writeString(String value) throws IOException {
        this.out.write(value.getBytes(StandardCharsets.US_ASCII));
        this.out.write(0);
    }

    private void calculateSurfaceNormal(float p1x, float p1y, float p1z, float p2x, float p2y, float p2z, float p3x, float p3y, float p3z, VectorM3f target) {
        p2x -= p1x;
        p3x -= p1x;
        p1x = (p2y -= p1y) * (p3z -= p1z) - (p2z -= p1z) * (p3y -= p1y);
        p1y = p2z * p3x - p2x * p3z;
        p1z = p2x * p3y - p2y * p3x;
        float length = (float)Math.sqrt(p1x * p1x + p1y * p1y + p1z * p1z);
        target.set(p1x /= length, p1y /= length, p1z /= length);
    }
}

