/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import com.flowpowered.math.vector.Vector2i;
import com.flowpowered.math.vector.Vector3i;
import de.bluecolored.bluemap.core.util.Grid;
import java.util.function.Predicate;

public interface RenderSettings {
    public static final Vector3i DEFAULT_MIN = Vector3i.from(Integer.MIN_VALUE);
    public static final Vector3i DEFAULT_MAX = Vector3i.from(Integer.MAX_VALUE);

    public int getRemoveCavesBelowY();

    public int getCaveDetectionOceanFloor();

    public boolean isCaveDetectionUsesBlockLight();

    default public Vector3i getMinPos() {
        return DEFAULT_MIN;
    }

    default public Vector3i getMaxPos() {
        return DEFAULT_MAX;
    }

    public float getAmbientLight();

    default public boolean isRenderEdges() {
        return true;
    }

    default public boolean isIgnoreMissingLightData() {
        return false;
    }

    default public boolean isInsideRenderBoundaries(int x, int z) {
        Vector3i min2 = this.getMinPos();
        Vector3i max = this.getMaxPos();
        return x >= min2.getX() && x <= max.getX() && z >= min2.getZ() && z <= max.getZ();
    }

    default public boolean isInsideRenderBoundaries(int x, int y, int z) {
        Vector3i min2 = this.getMinPos();
        Vector3i max = this.getMaxPos();
        return x >= min2.getX() && x <= max.getX() && z >= min2.getZ() && z <= max.getZ() && y >= min2.getY() && y <= max.getY();
    }

    default public boolean isInsideRenderBoundaries(Vector2i cell, Grid grid, boolean allowPartiallyIncludedCells) {
        Vector2i cellMax;
        Vector2i cellMin;
        Vector2i vector2i = cellMin = allowPartiallyIncludedCells ? grid.getCellMin(cell) : grid.getCellMax(cell);
        if (cellMin.getX() > this.getMaxPos().getX()) {
            return false;
        }
        if (cellMin.getY() > this.getMaxPos().getZ()) {
            return false;
        }
        Vector2i vector2i2 = cellMax = allowPartiallyIncludedCells ? grid.getCellMax(cell) : grid.getCellMin(cell);
        if (cellMax.getX() < this.getMinPos().getX()) {
            return false;
        }
        return cellMax.getY() >= this.getMinPos().getZ();
    }

    default public Predicate<Vector2i> getCellRenderBoundariesFilter(Grid grid, boolean allowPartiallyIncludedCells) {
        return cell -> this.isInsideRenderBoundaries((Vector2i)cell, grid, allowPartiallyIncludedCells);
    }

    public boolean isSaveHiresLayer();
}

