/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.hires;

import com.flowpowered.math.TrigMath;
import de.bluecolored.bluemap.core.util.InstancePool;
import de.bluecolored.bluemap.core.util.MergeSort;
import de.bluecolored.bluemap.core.util.math.MatrixM3f;
import de.bluecolored.bluemap.core.util.math.MatrixM4f;

public class TileModel {
    private static final double GROW_MULTIPLIER = 1.5;
    static final int FI_POSITION = 9;
    static final int FI_UV = 6;
    static final int FI_AO = 3;
    static final int FI_COLOR = 3;
    static final int FI_SUNLIGHT = 1;
    static final int FI_BLOCKLIGHT = 1;
    static final int FI_MATERIAL_INDEX = 1;
    private static final InstancePool<TileModel> INSTANCE_POOL = new InstancePool<TileModel>(() -> new TileModel(100), TileModel::clear);
    private int capacity;
    int size;
    float[] position;
    float[] color;
    float[] uv;
    float[] ao;
    byte[] sunlight;
    byte[] blocklight;
    int[] materialIndex;
    int[] materialIndexSort;
    int[] materialIndexSortSupport;
    float[] indexedPosition;
    int[] positionIndex;

    public TileModel(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity is negative");
        }
        this.setCapacity(initialCapacity);
        this.clear();
    }

    public int size() {
        return this.size;
    }

    public int add(int count) {
        this.ensureCapacity(count);
        int start = this.size;
        this.size += count;
        return start;
    }

    public TileModel setPositions(int face, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3) {
        int index = face * 9;
        this.position[index] = x1;
        this.position[index + 1] = y1;
        this.position[index + 2] = z1;
        this.position[index + 3] = x2;
        this.position[index + 3 + 1] = y2;
        this.position[index + 3 + 2] = z2;
        this.position[index + 6] = x3;
        this.position[index + 6 + 1] = y3;
        this.position[index + 6 + 2] = z3;
        return this;
    }

    public TileModel setUvs(int face, float u1, float v1, float u2, float v2, float u3, float v3) {
        int index = face * 6;
        this.uv[index] = u1;
        this.uv[index + 1] = v1;
        this.uv[index + 2] = u2;
        this.uv[index + 2 + 1] = v2;
        this.uv[index + 4] = u3;
        this.uv[index + 4 + 1] = v3;
        return this;
    }

    public TileModel setAOs(int face, float ao1, float ao2, float ao3) {
        int index = face * 3;
        this.ao[index] = ao1;
        this.ao[index + 1] = ao2;
        this.ao[index + 2] = ao3;
        return this;
    }

    public TileModel setColor(int face, float r, float g2, float b) {
        int index = face * 3;
        this.color[index] = r;
        this.color[index + 1] = g2;
        this.color[index + 2] = b;
        return this;
    }

    public TileModel setSunlight(int face, int sl) {
        this.sunlight[face * 1] = (byte)sl;
        return this;
    }

    public TileModel setBlocklight(int face, int bl) {
        this.blocklight[face * 1] = (byte)bl;
        return this;
    }

    public TileModel setMaterialIndex(int face, int m4) {
        this.materialIndex[face * 1] = m4;
        return this;
    }

    public TileModel rotate(int start, int count, float angle, float axisX, float axisY, float axisZ) {
        double halfAngle = Math.toRadians(angle) * 0.5;
        double q = (double)TrigMath.sin(halfAngle) / Math.sqrt(axisX * axisX + axisY * axisY + axisZ * axisZ);
        double qx = (double)axisX * q;
        double qy = (double)axisY * q;
        double qz = (double)axisZ * q;
        double qw = TrigMath.cos(halfAngle);
        double qLength = Math.sqrt(qx * qx + qy * qy + qz * qz + qw * qw);
        return this.rotateByQuaternion(start, count, qx /= qLength, qy /= qLength, qz /= qLength, qw /= qLength);
    }

    public TileModel rotate(int start, int count, float pitch, float yaw, float roll) {
        double halfYaw = Math.toRadians(yaw) * 0.5;
        double qy1 = TrigMath.sin(halfYaw);
        double qw1 = TrigMath.cos(halfYaw);
        double halfPitch = Math.toRadians(pitch) * 0.5;
        double qx2 = TrigMath.sin(halfPitch);
        double qw2 = TrigMath.cos(halfPitch);
        double halfRoll = Math.toRadians(roll) * 0.5;
        double qz3 = TrigMath.sin(halfRoll);
        double qw3 = TrigMath.cos(halfRoll);
        double qxA = qw1 * qx2;
        double qyA = qy1 * qw2;
        double qzA = -qy1 * qx2;
        double qwA = qw1 * qw2;
        double qx = qxA * qw3 + qyA * qz3;
        double qy = qyA * qw3 - qxA * qz3;
        double qz = qwA * qz3 + qzA * qw3;
        double qw = qwA * qw3 - qzA * qz3;
        return this.rotateByQuaternion(start, count, qx, qy, qz, qw);
    }

    public TileModel rotateByQuaternion(int start, int count, double qx, double qy, double qz, double qw) {
        int end = start + count;
        for (int face = start; face < end; ++face) {
            for (int i = 0; i < 3; ++i) {
                int index = face * 9 + i * 3;
                double x = this.position[index];
                double y = this.position[index + 1];
                double z = this.position[index + 2];
                double px = qw * x + qy * z - qz * y;
                double py = qw * y + qz * x - qx * z;
                double pz = qw * z + qx * y - qy * x;
                double pw = -qx * x - qy * y - qz * z;
                this.position[index] = (float)(pw * -qx + px * qw - py * qz + pz * qy);
                this.position[index + 1] = (float)(pw * -qy + py * qw - pz * qx + px * qz);
                this.position[index + 2] = (float)(pw * -qz + pz * qw - px * qy + py * qx);
            }
        }
        return this;
    }

    public TileModel scale(int start, int count, float sx, float sy, float sz) {
        int end = start + count;
        for (int face = start; face < end; ++face) {
            for (int i = 0; i < 3; ++i) {
                int index;
                int n = index = face * 9 + i * 3;
                this.position[n] = this.position[n] * sx;
                int n2 = index + 1;
                this.position[n2] = this.position[n2] * sy;
                int n3 = index + 2;
                this.position[n3] = this.position[n3] * sz;
            }
        }
        return this;
    }

    public TileModel translate(int start, int count, float dx, float dy, float dz) {
        int end = start + count;
        for (int face = start; face < end; ++face) {
            for (int i = 0; i < 3; ++i) {
                int index;
                int n = index = face * 9 + i * 3;
                this.position[n] = this.position[n] + dx;
                int n2 = index + 1;
                this.position[n2] = this.position[n2] + dy;
                int n3 = index + 2;
                this.position[n3] = this.position[n3] + dz;
            }
        }
        return this;
    }

    public TileModel transform(int start, int count, MatrixM3f t2) {
        return this.transform(start, count, t2.m00, t2.m01, t2.m02, t2.m10, t2.m11, t2.m12, t2.m20, t2.m21, t2.m22);
    }

    public TileModel transform(int start, int count, float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        return this.transform(start, count, m00, m01, m02, 0.0f, m10, m11, m12, 0.0f, m20, m21, m22, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public TileModel transform(int start, int count, MatrixM4f t2) {
        return this.transform(start, count, t2.m00, t2.m01, t2.m02, t2.m03, t2.m10, t2.m11, t2.m12, t2.m13, t2.m20, t2.m21, t2.m22, t2.m23, t2.m30, t2.m31, t2.m32, t2.m33);
    }

    public TileModel transform(int start, int count, float m00, float m01, float m02, float m03, float m10, float m11, float m12, float m13, float m20, float m21, float m22, float m23, float m30, float m31, float m32, float m33) {
        int end = start + count;
        for (int face = start; face < end; ++face) {
            for (int i = 0; i < 3; ++i) {
                int index = face * 9 + i * 3;
                float x = this.position[index];
                float y = this.position[index + 1];
                float z = this.position[index + 2];
                this.position[index] = m00 * x + m01 * y + m02 * z + m03;
                this.position[index + 1] = m10 * x + m11 * y + m12 * z + m13;
                this.position[index + 2] = m20 * x + m21 * y + m22 * z + m23;
            }
        }
        return this;
    }

    public TileModel reset(int size) {
        this.size = size;
        return this;
    }

    public TileModel clear() {
        this.size = 0;
        return this;
    }

    private void ensureCapacity(int count) {
        if (this.size + count > this.capacity) {
            float[] _position = this.position;
            float[] _color = this.color;
            float[] _uv = this.uv;
            float[] _ao = this.ao;
            byte[] _sunlight = this.sunlight;
            byte[] _blocklight = this.blocklight;
            int[] _materialIndex = this.materialIndex;
            int newCapacity = (int)((double)this.capacity * 1.5) + count;
            this.setCapacity(newCapacity);
            System.arraycopy(_position, 0, this.position, 0, this.size * 9);
            System.arraycopy(_uv, 0, this.uv, 0, this.size * 6);
            System.arraycopy(_ao, 0, this.ao, 0, this.size * 3);
            System.arraycopy(_color, 0, this.color, 0, this.size * 3);
            System.arraycopy(_sunlight, 0, this.sunlight, 0, this.size * 1);
            System.arraycopy(_blocklight, 0, this.blocklight, 0, this.size * 1);
            System.arraycopy(_materialIndex, 0, this.materialIndex, 0, this.size * 1);
        }
    }

    private void setCapacity(int capacity) {
        this.capacity = capacity;
        this.position = new float[capacity * 9];
        this.uv = new float[capacity * 6];
        this.ao = new float[capacity * 3];
        this.color = new float[capacity * 3];
        this.sunlight = new byte[capacity * 1];
        this.blocklight = new byte[capacity * 1];
        this.materialIndex = new int[capacity * 1];
        this.materialIndexSort = new int[this.materialIndex.length];
        this.materialIndexSortSupport = new int[this.materialIndex.length];
    }

    public void sort() {
        if (this.size <= 1) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            this.materialIndexSort[i] = i;
            this.materialIndexSortSupport[i] = i;
        }
        MergeSort.mergeSortInt(this.materialIndexSort, 0, this.size, this::compareMaterialIndex, this.materialIndexSortSupport);
        for (int i = 0; i < this.size; ++i) {
            int s2 = this.materialIndexSort[i];
            int c = 0;
            while (s2 < i) {
                s2 = this.materialIndexSort[s2];
                if (c++ <= this.size) continue;
                throw new IllegalStateException();
            }
            this.swap(i, s2);
        }
    }

    private int compareMaterialIndex(int i1, int i2) {
        return Integer.compare(this.materialIndex[i1], this.materialIndex[i2]);
    }

    private void swap(int face1, int face2) {
        float vf;
        int i;
        int if1 = face1 * 9;
        int if2 = face2 * 9;
        for (i = 0; i < 9; ++i) {
            vf = this.position[if1 + i];
            this.position[if1 + i] = this.position[if2 + i];
            this.position[if2 + i] = vf;
        }
        if1 = face1 * 6;
        if2 = face2 * 6;
        for (i = 0; i < 6; ++i) {
            vf = this.uv[if1 + i];
            this.uv[if1 + i] = this.uv[if2 + i];
            this.uv[if2 + i] = vf;
        }
        if1 = face1 * 3;
        if2 = face2 * 3;
        for (i = 0; i < 3; ++i) {
            vf = this.ao[if1 + i];
            this.ao[if1 + i] = this.ao[if2 + i];
            this.ao[if2 + i] = vf;
        }
        if1 = face1 * 3;
        if2 = face2 * 3;
        for (i = 0; i < 3; ++i) {
            vf = this.color[if1 + i];
            this.color[if1 + i] = this.color[if2 + i];
            this.color[if2 + i] = vf;
        }
        byte vb = this.sunlight[face1];
        this.sunlight[face1] = this.sunlight[face2];
        this.sunlight[face2] = vb;
        vb = this.blocklight[face1];
        this.blocklight[face1] = this.blocklight[face2];
        this.blocklight[face2] = vb;
        int vi = this.materialIndex[face1];
        this.materialIndex[face1] = this.materialIndex[face2];
        this.materialIndex[face2] = vi;
    }

    public static InstancePool<TileModel> instancePool() {
        return INSTANCE_POOL;
    }
}

