/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.renderstate;

import de.bluecolored.bluemap.core.map.renderstate.CellStorage;
import de.bluecolored.shadow.bluenbt.NBTName;
import de.bluecolored.shadow.bluenbt.NBTPostDeserialize;

public class ChunkInfoRegion
implements CellStorage.Cell {
    static final int REGION_LENGTH = 128;
    static final int REGION_MASK = 127;
    static final int CHUNKS_PER_REGION = 16384;
    @NBTName(value={"chunk-hashes"})
    private int[] chunkHashes;
    private transient boolean modified;

    private ChunkInfoRegion() {
    }

    @NBTPostDeserialize
    public void init() {
        if (this.chunkHashes == null || this.chunkHashes.length != 16384) {
            this.chunkHashes = new int[16384];
        }
    }

    public int get(int x, int z) {
        return this.chunkHashes[ChunkInfoRegion.index(x, z)];
    }

    public int set(int x, int z, int hash) {
        int index = ChunkInfoRegion.index(x, z);
        int previous = this.chunkHashes[index];
        this.chunkHashes[index] = hash;
        if (previous != hash) {
            this.modified = true;
        }
        return previous;
    }

    private static int index(int x, int z) {
        return (z & 0x7F) << 7 | x & 0x7F;
    }

    public static ChunkInfoRegion create() {
        ChunkInfoRegion region = new ChunkInfoRegion();
        region.init();
        return region;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }
}

