/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.map.renderstate;

import com.google.gson.reflect.TypeToken;
import de.bluecolored.bluemap.core.map.renderstate.CellStorage;
import de.bluecolored.bluemap.core.map.renderstate.TileState;
import de.bluecolored.bluemap.core.util.RegistryAdapter;
import de.bluecolored.shadow.bluenbt.BlueNBT;
import de.bluecolored.shadow.bluenbt.NBTName;
import de.bluecolored.shadow.bluenbt.NBTPostDeserialize;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class TileInfoRegion
implements CellStorage.Cell {
    private static final int REGION_LENGTH = 32;
    private static final int REGION_MASK = 31;
    private static final int TILES_PER_REGION = 1024;
    @NBTName(value={"last-render-times"})
    private int[] lastRenderTimes;
    @NBTName(value={"tile-states"})
    private TileState[] tileStates;
    private transient boolean modified;

    private TileInfoRegion() {
    }

    @NBTPostDeserialize
    public void init() {
        if (this.lastRenderTimes == null || this.lastRenderTimes.length != 1024) {
            this.lastRenderTimes = new int[1024];
        }
        if (this.tileStates == null || this.tileStates.length != 1024) {
            this.tileStates = new TileState[1024];
            Arrays.fill(this.tileStates, TileState.UNKNOWN);
        }
    }

    public TileInfo get(int x, int z) {
        int index = TileInfoRegion.index(x, z);
        return new TileInfo(this.lastRenderTimes[index], this.tileStates[index]);
    }

    public TileInfo set(int x, int z, TileInfo info) {
        int index = TileInfoRegion.index(x, z);
        TileInfo previous = new TileInfo(this.lastRenderTimes[index], this.tileStates[index]);
        this.lastRenderTimes[index] = info.getRenderTime();
        this.tileStates[index] = Objects.requireNonNull(info.getState());
        if (!previous.equals(info)) {
            this.modified = true;
        }
        return previous;
    }

    int findLatestRenderTime() {
        if (this.lastRenderTimes == null) {
            return -1;
        }
        return Arrays.stream(this.lastRenderTimes).max().orElse(-1);
    }

    void populateSummaryMap(Map<TileState, Integer> map) {
        for (int i = 0; i < 1024; ++i) {
            TileState tileState = this.tileStates[i];
            map.merge(tileState, 1, Integer::sum);
        }
    }

    private static int index(int x, int z) {
        return (z & 0x1F) << 5 | x & 0x1F;
    }

    public static TileInfoRegion create() {
        TileInfoRegion region = new TileInfoRegion();
        region.init();
        return region;
    }

    public static TileState[] loadPalette(InputStream in) throws IOException {
        return PaletteOnly.BLUE_NBT.read((InputStream)in, PaletteOnly.class).tileStates.palette;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    public static class TileInfo {
        private int renderTime;
        private TileState state;

        public int getRenderTime() {
            return this.renderTime;
        }

        public TileState getState() {
            return this.state;
        }

        public void setRenderTime(int renderTime) {
            this.renderTime = renderTime;
        }

        public void setState(TileState state) {
            this.state = state;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TileInfo)) {
                return false;
            }
            TileInfo other = (TileInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getRenderTime() != other.getRenderTime()) {
                return false;
            }
            TileState this$state = this.getState();
            TileState other$state = other.getState();
            return !(this$state == null ? other$state != null : !this$state.equals(other$state));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TileInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getRenderTime();
            TileState $state = this.getState();
            result = result * 59 + ($state == null ? 43 : $state.hashCode());
            return result;
        }

        public String toString() {
            return "TileInfoRegion.TileInfo(renderTime=" + this.getRenderTime() + ", state=" + String.valueOf(this.getState()) + ")";
        }

        public TileInfo(int renderTime, TileState state) {
            this.renderTime = renderTime;
            this.state = state;
        }
    }

    private static class PaletteOnly {
        private static final BlueNBT BLUE_NBT = new BlueNBT();
        @NBTName(value={"tile-states"})
        private TileStates tileStates;

        private PaletteOnly() {
        }

        public TileStates getTileStates() {
            return this.tileStates;
        }

        static {
            BLUE_NBT.register(TypeToken.get(TileState.class), new RegistryAdapter<TileState>(TileState.REGISTRY, "bluemap", TileState.UNKNOWN));
        }

        private static class TileStates {
            private TileState[] palette;

            private TileStates() {
            }

            public TileState[] getPalette() {
                return this.palette;
            }
        }
    }
}

