/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.adapter.ResourcesGson;
import de.bluecolored.bluemap.core.resources.pack.PackMeta;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.stream.Stream;

public abstract class Pack {
    private final int packVersion;

    public abstract void loadResources(Iterable<Path> var1) throws IOException, InterruptedException;

    protected void loadResourcePath(Path root, PathLoader resourceLoader) throws IOException, InterruptedException {
        Path packMetaFile;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!Files.isDirectory(root, new LinkOption[0])) {
            try (FileSystem fileSystem = FileSystems.newFileSystem(root, (ClassLoader)null);){
                for (Path fsRoot : fileSystem.getRootDirectories()) {
                    if (!Files.isDirectory(fsRoot, new LinkOption[0])) continue;
                    this.loadResourcePath(fsRoot, resourceLoader);
                }
            }
            catch (Exception ex) {
                Logger.global.logDebug("Failed to read '" + String.valueOf(root) + "': " + String.valueOf(ex));
            }
            return;
        }
        Path fabricModJson = root.resolve("fabric.mod.json");
        if (Files.isRegularFile(fabricModJson, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(fabricModJson);){
                JsonObject rootElement = (JsonObject)ResourcesGson.INSTANCE.fromJson((Reader)reader, JsonObject.class);
                if (rootElement.has("jars")) {
                    for (JsonElement element : rootElement.getAsJsonArray("jars")) {
                        Path file = root.resolve(element.getAsJsonObject().get("file").getAsString());
                        if (!Files.exists(file, new LinkOption[0])) continue;
                        this.loadResourcePath(file, resourceLoader);
                    }
                }
            }
            catch (Exception ex) {
                Logger.global.logDebug("Failed to read fabric.mod.json: " + String.valueOf(ex));
            }
        }
        if (Files.isRegularFile(packMetaFile = root.resolve("pack.mcmeta"), new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(packMetaFile);){
                PackMeta packMeta = (PackMeta)ResourcesGson.INSTANCE.fromJson((Reader)reader, PackMeta.class);
                PackMeta.Overlay[] overlays = packMeta.getOverlays().getEntries();
                for (int i = overlays.length - 1; i >= 0; --i) {
                    Path overlayRoot;
                    PackMeta.Overlay overlay = overlays[i];
                    String dir = overlay.getDirectory();
                    if (dir == null || !overlay.getFormats().includes(this.packVersion) || !Files.exists(overlayRoot = root.resolve(dir), new LinkOption[0])) continue;
                    this.loadResourcePath(overlayRoot, resourceLoader);
                }
            }
            catch (Exception ex) {
                Logger.global.logDebug("Failed to read pack.mcmeta: " + String.valueOf(ex));
            }
        }
        resourceLoader.load(root);
    }

    protected <T> void loadResource(Path root, Path file, int namespacePos, int valuePos, Loader<T> loader, Map<? super ResourcePath<T>, T> resultMap) {
        try {
            ResourcePath<T> resourcePath = new ResourcePath<T>(root.relativize(file), namespacePos, valuePos);
            if (resultMap.containsKey(resourcePath)) {
                return;
            }
            T resource = loader.load(resourcePath);
            if (resource == null) {
                return;
            }
            resourcePath.setResource(resource);
            resultMap.put(resourcePath, resource);
        }
        catch (Exception ex) {
            Logger.global.logDebug("Failed to parse resource-file '" + String.valueOf(file) + "': " + String.valueOf(ex));
        }
    }

    protected static Stream<Path> list(Path root) {
        if (!Files.isDirectory(root, new LinkOption[0])) {
            return Stream.empty();
        }
        try {
            return Files.list(root);
        }
        catch (IOException ex) {
            throw new CompletionException(ex);
        }
    }

    protected static Stream<Path> walk(Path root) {
        if (!Files.exists(root, new LinkOption[0])) {
            return Stream.empty();
        }
        if (Files.isRegularFile(root, new LinkOption[0])) {
            return Stream.of(root);
        }
        try {
            return Files.walk(root, new FileVisitOption[0]);
        }
        catch (IOException ex) {
            throw new CompletionException(ex);
        }
    }

    public Pack(int packVersion) {
        this.packVersion = packVersion;
    }

    public int getPackVersion() {
        return this.packVersion;
    }

    protected static interface PathLoader {
        public void load(Path var1) throws IOException;
    }

    protected static interface Loader<T> {
        public T load(ResourcePath<T> var1) throws IOException;
    }
}

