/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack;

import com.google.gson.Gson;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import de.bluecolored.bluemap.core.resources.AbstractTypeAdapterFactory;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class PackMeta {
    private Pack pack = new Pack();
    private Overlays overlays = new Overlays();

    public Pack getPack() {
        return this.pack;
    }

    public Overlays getOverlays() {
        return this.overlays;
    }

    public static class Pack {
        private VersionRange packFormat = new VersionRange();
        @Nullable
        private VersionRange supportedFormats;

        public VersionRange getPackFormat() {
            return this.packFormat;
        }

        @Nullable
        public VersionRange getSupportedFormats() {
            return this.supportedFormats;
        }
    }

    public static class Overlays {
        private Overlay[] entries = new Overlay[0];

        public Overlay[] getEntries() {
            return this.entries;
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static class VersionRange {
        private int minInclusive = Integer.MIN_VALUE;
        private int maxInclusive = Integer.MAX_VALUE;

        public boolean includes(int version) {
            return version >= this.minInclusive && version <= this.maxInclusive;
        }

        public int getMinInclusive() {
            return this.minInclusive;
        }

        public int getMaxInclusive() {
            return this.maxInclusive;
        }

        public VersionRange() {
        }

        public VersionRange(int minInclusive, int maxInclusive) {
            this.minInclusive = minInclusive;
            this.maxInclusive = maxInclusive;
        }

        private static class Adapter
        extends AbstractTypeAdapterFactory<VersionRange> {
            public Adapter() {
                super(VersionRange.class);
            }

            @Override
            public VersionRange read(JsonReader in, Gson gson) throws IOException {
                return switch (in.peek()) {
                    case JsonToken.NUMBER -> {
                        int version = in.nextInt();
                        yield new VersionRange(version, version);
                    }
                    case JsonToken.BEGIN_ARRAY -> {
                        in.beginArray();
                        VersionRange range = new VersionRange(in.nextInt(), in.nextInt());
                        while (in.peek() != JsonToken.END_ARRAY) {
                            in.skipValue();
                        }
                        in.endArray();
                        yield range;
                    }
                    default -> (VersionRange)gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(VersionRange.class)).read(in);
                };
            }
        }
    }

    public static class Overlay {
        private VersionRange formats = new VersionRange();
        @Nullable
        private String directory;

        public VersionRange getFormats() {
            return this.formats;
        }

        @Nullable
        public String getDirectory() {
            return this.directory;
        }
    }
}

