/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.resources.pack.resourcepack;

import de.bluecolored.bluemap.core.BlueMap;
import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.resources.BlockColorCalculatorFactory;
import de.bluecolored.bluemap.core.resources.BlockPropertiesConfig;
import de.bluecolored.bluemap.core.resources.ResourcePath;
import de.bluecolored.bluemap.core.resources.adapter.ResourcesGson;
import de.bluecolored.bluemap.core.resources.pack.Pack;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockmodel.BlockModel;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockmodel.TextureVariable;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.blockstate.BlockState;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.AnimationMeta;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.texture.Texture;
import de.bluecolored.bluemap.core.util.Tristate;
import de.bluecolored.bluemap.core.world.BlockProperties;
import de.bluecolored.shadow.benmanes.caffeine.cache.Caffeine;
import de.bluecolored.shadow.benmanes.caffeine.cache.LoadingCache;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import org.jetbrains.annotations.Nullable;

public class ResourcePack
extends Pack {
    public static final ResourcePath<BlockState> MISSING_BLOCK_STATE = new ResourcePath("bluemap", "missing");
    public static final ResourcePath<BlockModel> MISSING_BLOCK_MODEL = new ResourcePath("bluemap", "block/missing");
    public static final ResourcePath<Texture> MISSING_TEXTURE = new ResourcePath("bluemap", "block/missing");
    private final Map<ResourcePath<BlockState>, BlockState> blockStates;
    private final Map<ResourcePath<BlockModel>, BlockModel> blockModels;
    private final Map<ResourcePath<Texture>, Texture> textures;
    private final Map<ResourcePath<BufferedImage>, BufferedImage> colormaps;
    private final BlockColorCalculatorFactory colorCalculatorFactory;
    private final BlockPropertiesConfig blockPropertiesConfig;
    private final Map<String, ResourcePath<BlockState>> blockStatePaths = new HashMap<String, ResourcePath<BlockState>>();
    private final Map<String, ResourcePath<Texture>> texturePaths;
    private final LoadingCache<de.bluecolored.bluemap.core.world.BlockState, BlockProperties> blockPropertiesCache;

    public ResourcePack(int packVersion) {
        super(packVersion);
        this.blockStates = new HashMap<ResourcePath<BlockState>, BlockState>();
        this.blockModels = new HashMap<ResourcePath<BlockModel>, BlockModel>();
        this.texturePaths = new HashMap<String, ResourcePath<Texture>>();
        this.textures = new HashMap<ResourcePath<Texture>, Texture>();
        this.colormaps = new HashMap<ResourcePath<BufferedImage>, BufferedImage>();
        this.colorCalculatorFactory = new BlockColorCalculatorFactory();
        this.blockPropertiesConfig = new BlockPropertiesConfig();
        this.blockPropertiesCache = Caffeine.newBuilder().executor(BlueMap.THREAD_POOL).maximumSize(10000L).build(this::loadBlockProperties);
    }

    @Override
    public synchronized void loadResources(Iterable<Path> roots) throws IOException, InterruptedException {
        Logger.global.logInfo("Loading resources...");
        for (Path root : roots) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Logger.global.logDebug("Loading resources from: " + String.valueOf(root) + " ...");
            this.loadResourcePath(root, this::loadResources);
        }
        Logger.global.logInfo("Loading textures...");
        for (Path root : roots) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Logger.global.logDebug("Loading textures from: " + String.valueOf(root) + " ...");
            this.loadResourcePath(root, this::loadTextures);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        Logger.global.logInfo("Baking resources...");
        this.bake();
        Logger.global.logInfo("Resources loaded.");
    }

    private void loadResources(Path root) throws IOException {
        try {
            CompletableFuture.allOf(CompletableFuture.runAsync(() -> ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("blockstates")).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).flatMap(x$0 -> ResourcePack.walk(x$0)).filter(path -> path.getFileName().toString().endsWith(".json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.loadResource(root, (Path)file, 1, 3, key -> {
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    BlockState blockState = (BlockState)ResourcesGson.INSTANCE.fromJson((Reader)reader, BlockState.class);
                    return blockState;
                }
            }, this.blockStates)), BlueMap.THREAD_POOL), CompletableFuture.runAsync(() -> ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("models")).flatMap(x$0 -> ResourcePack.list(x$0)).filter(path -> !path.getFileName().toString().equals("item")).flatMap(x$0 -> ResourcePack.walk(x$0)).filter(path -> path.getFileName().toString().endsWith(".json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.loadResource(root, (Path)file, 1, 3, key -> {
                try (BufferedReader reader = Files.newBufferedReader(file);){
                    BlockModel blockModel = (BlockModel)ResourcesGson.INSTANCE.fromJson((Reader)reader, BlockModel.class);
                    return blockModel;
                }
            }, this.blockModels)), BlueMap.THREAD_POOL), CompletableFuture.runAsync(() -> ResourcePack.walk(root.resolve("assets").resolve("minecraft").resolve("textures").resolve("colormap")).filter(path -> path.getFileName().toString().endsWith(".png")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.loadResource(root, (Path)file, 1, 3, key -> {
                try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                    BufferedImage bufferedImage = ImageIO.read(in);
                    return bufferedImage;
                }
            }, this.colormaps)), BlueMap.THREAD_POOL), CompletableFuture.runAsync(() -> ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("blockColors.json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                try {
                    this.colorCalculatorFactory.load((Path)file);
                }
                catch (Exception ex) {
                    Logger.global.logDebug("Failed to parse resource-file '" + String.valueOf(file) + "': " + String.valueOf(ex));
                }
            }), BlueMap.THREAD_POOL), CompletableFuture.runAsync(() -> ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("blockProperties.json")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                try {
                    this.blockPropertiesConfig.load((Path)file);
                }
                catch (Exception ex) {
                    Logger.global.logDebug("Failed to parse resource-file '" + String.valueOf(file) + "': " + String.valueOf(ex));
                }
            }), BlueMap.THREAD_POOL)).join();
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause != null) {
                throw new IOException(cause);
            }
            throw new IOException(ex);
        }
    }

    private void loadTextures(Path root) throws IOException {
        try {
            HashSet<ResourcePath<Texture>> usedTextures = new HashSet<ResourcePath<Texture>>();
            usedTextures.add(MISSING_TEXTURE);
            for (BlockModel model : this.blockModels.values()) {
                for (TextureVariable textureVariable : model.getTextures().values()) {
                    if (textureVariable.isReference()) continue;
                    usedTextures.add(textureVariable.getTexturePath());
                }
            }
            ResourcePack.list(root.resolve("assets")).map(path -> path.resolve("textures")).flatMap(x$0 -> ResourcePack.walk(x$0)).filter(path -> path.getFileName().toString().endsWith(".png")).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> this.loadResource(root, (Path)file, 1, 3, key -> {
                BufferedImage image;
                if (!usedTextures.contains(key)) {
                    return null;
                }
                try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
                    image = ImageIO.read(in);
                }
                AnimationMeta animation = null;
                Path animationPathFile = file.resolveSibling(String.valueOf(file.getFileName()) + ".mcmeta");
                if (Files.exists(animationPathFile, new LinkOption[0])) {
                    try (BufferedReader in = Files.newBufferedReader(animationPathFile, StandardCharsets.UTF_8);){
                        animation = (AnimationMeta)ResourcesGson.INSTANCE.fromJson((Reader)in, AnimationMeta.class);
                    }
                }
                return Texture.from(key, image, animation);
            }, this.textures));
        }
        catch (RuntimeException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause != null) {
                throw new IOException(cause);
            }
            throw new IOException(ex);
        }
    }

    private void bake() throws IOException, InterruptedException {
        this.blockStates.keySet().forEach(path -> this.blockStatePaths.put(path.getFormatted(), (ResourcePath<BlockState>)path));
        this.textures.keySet().forEach(path -> this.texturePaths.put(path.getFormatted(), (ResourcePath<Texture>)path));
        for (BlockModel model : this.blockModels.values()) {
            model.optimize(this);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        for (BlockModel model : this.blockModels.values()) {
            model.applyParent(this);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        for (BlockModel model : this.blockModels.values()) {
            model.calculateProperties(this);
        }
        BufferedImage foliage = new ResourcePath<BufferedImage>("minecraft:colormap/foliage").getResource(this.colormaps::get);
        if (foliage == null) {
            throw new IOException("Failed to bake resource-pack: No foliage-colormap found!");
        }
        this.colorCalculatorFactory.setFoliageMap(foliage);
        BufferedImage grass = new ResourcePath<BufferedImage>("minecraft:colormap/grass").getResource(this.colormaps::get);
        if (grass == null) {
            throw new IOException("Failed to bake resource-pack: No grass-colormap found!");
        }
        this.colorCalculatorFactory.setGrassMap(grass);
    }

    @Nullable
    public BlockState getBlockState(de.bluecolored.bluemap.core.world.BlockState blockState) {
        ResourcePath<BlockState> path = this.blockStatePaths.get(blockState.getFormatted());
        return path != null ? path.getResource(this::getBlockState) : MISSING_BLOCK_STATE.getResource(this::getBlockState);
    }

    @Nullable
    public BlockState getBlockState(ResourcePath<BlockState> path) {
        BlockState blockState = this.blockStates.get(path);
        return blockState != null ? blockState : MISSING_BLOCK_STATE.getResource(this.blockStates::get);
    }

    @Nullable
    public BlockModel getBlockModel(ResourcePath<BlockModel> path) {
        BlockModel blockModel = this.blockModels.get(path);
        return blockModel != null ? blockModel : MISSING_BLOCK_MODEL.getResource(this.blockModels::get);
    }

    @Nullable
    public ResourcePath<Texture> getTexturePath(String formatted) {
        return this.texturePaths.get(formatted);
    }

    @Nullable
    public Texture getTexture(ResourcePath<Texture> path) {
        Texture texture = this.textures.get(path);
        return texture != null ? texture : MISSING_TEXTURE.getResource(this.textures::get);
    }

    public Map<ResourcePath<Texture>, Texture> getTextures() {
        return this.textures;
    }

    public BlockColorCalculatorFactory getColorCalculatorFactory() {
        return this.colorCalculatorFactory;
    }

    public BlockProperties getBlockProperties(de.bluecolored.bluemap.core.world.BlockState state) {
        return this.blockPropertiesCache.get(state);
    }

    private BlockProperties loadBlockProperties(de.bluecolored.bluemap.core.world.BlockState state) {
        BlockState resource;
        BlockProperties.Builder props = this.blockPropertiesConfig.getBlockProperties(state).toBuilder();
        if ((props.isOccluding() == Tristate.UNDEFINED || props.isCulling() == Tristate.UNDEFINED) && (resource = this.getBlockState(state)) != null) {
            resource.forEach(state, 0, 0, 0, variant -> {
                BlockModel model = variant.getModel().getResource(this::getBlockModel);
                if (model != null) {
                    if (props.isOccluding() == Tristate.UNDEFINED) {
                        props.occluding(model.isOccluding());
                    }
                    if (props.isCulling() == Tristate.UNDEFINED) {
                        props.culling(model.isCulling());
                    }
                }
            });
        }
        return props.build();
    }
}

