/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage;

import de.bluecolored.bluemap.core.storage.GridStorage;
import de.bluecolored.bluemap.core.storage.ItemStorage;
import de.bluecolored.bluemap.core.storage.MapStorage;
import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.util.Key;

public abstract class KeyedMapStorage
implements MapStorage {
    private static final Key HIRES_TILES_KEY = Key.bluemap("hires");
    private static final Key TILE_STATE_KEY = Key.bluemap("tile-state");
    private static final Key CHUNK_STATE_KEY = Key.bluemap("chunk-state");
    private static final Key SETTINGS_KEY = Key.bluemap("settings");
    private static final Key TEXTURES_KEY = Key.bluemap("textures");
    private static final Key MARKERS_KEY = Key.bluemap("markers");
    private static final Key PLAYERS_KEY = Key.bluemap("players");
    private final Compression compression;

    @Override
    public GridStorage hiresTiles() {
        return this.grid(HIRES_TILES_KEY, this.compression);
    }

    @Override
    public GridStorage lowresTiles(int lod) {
        return this.grid(Key.bluemap("lowres/" + lod), Compression.NONE);
    }

    @Override
    public GridStorage tileState() {
        return this.grid(TILE_STATE_KEY, Compression.GZIP);
    }

    @Override
    public GridStorage chunkState() {
        return this.grid(CHUNK_STATE_KEY, Compression.GZIP);
    }

    @Override
    public ItemStorage asset(String name) {
        return this.item(Key.bluemap("asset/" + MapStorage.escapeAssetName(name)), Compression.NONE);
    }

    @Override
    public ItemStorage settings() {
        return this.item(SETTINGS_KEY, Compression.NONE);
    }

    @Override
    public ItemStorage textures() {
        return this.item(TEXTURES_KEY, this.compression);
    }

    @Override
    public ItemStorage markers() {
        return this.item(MARKERS_KEY, Compression.NONE);
    }

    @Override
    public ItemStorage players() {
        return this.item(PLAYERS_KEY, Compression.NONE);
    }

    public abstract GridStorage grid(Key var1, Compression var2);

    public abstract ItemStorage item(Key var1, Compression var2);

    public KeyedMapStorage(Compression compression) {
        this.compression = compression;
    }
}

