/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.storage.file;

import de.bluecolored.bluemap.core.storage.ItemStorage;
import de.bluecolored.bluemap.core.storage.compression.CompressedInputStream;
import de.bluecolored.bluemap.core.storage.compression.Compression;
import de.bluecolored.bluemap.core.util.FileHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.Nullable;

public class FileItemStorage
implements ItemStorage {
    private final Path file;
    private final Compression compression;
    private final boolean atomic;

    @Override
    public OutputStream write() throws IOException {
        if (this.atomic) {
            return this.compression.compress(FileHelper.createFilepartOutputStream(this.file));
        }
        Path folder = this.file.toAbsolutePath().normalize().getParent();
        FileHelper.createDirectories(folder, new FileAttribute[0]);
        return this.compression.compress(Files.newOutputStream(this.file, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE));
    }

    @Override
    @Nullable
    public CompressedInputStream read() throws IOException {
        if (!Files.exists(this.file, new LinkOption[0])) {
            return null;
        }
        try {
            return new CompressedInputStream(Files.newInputStream(this.file, new OpenOption[0]), this.compression);
        }
        catch (FileNotFoundException | NoSuchFileException ex) {
            return null;
        }
    }

    @Override
    public void delete() throws IOException {
        if (Files.exists(this.file, new LinkOption[0])) {
            Files.delete(this.file);
        }
    }

    @Override
    public boolean exists() {
        return Files.exists(this.file, new LinkOption[0]);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    public FileItemStorage(Path file, Compression compression, boolean atomic) {
        this.file = file;
        this.compression = compression;
        this.atomic = atomic;
    }
}

