/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.util;

import de.bluecolored.bluemap.core.util.Keyed;
import java.util.concurrent.ConcurrentHashMap;

public class Key
implements Keyed {
    private static final ConcurrentHashMap<String, String> STRING_INTERN_POOL = new ConcurrentHashMap();
    public static final String MINECRAFT_NAMESPACE = "minecraft";
    public static final String BLUEMAP_NAMESPACE = "bluemap";
    private final String namespace;
    private final String value;
    private final String formatted;

    public Key(String formatted) {
        String namespace = MINECRAFT_NAMESPACE;
        String value = formatted;
        int namespaceSeparator = formatted.indexOf(58);
        if (namespaceSeparator > 0) {
            namespace = formatted.substring(0, namespaceSeparator);
            value = formatted.substring(namespaceSeparator + 1);
        }
        this.namespace = Key.intern(namespace);
        this.value = Key.intern(value);
        this.formatted = Key.intern(this.namespace + ":" + this.value);
    }

    public Key(String namespace, String value) {
        this.namespace = Key.intern(namespace);
        this.value = Key.intern(value);
        this.formatted = Key.intern(this.namespace + ":" + this.value);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getValue() {
        return this.value;
    }

    public String getFormatted() {
        return this.formatted;
    }

    @Override
    public Key getKey() {
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Key)) {
            return false;
        }
        Key that = (Key)o;
        if (!that.canEqual(this)) {
            return false;
        }
        return this.formatted == that.formatted;
    }

    protected boolean canEqual(Object o) {
        return o instanceof Key;
    }

    public int hashCode() {
        return this.formatted.hashCode();
    }

    public String toString() {
        return this.formatted;
    }

    public static Key parse(String formatted) {
        return new Key(formatted);
    }

    public static Key parse(String formatted, String defaultNamespace) {
        String namespace = defaultNamespace;
        String value = formatted;
        int namespaceSeparator = formatted.indexOf(58);
        if (namespaceSeparator > 0) {
            namespace = formatted.substring(0, namespaceSeparator);
            value = formatted.substring(namespaceSeparator + 1);
        }
        return new Key(namespace, value);
    }

    public static Key minecraft(String value) {
        return new Key(MINECRAFT_NAMESPACE, value);
    }

    public static Key bluemap(String value) {
        return new Key(BLUEMAP_NAMESPACE, value);
    }

    protected static String intern(String string) {
        String interned = STRING_INTERN_POOL.putIfAbsent(string, string);
        return interned != null ? interned : string;
    }
}

