/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world;

import de.bluecolored.bluemap.core.util.Key;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class BlockState
extends Key {
    private static final Pattern BLOCKSTATE_SERIALIZATION_PATTERN = Pattern.compile("^(.+?)(?:\\[(.*)])?$");
    public static final BlockState AIR = new BlockState("minecraft:air");
    public static final BlockState MISSING = new BlockState("bluemap:missing");
    private boolean hashed = false;
    private int hash = 0;
    private final Map<String, String> properties;
    private final Property[] propertiesArray;
    private final boolean isAir;
    private final boolean isWater;
    private final boolean isWaterlogged;
    private int liquidLevel = -1;
    private int redstonePower = -1;

    public BlockState(String value) {
        this(value, Collections.emptyMap());
    }

    public BlockState(String value, Map<String, String> properties) {
        super(value);
        this.properties = properties;
        this.propertiesArray = (Property[])properties.entrySet().stream().map(e -> new Property((String)e.getKey(), (String)e.getValue())).sorted().toArray(Property[]::new);
        this.isAir = "minecraft:air".equals(this.getFormatted()) || "minecraft:cave_air".equals(this.getFormatted()) || "minecraft:void_air".equals(this.getFormatted());
        this.isWater = "minecraft:water".equals(this.getFormatted());
        this.isWaterlogged = "true".equals(properties.get("waterlogged"));
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public boolean isAir() {
        return this.isAir;
    }

    public boolean isWater() {
        return this.isWater;
    }

    public boolean isWaterlogged() {
        return this.isWaterlogged;
    }

    public int getLiquidLevel() {
        if (this.liquidLevel == -1) {
            try {
                String levelString = this.properties.get("level");
                int n = this.liquidLevel = levelString != null ? Integer.parseInt(levelString) : 0;
                if (this.liquidLevel > 15) {
                    this.liquidLevel = 15;
                }
                if (this.liquidLevel < 0) {
                    this.liquidLevel = 0;
                }
            }
            catch (NumberFormatException ex) {
                this.liquidLevel = 0;
            }
        }
        return this.liquidLevel;
    }

    public int getRedstonePower() {
        if (this.redstonePower == -1) {
            try {
                String levelString = this.properties.get("power");
                int n = this.redstonePower = levelString != null ? Integer.parseInt(levelString) : 0;
                if (this.redstonePower > 15) {
                    this.redstonePower = 15;
                }
                if (this.redstonePower < 0) {
                    this.redstonePower = 0;
                }
            }
            catch (NumberFormatException ex) {
                this.redstonePower = 15;
            }
        }
        return this.redstonePower;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BlockState)) {
            return false;
        }
        BlockState b = (BlockState)obj;
        if (!b.canEqual(this)) {
            return false;
        }
        if (this.getFormatted() != b.getFormatted()) {
            return false;
        }
        return Arrays.equals(this.propertiesArray, b.propertiesArray);
    }

    @Override
    protected boolean canEqual(Object o) {
        return o instanceof BlockState;
    }

    @Override
    public int hashCode() {
        if (!this.hashed) {
            this.hash = Objects.hash(this.getFormatted(), this.getProperties());
            this.hashed = true;
        }
        return this.hash;
    }

    @Override
    public String toString() {
        StringJoiner sj = new StringJoiner(",");
        for (Map.Entry<String, String> e : this.getProperties().entrySet()) {
            sj.add(e.getKey() + "=" + e.getValue());
        }
        return this.getFormatted() + "[" + String.valueOf(sj) + "]";
    }

    public static BlockState fromString(String serializedBlockState) throws IllegalArgumentException {
        try {
            Matcher m4 = BLOCKSTATE_SERIALIZATION_PATTERN.matcher(serializedBlockState);
            if (!m4.find()) {
                throw new IllegalArgumentException("'" + serializedBlockState + "' could not be parsed to a BlockState!");
            }
            HashMap<String, String> pt = new HashMap<String, String>();
            String g2 = m4.group(2);
            if (g2 != null && !g2.isEmpty()) {
                String[] propertyStrings;
                for (String s2 : propertyStrings = g2.trim().split(",")) {
                    String[] kv = s2.split("=", 2);
                    pt.put(kv[0], kv[1]);
                }
            }
            String blockId = m4.group(1).trim();
            return new BlockState(blockId, pt);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("'" + serializedBlockState + "' could not be parsed to a BlockState!");
        }
    }

    public static final class Property
    implements Comparable<Property> {
        private final String key;
        private final String value;

        public Property(String key, String value) {
            this.key = BlockState.intern(key);
            this.value = BlockState.intern(value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Property property = (Property)o;
            return this.key == property.key && this.value == property.value;
        }

        public int hashCode() {
            return this.key.hashCode() * 31 ^ this.value.hashCode();
        }

        @Override
        public int compareTo(@NotNull Property o) {
            int keyCompare = this.key.compareTo(o.key);
            return keyCompare != 0 ? keyCompare : this.value.compareTo(o.value);
        }
    }
}

