/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world;

public interface DimensionType {
    public static final DimensionType OVERWORLD = new Builtin(true, true, false, 0.0f, -64, 384, null, 1.0);
    public static final DimensionType OVERWORLD_CAVES = new Builtin(true, true, true, 0.0f, -64, 384, null, 1.0);
    public static final DimensionType NETHER = new Builtin(false, false, true, 0.1f, 0, 256, 6000L, 8.0);
    public static final DimensionType END = new Builtin(false, false, false, 0.0f, 0, 256, 18000L, 1.0);

    public boolean isNatural();

    public boolean hasSkylight();

    public boolean hasCeiling();

    public float getAmbientLight();

    public int getMinY();

    public int getHeight();

    public Long getFixedTime();

    public double getCoordinateScale();

    public static class Builtin
    implements DimensionType {
        private final boolean natural;
        private final boolean hasSkylight;
        private final boolean hasCeiling;
        private final float ambientLight;
        private final int minY;
        private final int height;
        private final Long fixedTime;
        private final double coordinateScale;

        @Override
        public boolean isNatural() {
            return this.natural;
        }

        @Override
        public boolean hasSkylight() {
            return this.hasSkylight;
        }

        @Override
        public boolean hasCeiling() {
            return this.hasCeiling;
        }

        @Override
        public float getAmbientLight() {
            return this.ambientLight;
        }

        @Override
        public int getMinY() {
            return this.minY;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public Long getFixedTime() {
            return this.fixedTime;
        }

        @Override
        public double getCoordinateScale() {
            return this.coordinateScale;
        }

        private Builtin(boolean natural, boolean hasSkylight, boolean hasCeiling, float ambientLight, int minY, int height, Long fixedTime, double coordinateScale) {
            this.natural = natural;
            this.hasSkylight = hasSkylight;
            this.hasCeiling = hasCeiling;
            this.ambientLight = ambientLight;
            this.minY = minY;
            this.height = height;
            this.fixedTime = fixedTime;
            this.coordinateScale = coordinateScale;
        }
    }
}

