/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.block;

import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.bluemap.core.world.block.ExtendedBlock;

public class BlockNeighborhood<T extends BlockNeighborhood<T>>
extends ExtendedBlock<T> {
    private static final int DIAMETER = 8;
    private static final int DIAMETER_MASK = 7;
    private static final int DIAMETER_SQUARED = 64;
    private final ExtendedBlock<?>[] neighborhood;
    private int thisIndex;

    public BlockNeighborhood(ExtendedBlock<?> center) {
        super(center.getResourcePack(), center.getRenderSettings(), null, 0, 0, 0);
        this.copy(center);
        this.neighborhood = new ExtendedBlock[512];
        this.init();
    }

    public BlockNeighborhood(ResourcePack resourcePack, RenderSettings renderSettings, World world, int x, int y, int z) {
        super(resourcePack, renderSettings, world, x, y, z);
        this.neighborhood = new ExtendedBlock[512];
        this.init();
    }

    @Override
    public T set(int x, int y, int z) {
        return (T)((BlockNeighborhood)this.copy(this.getBlock(x, y, z)));
    }

    @Override
    public T set(World world, int x, int y, int z) {
        if (this.getWorld() == world) {
            return (T)((BlockNeighborhood)this.copy(this.getBlock(x, y, z)));
        }
        return (T)((BlockNeighborhood)super.set(world, x, y, z));
    }

    @Override
    protected void reset() {
        super.reset();
        this.thisIndex = -1;
    }

    private void init() {
        this.thisIndex = -1;
        for (int i = 0; i < this.neighborhood.length; ++i) {
            this.neighborhood[i] = new ExtendedBlock(this.getResourcePack(), this.getRenderSettings(), null, 0, 0, 0);
        }
    }

    public ExtendedBlock<?> getNeighborBlock(int dx, int dy, int dz) {
        return this.getBlock(this.getX() + dx, this.getY() + dy, this.getZ() + dz);
    }

    private ExtendedBlock<?> getBlock(int x, int y, int z) {
        int i = this.index(x, y, z);
        if (i == this.thisIndex()) {
            return this;
        }
        return (ExtendedBlock)this.neighborhood[i].set(this.getWorld(), x, y, z);
    }

    private int thisIndex() {
        if (this.thisIndex == -1) {
            this.thisIndex = this.index(this.getX(), this.getY(), this.getZ());
        }
        return this.thisIndex;
    }

    private int index(int x, int y, int z) {
        return (x & 7) * 64 + (y & 7) * 8 + (z & 7);
    }
}

