/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.block;

import de.bluecolored.bluemap.core.map.hires.RenderSettings;
import de.bluecolored.bluemap.core.resources.pack.resourcepack.ResourcePack;
import de.bluecolored.bluemap.core.world.BlockProperties;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.LightData;
import de.bluecolored.bluemap.core.world.World;
import de.bluecolored.bluemap.core.world.block.Block;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class ExtendedBlock<T extends ExtendedBlock<T>>
extends Block<T> {
    private final ResourcePack resourcePack;
    private final RenderSettings renderSettings;
    @Nullable
    private BlockProperties properties;
    private boolean insideRenderBoundsCalculated;
    private boolean insideRenderBounds;
    private boolean isCaveCalculated;
    private boolean isCave;

    public ExtendedBlock(ResourcePack resourcePack, RenderSettings renderSettings, World world, int x, int y, int z) {
        super(world, x, y, z);
        this.resourcePack = Objects.requireNonNull(resourcePack);
        this.renderSettings = renderSettings;
    }

    @Override
    protected void reset() {
        super.reset();
        this.properties = null;
        this.insideRenderBoundsCalculated = false;
        this.isCaveCalculated = false;
    }

    @Override
    public T copy(ExtendedBlock<?> source) {
        super.copy(source);
        this.properties = source.properties;
        this.insideRenderBoundsCalculated = source.insideRenderBoundsCalculated;
        this.insideRenderBounds = source.insideRenderBounds;
        this.isCaveCalculated = source.isCaveCalculated;
        this.isCave = source.isCave;
        return (T)((ExtendedBlock)this.self());
    }

    @Override
    public BlockState getBlockState() {
        if (this.renderSettings.isRenderEdges() && !this.isInsideRenderBounds()) {
            return BlockState.AIR;
        }
        return super.getBlockState();
    }

    @Override
    public LightData getLightData() {
        LightData ld = super.getLightData();
        if (this.renderSettings.isRenderEdges() && !this.isInsideRenderBounds()) {
            ld.set(this.getWorld().getDimensionType().hasSkylight() ? 16 : 0, ld.getBlockLight());
        }
        return ld;
    }

    public BlockProperties getProperties() {
        if (this.properties == null) {
            this.properties = this.resourcePack.getBlockProperties(this.getBlockState());
        }
        return this.properties;
    }

    public RenderSettings getRenderSettings() {
        return this.renderSettings;
    }

    public boolean isInsideRenderBounds() {
        if (!this.insideRenderBoundsCalculated) {
            this.insideRenderBounds = this.renderSettings.isInsideRenderBoundaries(this.getX(), this.getY(), this.getZ());
            this.insideRenderBoundsCalculated = true;
        }
        return this.insideRenderBounds;
    }

    public boolean isRemoveIfCave() {
        if (!this.isCaveCalculated) {
            this.isCave = this.getY() < this.renderSettings.getRemoveCavesBelowY() && (!this.getChunk().hasOceanFloorHeights() || this.getY() < this.getChunk().getOceanFloorY(this.getX(), this.getZ()) + this.renderSettings.getCaveDetectionOceanFloor());
            this.isCaveCalculated = true;
        }
        return this.isCave;
    }

    public ResourcePack getResourcePack() {
        return this.resourcePack;
    }
}

