/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.block.entity;

import de.bluecolored.bluemap.core.world.block.entity.BlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class SkullBlockEntity
extends BlockEntity {
    @Nullable
    private final String noteBlockSound;
    @Nullable
    private final String extraType;
    @Nullable
    private final SkullOwner skullOwner;

    protected SkullBlockEntity(Map<String, Object> data) {
        super(data);
        this.noteBlockSound = (String)data.get("note_block_sound");
        this.extraType = (String)data.get("ExtraType");
        Map ownerData = (Map)data.get("SkullOwner");
        this.skullOwner = ownerData != null ? new SkullOwner(ownerData) : null;
    }

    @Override
    public String toString() {
        return "SkullBlockEntity{noteBlockSound='" + this.noteBlockSound + "', extraType='" + this.extraType + "', skullOwner=" + String.valueOf(this.skullOwner) + "} " + super.toString();
    }

    @Nullable
    public String getNoteBlockSound() {
        return this.noteBlockSound;
    }

    @Nullable
    public String getExtraType() {
        return this.extraType;
    }

    @Nullable
    public SkullOwner getSkullOwner() {
        return this.skullOwner;
    }

    public static class SkullOwner {
        @Nullable
        private final UUID id;
        @Nullable
        private final String name;
        private final List<Texture> textures = new ArrayList<Texture>();

        private SkullOwner(Map<String, Object> data) {
            int @Nullable [] uuidInts = (int[])data.get("Id");
            this.id = uuidInts == null || uuidInts.length != 4 ? null : new UUID((long)uuidInts[0] << 32 | (long)uuidInts[1], (long)uuidInts[2] << 32 | (long)uuidInts[3]);
            this.name = (String)data.get("Name");
            Map properties = data.getOrDefault("Properties", Map.of());
            List textures = properties.getOrDefault("textures", List.of());
            for (Map compound : textures) {
                this.textures.add(new Texture(compound));
            }
        }

        public String toString() {
            return "SkullOwner{id=" + String.valueOf(this.id) + ", name='" + this.name + "', textures=" + String.valueOf(this.textures) + "}";
        }

        @Nullable
        public UUID getId() {
            return this.id;
        }

        @Nullable
        public String getName() {
            return this.name;
        }

        public List<Texture> getTextures() {
            return this.textures;
        }
    }

    public static class Texture {
        @Nullable
        private final String signature;
        private final String value;

        private Texture(Map<String, Object> data) {
            this.signature = (String)data.get("signature");
            this.value = (String)data.getOrDefault("value", "");
        }

        public String toString() {
            return "Texture{signature='" + this.signature + "', value='" + this.value + "'}";
        }

        @Nullable
        public String getSignature() {
            return this.signature;
        }

        public String getValue() {
            return this.value;
        }
    }
}

