/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.chunk;

import de.bluecolored.bluemap.core.logger.Logger;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.world.BlockState;
import de.bluecolored.bluemap.core.world.DimensionType;
import de.bluecolored.bluemap.core.world.LightData;
import de.bluecolored.bluemap.core.world.biome.Biome;
import de.bluecolored.bluemap.core.world.block.entity.BlockEntity;
import de.bluecolored.bluemap.core.world.mca.MCAUtil;
import de.bluecolored.bluemap.core.world.mca.MCAWorld;
import de.bluecolored.bluemap.core.world.mca.PackedIntArrayAccess;
import de.bluecolored.bluemap.core.world.mca.chunk.MCAChunk;
import de.bluecolored.bluemap.core.world.mca.data.LenientBlockEntityArrayDeserializer;
import de.bluecolored.shadow.bluenbt.NBTDeserializer;
import de.bluecolored.shadow.bluenbt.NBTName;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class Chunk_1_18
extends MCAChunk {
    private static final Key STATUS_EMPTY = new Key("minecraft", "empty");
    private static final Key STATUS_FULL = new Key("minecraft", "full");
    private final boolean generated;
    private final boolean hasLightData;
    private final long inhabitedTime;
    private final int skyLight;
    private final int worldMinY;
    private final boolean hasWorldSurfaceHeights;
    private final PackedIntArrayAccess worldSurfaceHeights;
    private final boolean hasOceanFloorHeights;
    private final PackedIntArrayAccess oceanFloorHeights;
    private final Section[] sections;
    private final int sectionMin;
    private final int sectionMax;
    private final Map<Long, BlockEntity> blockEntities;

    public Chunk_1_18(MCAWorld world, Data data) {
        super(world, data);
        this.generated = !STATUS_EMPTY.equals(data.status);
        this.hasLightData = STATUS_FULL.equals(data.status);
        this.inhabitedTime = data.inhabitedTime;
        DimensionType dimensionType = this.getWorld().getDimensionType();
        this.worldMinY = dimensionType.getMinY();
        this.skyLight = dimensionType.hasSkylight() ? 15 : 0;
        int worldHeight = dimensionType.getHeight();
        int bitsPerHeightmapElement = MCAUtil.ceilLog2(worldHeight + 1);
        this.worldSurfaceHeights = new PackedIntArrayAccess(bitsPerHeightmapElement, data.heightmaps.worldSurface);
        this.oceanFloorHeights = new PackedIntArrayAccess(bitsPerHeightmapElement, data.heightmaps.oceanFloor);
        this.hasWorldSurfaceHeights = this.worldSurfaceHeights.isCorrectSize(256);
        this.hasOceanFloorHeights = this.oceanFloorHeights.isCorrectSize(256);
        SectionData[] sectionsData = data.sections;
        if (sectionsData != null && sectionsData.length > 0) {
            int min2 = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (SectionData sectionData : sectionsData) {
                int y = sectionData.getY();
                if (min2 > y) {
                    min2 = y;
                }
                if (max >= y) continue;
                max = y;
            }
            this.sections = new Section[1 + max - min2];
            for (SectionData sectionData : sectionsData) {
                Section section = new Section(this.getWorld(), sectionData);
                int y = section.getSectionY();
                if (min2 > y) {
                    min2 = y;
                }
                if (max < y) {
                    max = y;
                }
                this.sections[section.sectionY - min2] = section;
            }
            this.sectionMin = min2;
            this.sectionMax = max;
        } else {
            this.sections = new Section[0];
            this.sectionMin = 0;
            this.sectionMax = 0;
        }
        this.blockEntities = new HashMap<Long, BlockEntity>();
        for (int i = 0; i < data.blockEntities.length; ++i) {
            BlockEntity be = data.blockEntities[i];
            if (be == null) continue;
            long hash = (long)be.getY() << 8 | (long)((be.getX() & 0xF) << 4) | (long)(be.getZ() & 0xF);
            this.blockEntities.put(hash, be);
        }
    }

    @Override
    public boolean isGenerated() {
        return this.generated;
    }

    @Override
    public boolean hasLightData() {
        return this.hasLightData;
    }

    @Override
    public long getInhabitedTime() {
        return this.inhabitedTime;
    }

    @Override
    public BlockState getBlockState(int x, int y, int z) {
        Section section = this.getSection(y >> 4);
        if (section == null) {
            return BlockState.AIR;
        }
        return section.getBlockState(x, y, z);
    }

    @Override
    public Biome getBiome(int x, int y, int z) {
        Section section = this.getSection(y >> 4);
        if (section == null) {
            return Biome.DEFAULT;
        }
        return section.getBiome(x, y, z);
    }

    @Override
    public LightData getLightData(int x, int y, int z, LightData target) {
        if (!this.hasLightData) {
            return target.set(this.skyLight, 0);
        }
        int sectionY = y >> 4;
        Section section = this.getSection(sectionY);
        if (section == null) {
            return sectionY < this.sectionMin ? target.set(0, 0) : target.set(this.skyLight, 0);
        }
        return section.getLightData(x, y, z, target);
    }

    @Override
    public int getMinY(int x, int z) {
        return this.sectionMin * 16;
    }

    @Override
    public int getMaxY(int x, int z) {
        return this.sectionMax * 16 + 15;
    }

    @Override
    public boolean hasWorldSurfaceHeights() {
        return this.hasWorldSurfaceHeights;
    }

    @Override
    public int getWorldSurfaceY(int x, int z) {
        return this.worldSurfaceHeights.get((z & 0xF) << 4 | x & 0xF) + this.worldMinY;
    }

    @Override
    public boolean hasOceanFloorHeights() {
        return this.hasOceanFloorHeights;
    }

    @Override
    public int getOceanFloorY(int x, int z) {
        return this.oceanFloorHeights.get((z & 0xF) << 4 | x & 0xF) + this.worldMinY;
    }

    @Override
    @Nullable
    public BlockEntity getBlockEntity(int x, int y, int z) {
        return this.blockEntities.get((long)y << 8 | (long)((x & 0xF) << 4) | (long)(z & 0xF));
    }

    @Nullable
    private Section getSection(int y) {
        if ((y -= this.sectionMin) < 0 || y >= this.sections.length) {
            return null;
        }
        return this.sections[y];
    }

    public static class Data
    extends MCAChunk.Data {
        private Key status = STATUS_EMPTY;
        private long inhabitedTime = 0L;
        private HeightmapsData heightmaps = new HeightmapsData();
        private SectionData @Nullable [] sections = null;
        @NBTName(value={"block_entities"})
        @NBTDeserializer(value=LenientBlockEntityArrayDeserializer.class)
        @Nullable
        private BlockEntity[] blockEntities = MCAChunk.EMPTY_BLOCK_ENTITIES_ARRAY;

        public Key getStatus() {
            return this.status;
        }

        public long getInhabitedTime() {
            return this.inhabitedTime;
        }

        public HeightmapsData getHeightmaps() {
            return this.heightmaps;
        }

        public SectionData @Nullable [] getSections() {
            return this.sections;
        }

        @Nullable
        public BlockEntity[] getBlockEntities() {
            return this.blockEntities;
        }
    }

    public static class HeightmapsData {
        @NBTName(value={"WORLD_SURFACE"})
        private long[] worldSurface = MCAChunk.EMPTY_LONG_ARRAY;
        @NBTName(value={"OCEAN_FLOOR"})
        private long[] oceanFloor = MCAChunk.EMPTY_LONG_ARRAY;

        public long[] getWorldSurface() {
            return this.worldSurface;
        }

        public long[] getOceanFloor() {
            return this.oceanFloor;
        }
    }

    public static class SectionData {
        private int y = 0;
        private byte[] blockLight = MCAChunk.EMPTY_BYTE_ARRAY;
        private byte[] skyLight = MCAChunk.EMPTY_BYTE_ARRAY;
        @NBTName(value={"block_states"})
        private BlockStatesData blockStates = new BlockStatesData();
        private BiomesData biomes = new BiomesData();

        public int getY() {
            return this.y;
        }

        public byte[] getBlockLight() {
            return this.blockLight;
        }

        public byte[] getSkyLight() {
            return this.skyLight;
        }

        public BlockStatesData getBlockStates() {
            return this.blockStates;
        }

        public BiomesData getBiomes() {
            return this.biomes;
        }
    }

    protected static class Section {
        private final int sectionY;
        private final BlockState[] blockPalette;
        private final Biome[] biomePalette;
        private final PackedIntArrayAccess blocks;
        private final PackedIntArrayAccess biomes;
        private final byte[] blockLight;
        private final byte[] skyLight;

        public Section(MCAWorld world, SectionData sectionData) {
            this.sectionY = sectionData.y;
            this.blockPalette = sectionData.blockStates.palette;
            this.biomePalette = new Biome[sectionData.biomes.palette.length];
            for (int i = 0; i < this.biomePalette.length; ++i) {
                Biome biome = world.getDataPack().getBiome(sectionData.biomes.palette[i]);
                if (biome == null) {
                    biome = Biome.DEFAULT;
                }
                this.biomePalette[i] = biome;
            }
            this.blocks = new PackedIntArrayAccess(sectionData.blockStates.data, 4096);
            this.biomes = new PackedIntArrayAccess(Math.max(MCAUtil.ceilLog2(this.biomePalette.length), 1), sectionData.biomes.data);
            this.blockLight = sectionData.blockLight;
            this.skyLight = sectionData.skyLight;
        }

        public BlockState getBlockState(int x, int y, int z) {
            if (this.blockPalette.length == 1) {
                return this.blockPalette[0];
            }
            if (this.blockPalette.length == 0) {
                return BlockState.AIR;
            }
            int id = this.blocks.get((y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF);
            if (id >= this.blockPalette.length) {
                Logger.global.noFloodWarning("palette-warning", "Got block-palette id " + id + " but palette has size of " + this.blockPalette.length + ".");
                return BlockState.MISSING;
            }
            return this.blockPalette[id];
        }

        public Biome getBiome(int x, int y, int z) {
            if (this.biomePalette.length == 1) {
                return this.biomePalette[0];
            }
            if (this.biomePalette.length == 0) {
                return Biome.DEFAULT;
            }
            int id = this.biomes.get((y & 0xC) << 2 | z & 0xC | (x & 0xC) >> 2);
            if (id >= this.biomePalette.length) {
                Logger.global.noFloodWarning("biome-palette-warning", "Got biome-palette id " + id + " but palette has size of " + this.biomePalette.length + ".");
                return Biome.DEFAULT;
            }
            return this.biomePalette[id];
        }

        public LightData getLightData(int x, int y, int z, LightData target) {
            if (this.blockLight.length == 0 && this.skyLight.length == 0) {
                return target.set(0, 0);
            }
            int blockByteIndex = (y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF;
            int blockHalfByteIndex = blockByteIndex >> 1;
            boolean largeHalf = (blockByteIndex & 1) != 0;
            return target.set(this.skyLight.length > blockHalfByteIndex ? MCAUtil.getByteHalf(this.skyLight[blockHalfByteIndex], largeHalf) : 0, this.blockLight.length > blockHalfByteIndex ? MCAUtil.getByteHalf(this.blockLight[blockHalfByteIndex], largeHalf) : 0);
        }

        public int getSectionY() {
            return this.sectionY;
        }
    }

    public static class BiomesData {
        private Key[] palette = MCAChunk.EMPTY_KEY_ARRAY;
        private long[] data = MCAChunk.EMPTY_LONG_ARRAY;

        public Key[] getPalette() {
            return this.palette;
        }

        public long[] getData() {
            return this.data;
        }
    }

    public static class BlockStatesData {
        private BlockState[] palette = MCAChunk.EMPTY_BLOCKSTATE_ARRAY;
        private long[] data = MCAChunk.EMPTY_LONG_ARRAY;

        public BlockState[] getPalette() {
            return this.palette;
        }

        public long[] getData() {
            return this.data;
        }
    }
}

