/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.core.world.mca.region;

import com.flowpowered.math.vector.Vector2i;
import de.bluecolored.bluemap.core.util.Key;
import de.bluecolored.bluemap.core.util.Keyed;
import de.bluecolored.bluemap.core.util.Registry;
import de.bluecolored.bluemap.core.world.Region;
import de.bluecolored.bluemap.core.world.mca.MCAWorld;
import de.bluecolored.bluemap.core.world.mca.region.LinearRegion;
import de.bluecolored.bluemap.core.world.mca.region.MCARegion;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public interface RegionType
extends Keyed {
    public static final RegionType MCA = new Impl(Key.bluemap("mca"), MCARegion::new, MCARegion::getRegionFileName, MCARegion.FILE_PATTERN);
    public static final RegionType LINEAR = new Impl(Key.bluemap("linear"), LinearRegion::new, LinearRegion::getRegionFileName, LinearRegion.FILE_PATTERN);
    public static final RegionType DEFAULT = MCA;
    public static final Registry<RegionType> REGISTRY = new Registry((Keyed[])new RegionType[]{MCA, LINEAR});

    public Region createRegion(MCAWorld var1, Path var2);

    public String getRegionFileName(int var1, int var2);

    @Nullable
    public Vector2i getRegionFromFileName(String var1);

    @Nullable
    public static RegionType forFileName(String fileName) {
        for (RegionType regionType : REGISTRY.values()) {
            if (regionType.getRegionFromFileName(fileName) == null) continue;
            return regionType;
        }
        return null;
    }

    @Nullable
    public static Vector2i regionForFileName(String fileName) {
        for (RegionType regionType : REGISTRY.values()) {
            Vector2i pos = regionType.getRegionFromFileName(fileName);
            if (pos == null) continue;
            return pos;
        }
        return null;
    }

    public static Region loadRegion(MCAWorld world, Path regionFolder, int regionX, int regionZ) {
        for (RegionType regionType : REGISTRY.values()) {
            Path regionFile = regionFolder.resolve(regionType.getRegionFileName(regionX, regionZ));
            if (!Files.exists(regionFile, new LinkOption[0])) continue;
            return regionType.createRegion(world, regionFile);
        }
        return DEFAULT.createRegion(world, regionFolder.resolve(DEFAULT.getRegionFileName(regionX, regionZ)));
    }

    public static class Impl
    implements RegionType {
        private final Key key;
        private final RegionFactory regionFactory;
        private final RegionFileNameFunction regionFileNameFunction;
        private final Pattern regionFileNamePattern;

        @Override
        public Region createRegion(MCAWorld world, Path regionFile) {
            return this.regionFactory.create(world, regionFile);
        }

        @Override
        public String getRegionFileName(int regionX, int regionZ) {
            return this.regionFileNameFunction.getRegionFileName(regionX, regionZ);
        }

        @Override
        @Nullable
        public Vector2i getRegionFromFileName(String fileName) {
            Matcher matcher = this.regionFileNamePattern.matcher(fileName);
            if (!matcher.matches()) {
                return null;
            }
            return new Vector2i(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)));
        }

        public Impl(Key key, RegionFactory regionFactory, RegionFileNameFunction regionFileNameFunction, Pattern regionFileNamePattern) {
            this.key = key;
            this.regionFactory = regionFactory;
            this.regionFileNameFunction = regionFileNameFunction;
            this.regionFileNamePattern = regionFileNamePattern;
        }

        @Override
        public Key getKey() {
            return this.key;
        }
    }

    @FunctionalInterface
    public static interface RegionFactory {
        public Region create(MCAWorld var1, Path var2);
    }

    @FunctionalInterface
    public static interface RegionFileNameFunction {
        public String getRegionFileName(int var1, int var2);
    }
}

