/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.fabric;

import com.flowpowered.math.vector.Vector3d;
import de.bluecolored.bluemap.common.plugin.text.Text;
import de.bluecolored.bluemap.common.serverinterface.Gamemode;
import de.bluecolored.bluemap.common.serverinterface.Player;
import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.fabric.FabricMod;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1934;
import net.minecraft.class_1944;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class FabricPlayer
implements Player {
    private static final Map<class_1934, Gamemode> GAMEMODE_MAP = new EnumMap<class_1934, Gamemode>(class_1934.class);
    private final UUID uuid;
    private Text name;
    private ServerWorld world;
    private Vector3d position;
    private Vector3d rotation;
    private int skyLight;
    private int blockLight;
    private boolean sneaking;
    private boolean invisible;
    private Gamemode gamemode;
    private final FabricMod mod;

    public FabricPlayer(class_3222 player, FabricMod mod) {
        this.uuid = player.method_5667();
        this.mod = mod;
        this.update(player);
    }

    @Override
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public Text getName() {
        return this.name;
    }

    @Override
    public ServerWorld getWorld() {
        return this.world;
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    @Override
    public Vector3d getRotation() {
        return this.rotation;
    }

    @Override
    public int getSkyLight() {
        return this.skyLight;
    }

    @Override
    public int getBlockLight() {
        return this.blockLight;
    }

    @Override
    public boolean isSneaking() {
        return this.sneaking;
    }

    @Override
    public boolean isInvisible() {
        return this.invisible;
    }

    @Override
    public Gamemode getGamemode() {
        return this.gamemode;
    }

    public void update() {
        MinecraftServer server = this.mod.getServer();
        if (server == null) {
            return;
        }
        class_3222 player = server.method_3760().method_14602(this.uuid);
        if (player == null) {
            return;
        }
        this.update(player);
    }

    public void update(class_3222 player) {
        class_1293 invis;
        this.gamemode = GAMEMODE_MAP.get(player.field_13974.method_14257());
        if (this.gamemode == null) {
            this.gamemode = Gamemode.SURVIVAL;
        }
        this.invisible = (invis = player.method_6112(class_1294.field_5905)) != null && invis.method_5584() > 0;
        this.name = Text.of(player.method_5477().getString());
        class_243 pos = player.method_19538();
        this.position = new Vector3d(pos.method_10216(), pos.method_10214(), pos.method_10215());
        this.rotation = new Vector3d(player.method_36455(), player.method_5791(), 0.0f);
        this.sneaking = player.method_5715();
        this.skyLight = player.method_37908().method_22336().method_15562(class_1944.field_9284).method_15543(player.method_24515());
        this.blockLight = player.method_37908().method_22336().method_15562(class_1944.field_9282).method_15543(player.method_24515());
        this.world = this.mod.getServerWorld(player.method_51469());
    }

    static {
        GAMEMODE_MAP.put(class_1934.field_9216, Gamemode.ADVENTURE);
        GAMEMODE_MAP.put(class_1934.field_9215, Gamemode.SURVIVAL);
        GAMEMODE_MAP.put(class_1934.field_9220, Gamemode.CREATIVE);
        GAMEMODE_MAP.put(class_1934.field_9219, Gamemode.SPECTATOR);
    }
}

