/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.bluemap.fabric;

import de.bluecolored.bluemap.common.serverinterface.ServerWorld;
import de.bluecolored.bluemap.core.util.Key;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class FabricWorld
implements ServerWorld {
    private final WeakReference<class_3218> delegate;
    private final Path worldFolder;
    private final Key dimension;

    public FabricWorld(class_3218 delegate) {
        this.delegate = new WeakReference<class_3218>(delegate);
        MinecraftServer server = delegate.method_8503();
        this.worldFolder = delegate.method_8503().method_3831().toPath().resolve(server.method_27050(class_5218.field_24188));
        class_2960 id = delegate.method_27983().method_29177();
        this.dimension = new Key(id.method_12836(), id.method_12832());
    }

    @Override
    public boolean persistWorldChanges() throws IOException {
        class_3218 world = (class_3218)this.delegate.get();
        if (world == null) {
            return false;
        }
        CompletableFuture<Boolean> taskResult = CompletableFuture.supplyAsync(() -> {
            try {
                world.method_14176(null, true, false);
                return true;
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, (Executor)world.method_8503());
        try {
            return taskResult.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e);
        }
        catch (ExecutionException e) {
            Throwable t2 = e.getCause();
            if (t2 instanceof IOException) {
                throw (IOException)t2;
            }
            if (t2 instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)t2;
            }
            throw new IOException(t2);
        }
    }

    @Override
    public Path getWorldFolder() {
        return this.worldFolder;
    }

    @Override
    public Key getDimension() {
        return this.dimension;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FabricWorld that = (FabricWorld)o;
        Object world = this.delegate.get();
        return world != null && world.equals(that.delegate.get());
    }

    public int hashCode() {
        Object world = this.delegate.get();
        return world != null ? world.hashCode() : 0;
    }
}

