/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.bluenbt;

import com.google.gson.InstanceCreator;
import com.google.gson.reflect.TypeToken;
import de.bluecolored.shadow.bluenbt.FieldNameTransformer;
import de.bluecolored.shadow.bluenbt.NBTReader;
import de.bluecolored.shadow.bluenbt.NBTWriter;
import de.bluecolored.shadow.bluenbt.ObjectConstructor;
import de.bluecolored.shadow.bluenbt.TagType;
import de.bluecolored.shadow.bluenbt.TypeAdapter;
import de.bluecolored.shadow.bluenbt.TypeAdapterFactory;
import de.bluecolored.shadow.bluenbt.TypeDeserializer;
import de.bluecolored.shadow.bluenbt.TypeDeserializerFactory;
import de.bluecolored.shadow.bluenbt.TypeSerializer;
import de.bluecolored.shadow.bluenbt.TypeSerializerFactory;
import de.bluecolored.shadow.bluenbt.adapter.ArrayAdapterFactory;
import de.bluecolored.shadow.bluenbt.adapter.CollectionAdapterFactory;
import de.bluecolored.shadow.bluenbt.adapter.DefaultDeserializerFactory;
import de.bluecolored.shadow.bluenbt.adapter.DefaultSerializerFactory;
import de.bluecolored.shadow.bluenbt.adapter.MapAdapterFactory;
import de.bluecolored.shadow.bluenbt.adapter.ObjectAdapterFactory;
import de.bluecolored.shadow.bluenbt.adapter.PrimitiveDeserializerFactory;
import de.bluecolored.shadow.bluenbt.adapter.PrimitiveSerializerFactory;
import de.bluecolored.shadow.bluenbt.internal.ConstructorConstructor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class BlueNBT {
    private final List<TypeSerializerFactory> serializerFactories = new ArrayList<TypeSerializerFactory>();
    private final List<TypeDeserializerFactory> deserializerFactories = new ArrayList<TypeDeserializerFactory>();
    private final Map<TypeToken<?>, TypeSerializer<?>> typeSerializerMap = new HashMap();
    private final Map<TypeToken<?>, TypeDeserializer<?>> typeDeserializerMap = new HashMap();
    private final Map<Type, InstanceCreator<?>> instanceCreators = new HashMap();
    private final ConstructorConstructor constructorConstructor = new ConstructorConstructor(this.instanceCreators);
    private FieldNameTransformer fieldNameTransformer = s2 -> {
        if (s2.isEmpty()) {
            return s2;
        }
        char first = s2.charAt(0);
        if (Character.isUpperCase(first)) {
            return Character.toLowerCase(first) + s2.substring(1);
        }
        return s2;
    };

    public BlueNBT() {
        this.register(ObjectAdapterFactory.INSTANCE);
        this.register(ArrayAdapterFactory.INSTANCE);
        this.register(PrimitiveSerializerFactory.INSTANCE);
        this.register(PrimitiveDeserializerFactory.INSTANCE);
        this.register(CollectionAdapterFactory.INSTANCE);
        this.register(MapAdapterFactory.INSTANCE);
    }

    public void register(TypeAdapterFactory typeAdapterFactory) {
        this.serializerFactories.add(typeAdapterFactory);
        this.deserializerFactories.add(typeAdapterFactory);
    }

    public void register(TypeSerializerFactory typeSerializerFactory) {
        this.serializerFactories.add(typeSerializerFactory);
    }

    public void register(TypeDeserializerFactory typeDeserializerFactory) {
        this.deserializerFactories.add(typeDeserializerFactory);
    }

    public <T> void register(final TypeToken<T> type, final TypeAdapter<T> typeAdapter) {
        this.register(new TypeAdapterFactory(){

            public <U> Optional<TypeAdapter<U>> create(TypeToken<U> createType, BlueNBT blueNBT) {
                if (createType.equals((Object)type)) {
                    return Optional.of(typeAdapter);
                }
                return Optional.empty();
            }
        });
    }

    public <T> void register(final TypeToken<T> type, final TypeSerializer<T> typeSerializer) {
        this.register(new TypeSerializerFactory(){

            public <U> Optional<TypeSerializer<U>> create(TypeToken<U> createType, BlueNBT blueNBT) {
                if (createType.equals((Object)type)) {
                    return Optional.of(typeSerializer);
                }
                return Optional.empty();
            }
        });
    }

    public <T> void register(final TypeToken<T> type, final TypeDeserializer<T> typeDeserializer) {
        this.register(new TypeDeserializerFactory(){

            public <U> Optional<TypeDeserializer<U>> create(TypeToken<U> createType, BlueNBT blueNBT) {
                if (createType.equals((Object)type)) {
                    return Optional.of(typeDeserializer);
                }
                return Optional.empty();
            }
        });
    }

    public <T> void register(Type type, InstanceCreator<T> instanceCreator) {
        this.instanceCreators.put(type, instanceCreator);
    }

    public <T> TypeSerializer<T> getTypeSerializer(TypeToken<T> type) {
        TypeSerializer<?> serializer = this.typeSerializerMap.get(type);
        if (serializer == null) {
            TypeSerializerFactory factory;
            FutureTypeSerializer future = new FutureTypeSerializer();
            this.typeSerializerMap.put(type, future);
            for (int i = this.serializerFactories.size() - 1; i >= 0 && (serializer = (TypeSerializer<?>)(factory = this.serializerFactories.get(i)).create(type, this).orElse(null)) == null; --i) {
            }
            if (serializer == null) {
                serializer = DefaultSerializerFactory.INSTANCE.createFor(type, this);
            }
            future.complete(serializer);
            this.typeSerializerMap.put(type, serializer);
        }
        return serializer;
    }

    public <T> TypeDeserializer<T> getTypeDeserializer(TypeToken<T> type) {
        TypeDeserializer<?> deserializer = this.typeDeserializerMap.get(type);
        if (deserializer == null) {
            TypeDeserializerFactory factory;
            FutureTypeDeserializer future = new FutureTypeDeserializer();
            this.typeDeserializerMap.put(type, future);
            for (int i = this.deserializerFactories.size() - 1; i >= 0 && (deserializer = (TypeDeserializer<?>)(factory = this.deserializerFactories.get(i)).create(type, this).orElse(null)) == null; --i) {
            }
            if (deserializer == null) {
                deserializer = DefaultDeserializerFactory.INSTANCE.createFor(type, this);
            }
            future.complete(deserializer);
            this.typeDeserializerMap.put(type, deserializer);
        }
        return deserializer;
    }

    public <T> void write(T object, OutputStream out, TypeToken<T> type) throws IOException {
        this.write(object, new NBTWriter(out), type);
    }

    public <T> void write(T object, NBTWriter out, TypeToken<T> type) throws IOException {
        this.getTypeSerializer(type).write(object, out);
    }

    public <T> void write(T object, OutputStream out, Class<T> type) throws IOException {
        this.write(object, out, TypeToken.get(type));
    }

    public <T> void write(T object, NBTWriter out, Class<T> type) throws IOException {
        this.write(object, out, TypeToken.get(type));
    }

    public void write(Object object, OutputStream out) throws IOException {
        this.write(object, out, object.getClass());
    }

    public void write(Object object, NBTWriter out) throws IOException {
        this.write(object, out, object.getClass());
    }

    public <T> T read(InputStream in, TypeToken<T> type) throws IOException {
        return this.read(new NBTReader(in), type);
    }

    public <T> T read(NBTReader in, TypeToken<T> type) throws IOException {
        return this.getTypeDeserializer(type).read(in);
    }

    public <T> T read(InputStream in, Class<T> type) throws IOException {
        return this.read(in, TypeToken.get(type));
    }

    public <T> T read(NBTReader in, Class<T> type) throws IOException {
        return this.read(in, TypeToken.get(type));
    }

    public Object read(InputStream in, Type type) throws IOException {
        return this.read(in, TypeToken.get((Type)type));
    }

    public Object read(NBTReader in, Type type) throws IOException {
        return this.read(in, TypeToken.get((Type)type));
    }

    public <T> ObjectConstructor<T> createObjectConstructor(TypeToken<T> type) {
        return this.constructorConstructor.get(type);
    }

    public FieldNameTransformer getFieldNameTransformer() {
        return this.fieldNameTransformer;
    }

    public void setFieldNameTransformer(FieldNameTransformer fieldNameTransformer) {
        this.fieldNameTransformer = fieldNameTransformer;
    }

    private static class FutureTypeDeserializer<T>
    implements TypeDeserializer<T> {
        private TypeDeserializer<T> value;

        private FutureTypeDeserializer() {
        }

        public void complete(TypeDeserializer<T> value) {
            if (this.value != null) {
                throw new IllegalStateException("FutureTypeDeserializer already completed!");
            }
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public T read(NBTReader reader) throws IOException {
            if (this.value == null) {
                throw new IllegalStateException("FutureTypeDeserializer is not ready!");
            }
            return this.value.read(reader);
        }
    }

    private static class FutureTypeSerializer<T>
    implements TypeSerializer<T> {
        private TypeSerializer<T> value;

        private FutureTypeSerializer() {
        }

        public void complete(TypeSerializer<T> value) {
            if (this.value != null) {
                throw new IllegalStateException("FutureTypeSerializer already completed!");
            }
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public void write(T value, NBTWriter writer) throws IOException {
            if (this.value == null) {
                throw new IllegalStateException("FutureTypeSerializer not completed!");
            }
            this.value.write(value, writer);
        }

        @Override
        public TagType type() {
            if (this.value == null) {
                throw new IllegalStateException("FutureTypeSerializer is not ready!");
            }
            return this.value.type();
        }
    }
}

