/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.bluenbt;

import de.bluecolored.shadow.bluenbt.TagType;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NBTWriter
implements Closeable {
    private final DataOutputStream out;
    private int stackPosition = 0;
    private TagType[] stack = new TagType[32];
    @Nullable
    private String nextName = null;
    private int nextListLength = -1;

    public NBTWriter(@NotNull OutputStream out) {
        Objects.requireNonNull(out);
        this.out = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
    }

    @Contract(value="_ -> this")
    public NBTWriter name(String name) {
        if (this.nextName != null) {
            throw new IllegalStateException("The name was already set to '" + name + "'");
        }
        this.nextName = name;
        return this;
    }

    public void beginCompound() throws IOException {
        this.tag(TagType.COMPOUND);
        this.advanceStack();
    }

    public void beginList(int length) throws IOException {
        this.tag(TagType.LIST);
        this.advanceStack();
        this.nextListLength = length;
    }

    public void beginList(int length, TagType type) throws IOException {
        this.beginList(length);
        this.tag(type);
    }

    public void endCompound() throws IOException {
        if (!this.inCompound()) {
            throw new IllegalStateException("Not in a compound!");
        }
        this.reduceStack();
        this.tag(TagType.END);
        this.afterValue();
    }

    public void endList() throws IOException {
        if (!this.inList()) {
            throw new IllegalStateException("Not in a list!");
        }
        this.reduceStack();
        this.afterValue();
    }

    public void value(byte value) throws IOException {
        this.tag(TagType.BYTE);
        this.out.writeByte(value);
        this.afterValue();
    }

    public void value(short value) throws IOException {
        this.tag(TagType.SHORT);
        this.out.writeShort(value);
        this.afterValue();
    }

    public void value(int value) throws IOException {
        this.tag(TagType.INT);
        this.out.writeInt(value);
        this.afterValue();
    }

    public void value(long value) throws IOException {
        this.tag(TagType.LONG);
        this.out.writeLong(value);
        this.afterValue();
    }

    public void value(float value) throws IOException {
        this.tag(TagType.FLOAT);
        this.out.writeFloat(value);
        this.afterValue();
    }

    public void value(double value) throws IOException {
        this.tag(TagType.DOUBLE);
        this.out.writeDouble(value);
        this.afterValue();
    }

    public void value(String value) throws IOException {
        this.tag(TagType.STRING);
        this.out.writeUTF(value);
        this.afterValue();
    }

    public void value(byte[] value) throws IOException {
        this.value(value, 0, value.length);
    }

    public void value(byte[] value, int off, int len) throws IOException {
        this.tag(TagType.BYTE_ARRAY);
        this.out.writeInt(value.length);
        this.out.write(value, off, len);
        this.afterValue();
    }

    public void value(int[] value) throws IOException {
        this.value(value, 0, value.length);
    }

    public void value(int[] value, int off, int len) throws IOException {
        this.tag(TagType.INT_ARRAY);
        this.out.writeInt(value.length);
        int lim = off + len;
        for (int i = off; i < lim; ++i) {
            this.out.writeInt(value[i]);
        }
        this.afterValue();
    }

    public void value(long[] value) throws IOException {
        this.value(value, 0, value.length);
    }

    public void value(long[] value, int off, int len) throws IOException {
        this.tag(TagType.LONG_ARRAY);
        this.out.writeInt(value.length);
        int lim = off + len;
        for (int i = off; i < lim; ++i) {
            this.out.writeLong(value[i]);
        }
        this.afterValue();
    }

    public boolean inCompound() {
        return this.stackPosition > 0 && this.stack[this.stackPosition - 1] == TagType.COMPOUND;
    }

    public boolean inList() {
        return this.stackPosition > 0 && this.stack[this.stackPosition - 1] == TagType.LIST;
    }

    private void tag(TagType tag) throws IOException {
        if (this.nextListLength != -1) {
            if (tag != TagType.END) {
                this.out.write(tag.getId());
            } else {
                this.out.write(TagType.COMPOUND.getId());
            }
            this.out.writeInt(this.nextListLength);
            this.stack[this.stackPosition] = tag;
            this.nextListLength = -1;
            return;
        }
        if (tag != TagType.END && this.stack[this.stackPosition] != null) {
            if (this.stack[this.stackPosition] == tag) {
                if (this.nextName != null) {
                    throw new IllegalStateException("There is a name set. You can't use name() when writing a value inside a list or before end()!");
                }
                return;
            }
            throw new IllegalStateException("Wrong tag-type. Expected type " + this.stack[this.stackPosition] + " but got " + tag);
        }
        this.stack[this.stackPosition] = tag;
        this.out.write(tag.getId());
        if (tag != TagType.END && !this.inList()) {
            if (this.nextName == null) {
                if (this.stackPosition > 0) {
                    throw new IllegalStateException("Name is not set. Call name() before writing a value when not inside a list!");
                }
                this.nextName = "";
            }
            this.out.writeUTF(this.nextName);
            this.nextName = null;
        } else if (this.nextName != null) {
            throw new IllegalStateException("There is a name set. You can't use name() when writing a value inside a list or before end()!");
        }
    }

    private void afterValue() {
        if (!this.inList()) {
            this.stack[this.stackPosition] = null;
        }
    }

    private void advanceStack() {
        ++this.stackPosition;
        if (this.stackPosition >= this.stack.length) {
            int newLength = this.stack.length * 2;
            this.stack = Arrays.copyOf(this.stack, newLength);
        }
        this.stack[this.stackPosition] = null;
    }

    private void reduceStack() {
        if (this.stackPosition == 0) {
            throw new IllegalStateException("Can not reduce empty stack!");
        }
        --this.stackPosition;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        if (this.stackPosition > 0) {
            throw new IOException("Incomplete document!");
        }
    }
}

