/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.bluenbt;

import java.util.NoSuchElementException;

public enum TagType {
    END(0, -1),
    BYTE(1, 1),
    SHORT(2, 2),
    INT(3, 4),
    LONG(4, 8),
    FLOAT(5, 4),
    DOUBLE(6, 8),
    BYTE_ARRAY(7, -1),
    STRING(8, -1),
    LIST(9, -1),
    COMPOUND(10, -1),
    INT_ARRAY(11, -1),
    LONG_ARRAY(12, -1);

    private static final TagType[] TAG_TYPE_ID_MAP;
    private final int id;
    private final int size;

    public static TagType forId(int id) {
        TagType type;
        if (id >= TAG_TYPE_ID_MAP.length || (type = TAG_TYPE_ID_MAP[id]) == null) {
            throw new NoSuchElementException("There is no TagType for id: " + id);
        }
        return type;
    }

    private TagType(int id, int size) {
        this.id = id;
        this.size = size;
    }

    public int getId() {
        return this.id;
    }

    public int getSize() {
        return this.size;
    }

    static {
        TAG_TYPE_ID_MAP = new TagType[13];
        TagType[] tagTypeArray = TagType.values();
        int n = tagTypeArray.length;
        for (int i = 0; i < n; ++i) {
            TagType type;
            TagType.TAG_TYPE_ID_MAP[type.id] = type = tagTypeArray[i];
        }
    }
}

