/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.bluenbt.adapter;

import com.google.gson.reflect.TypeToken;
import de.bluecolored.shadow.bluenbt.BlueNBT;
import de.bluecolored.shadow.bluenbt.NBTReader;
import de.bluecolored.shadow.bluenbt.NBTWriter;
import de.bluecolored.shadow.bluenbt.ObjectConstructor;
import de.bluecolored.shadow.bluenbt.TypeAdapter;
import de.bluecolored.shadow.bluenbt.TypeAdapterFactory;
import de.bluecolored.shadow.bluenbt.TypeDeserializer;
import de.bluecolored.shadow.bluenbt.TypeSerializer;
import de.bluecolored.shadow.bluenbt.adapter.TypeUtil;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class MapAdapterFactory
implements TypeAdapterFactory {
    public static final MapAdapterFactory INSTANCE = new MapAdapterFactory();

    public <T> Optional<TypeAdapter<T>> create(TypeToken<T> typeToken, BlueNBT blueNBT) {
        Function<Object, Object> fromStringFunction;
        Function<Object, Object> toStringFunction;
        Type type = typeToken.getType();
        Class rawType = typeToken.getRawType();
        if (!Map.class.isAssignableFrom(rawType)) {
            return Optional.empty();
        }
        Type[] keyAndValueTypes = TypeUtil.getMapKeyAndValueTypes(type, rawType);
        Class<?> keyType = TypeUtil.getRawType(keyAndValueTypes[0]);
        if (String.class.equals(keyType)) {
            toStringFunction = Function.identity();
            fromStringFunction = Function.identity();
        } else if (Enum.class.isAssignableFrom(keyType)) {
            toStringFunction = Enum::name;
            fromStringFunction = name -> Enum.valueOf((Class)keyAndValueTypes[0], name);
        } else {
            return Optional.empty();
        }
        TypeToken valueType = TypeToken.get((Type)keyAndValueTypes[1]);
        TypeSerializer elementTypeSerializer = blueNBT.getTypeSerializer(valueType);
        TypeDeserializer elementTypeDeserializer = blueNBT.getTypeDeserializer(valueType);
        ObjectConstructor<T> constructor = blueNBT.createObjectConstructor(typeToken);
        MapAdapter result = new MapAdapter(toStringFunction, fromStringFunction, elementTypeSerializer, elementTypeDeserializer, constructor);
        return Optional.of(result);
    }

    static class MapAdapter<K, E>
    implements TypeAdapter<Map<K, E>> {
        private final Function<K, String> toStringFunction;
        private final Function<String, K> fromStringFunction;
        private final TypeSerializer<E> typeSerializer;
        private final TypeDeserializer<E> typeDeserializer;
        private final ObjectConstructor<? extends Map<K, E>> constructor;

        @Override
        public Map<K, E> read(NBTReader reader) throws IOException {
            Map<K, E> map = this.constructor.construct();
            reader.beginCompound();
            while (reader.hasNext()) {
                String keyString = reader.name();
                K key = this.fromStringFunction.apply(keyString);
                E instance = this.typeDeserializer.read(reader);
                map.put(key, instance);
            }
            reader.endCompound();
            return map;
        }

        @Override
        public void write(Map<K, E> value, NBTWriter writer) throws IOException {
            writer.beginCompound();
            for (Map.Entry<K, E> entry : value.entrySet()) {
                String keyString = this.toStringFunction.apply(entry.getKey());
                writer.name(keyString);
                this.typeSerializer.write(entry.getValue(), writer);
            }
            writer.endCompound();
        }

        public MapAdapter(Function<K, String> toStringFunction, Function<String, K> fromStringFunction, TypeSerializer<E> typeSerializer, TypeDeserializer<E> typeDeserializer, ObjectConstructor<? extends Map<K, E>> constructor) {
            this.toStringFunction = toStringFunction;
            this.fromStringFunction = fromStringFunction;
            this.typeSerializer = typeSerializer;
            this.typeDeserializer = typeDeserializer;
            this.constructor = constructor;
        }
    }
}

