/*
 * Decompiled with CFR 0.152.
 */
package de.bluecolored.shadow.bluenbt.adapter;

import com.google.gson.reflect.TypeToken;
import de.bluecolored.shadow.bluenbt.BlueNBT;
import de.bluecolored.shadow.bluenbt.NBTReader;
import de.bluecolored.shadow.bluenbt.TagType;
import de.bluecolored.shadow.bluenbt.TypeDeserializer;
import de.bluecolored.shadow.bluenbt.TypeDeserializerFactory;
import de.bluecolored.shadow.bluenbt.internal.LinkedTreeMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;

public class ObjectAdapterFactory
implements TypeDeserializerFactory {
    public static final ObjectAdapterFactory INSTANCE = new ObjectAdapterFactory();
    private static final ObjectAdapter ADAPTER_INSTANCE = new ObjectAdapter();

    public <T> Optional<TypeDeserializer<T>> create(TypeToken<T> typeToken, BlueNBT blueNBT) {
        if (typeToken.getType() != Object.class) {
            return Optional.empty();
        }
        return Optional.of(ADAPTER_INSTANCE);
    }

    static class ObjectAdapter
    implements TypeDeserializer<Object> {
        @Override
        public Object read(NBTReader reader) throws IOException {
            TagType type = reader.peek();
            switch (type) {
                case COMPOUND: {
                    LinkedTreeMap<String, Object> map = new LinkedTreeMap<String, Object>();
                    reader.beginCompound();
                    while (reader.hasNext()) {
                        map.put(reader.name(), this.read(reader));
                    }
                    reader.endCompound();
                    return map;
                }
                case LIST: {
                    ArrayList<Object> list = new ArrayList<Object>(reader.beginList());
                    while (reader.hasNext()) {
                        list.add(this.read(reader));
                    }
                    reader.endList();
                    return list;
                }
                case STRING: {
                    return reader.nextString();
                }
                case BYTE: {
                    return reader.nextByte();
                }
                case SHORT: {
                    return reader.nextShort();
                }
                case INT: {
                    return reader.nextInt();
                }
                case LONG: {
                    return reader.nextLong();
                }
                case FLOAT: {
                    return Float.valueOf(reader.nextFloat());
                }
                case DOUBLE: {
                    return reader.nextDouble();
                }
                case BYTE_ARRAY: {
                    return reader.nextByteArray();
                }
                case INT_ARRAY: {
                    return reader.nextIntArray();
                }
                case LONG_ARRAY: {
                    return reader.nextLongArray();
                }
            }
            throw new IllegalStateException("Found unexpected " + type + " tag.");
        }
    }
}

