/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.foundation.copycat;

import com.copycatsplus.copycats.foundation.copycat.CopycatExternalContext;
import com.copycatsplus.copycats.foundation.copycat.ICopycatBlockEntity;
import com.copycatsplus.copycats.foundation.copycat.IStateType;
import com.copycatsplus.copycats.foundation.copycat.model.ScaledBlockAndTintGetter;
import com.copycatsplus.copycats.foundation.copycat.multistate.IMultiStateCopycatBlock;
import com.copycatsplus.copycats.utility.BlockEntityUtils;
import com.copycatsplus.copycats.utility.BlockFaceUtils;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.ITransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.equipment.wrench.WrenchItem;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1933;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_310;
import net.minecraft.class_322;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3709;
import net.minecraft.class_3867;
import net.minecraft.class_3965;
import net.minecraft.class_6328;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@class_6328
public interface ICopycatBlock
extends IWrenchable,
IStateType,
ITransformableBlock {
    @Nullable
    default public ICopycatBlockEntity getCopycatBlockEntity(class_1922 worldIn, class_2338 pos) {
        class_2586 blockEntity = worldIn.method_8321(pos);
        if (blockEntity == null) {
            return null;
        }
        if (!(blockEntity instanceof ICopycatBlockEntity)) {
            return null;
        }
        ICopycatBlockEntity copycatBE = (ICopycatBlockEntity)blockEntity;
        return copycatBE;
    }

    default public boolean canToggleCT(class_2680 state, class_1920 level, class_2338 pos) {
        return true;
    }

    default public boolean isCTEnabled(class_2680 state, class_1920 level, class_2338 pos) {
        class_2586 be = level.method_8321(pos);
        if (!(be instanceof ICopycatBlockEntity)) {
            return true;
        }
        ICopycatBlockEntity fbe = (ICopycatBlockEntity)be;
        if (!this.canToggleCT(state, level, pos)) {
            return true;
        }
        return fbe.isCTEnabled();
    }

    default public class_1269 toggleCT(class_2680 pState, class_1937 pLevel, class_2338 pPos, class_1657 pPlayer, class_1268 pHand, class_3965 pHit) {
        if (pPlayer.method_5715() && pPlayer.method_5998(pHand).equals(class_1799.field_8037)) {
            if (!this.canToggleCT(pState, (class_1920)pLevel, pPos)) {
                return class_1269.field_5811;
            }
            class_2586 be = pLevel.method_8321(pPos);
            if (!(be instanceof ICopycatBlockEntity)) {
                return class_1269.field_5811;
            }
            ICopycatBlockEntity fbe = (ICopycatBlockEntity)be;
            if (!this.canToggleCT(pState, (class_1920)pLevel, pPos)) {
                return class_1269.field_5811;
            }
            fbe.setCTEnabled(!fbe.isCTEnabled());
            BlockEntityUtils.redraw((class_2586)fbe);
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    default public class_1269 onSneakWrenched(class_2680 state, class_1838 context) {
        this.onWrenched(state, context);
        return super.onSneakWrenched(state, context);
    }

    default public class_1269 onWrenched(class_2680 state, class_1838 context) {
        ICopycatBlockEntity copycatBE = this.getCopycatBlockEntity((class_1922)context.method_8045(), context.method_8037());
        if (copycatBE == null) {
            return class_1269.field_5811;
        }
        class_1799 consumedItem = copycatBE.getConsumedItem();
        if (!copycatBE.hasCustomMaterial()) {
            return class_1269.field_5811;
        }
        class_1657 player = context.method_8036();
        if (!player.method_7337()) {
            player.method_31548().method_7398(consumedItem);
        }
        context.method_8045().method_20290(2001, context.method_8037(), class_2248.method_9507((class_2680)ICopycatBlock.getMaterial((class_1922)context.method_8045(), context.method_8037())));
        copycatBE.setMaterial(AllBlocks.COPYCAT_BASE.getDefaultState());
        copycatBE.setConsumedItem(class_1799.field_8037);
        return class_1269.field_5812;
    }

    @Nullable
    default public class_2680 getAcceptedBlockState(class_1937 pLevel, class_2338 pPos, class_1799 item, class_2350 face) {
        class_1792 class_17922 = item.method_7909();
        if (!(class_17922 instanceof class_1747)) {
            return null;
        }
        class_1747 bi = (class_1747)class_17922;
        class_2248 block = bi.method_7711();
        if (block instanceof ICopycatBlock) {
            return null;
        }
        class_2680 appliedState = block.method_9564();
        boolean hardCodedAllow = this.isAcceptedRegardless(appliedState);
        if (!AllTags.AllBlockTags.COPYCAT_ALLOW.matches(block) && !hardCodedAllow) {
            if (AllTags.AllBlockTags.COPYCAT_DENY.matches(block)) {
                return null;
            }
            if (block instanceof class_2343) {
                return null;
            }
            if (block instanceof class_2510) {
                return null;
            }
            if (pLevel != null) {
                class_265 shape = appliedState.method_26218((class_1922)pLevel, pPos);
                if (shape.method_1110() || !shape.method_1107().equals((Object)class_259.method_1077().method_1107())) {
                    return null;
                }
                class_265 collisionShape = appliedState.method_26220((class_1922)pLevel, pPos);
                if (collisionShape.method_1110()) {
                    return null;
                }
            }
        }
        if (face != null) {
            class_2350.class_2351 axis = face.method_10166();
            if (appliedState.method_28498((class_2769)class_2741.field_12525)) {
                appliedState = (class_2680)appliedState.method_11657((class_2769)class_2741.field_12525, (Comparable)face);
            }
            if (appliedState.method_28498((class_2769)class_2741.field_12481) && axis != class_2350.class_2351.field_11052) {
                appliedState = (class_2680)appliedState.method_11657((class_2769)class_2741.field_12481, (Comparable)face);
            }
            if (appliedState.method_28498((class_2769)class_2741.field_12496)) {
                appliedState = (class_2680)appliedState.method_11657((class_2769)class_2741.field_12496, (Comparable)axis);
            }
            if (appliedState.method_28498((class_2769)class_2741.field_12529) && axis != class_2350.class_2351.field_11052) {
                appliedState = (class_2680)appliedState.method_11657((class_2769)class_2741.field_12529, (Comparable)axis);
            }
        }
        return appliedState;
    }

    default public boolean isAcceptedRegardless(class_2680 material) {
        return false;
    }

    default public class_2680 prepareMaterial(class_1937 pLevel, class_2338 pPos, class_2680 pState, class_1657 pPlayer, class_1268 pHand, class_3965 pHit, class_2680 material) {
        return material;
    }

    default public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 ray) {
        class_1269 result;
        if (player.method_5998(hand).method_31573(AllTags.AllItemTags.WRENCH.tag) && (result = ((WrenchItem)AllItems.WRENCH.get()).method_7884(new class_1838(player, hand, ray))).method_23665()) {
            return result;
        }
        result = this.toggleCT(state, world, pos, player, hand, ray);
        if (result.method_23665()) {
            return result;
        }
        if (player == null || !player.method_7294()) {
            return class_1269.field_5811;
        }
        class_2350 face = ray.method_17780();
        class_1799 itemInHand = player.method_5998(hand);
        class_2680 materialIn = this.getAcceptedBlockState(world, pos, itemInHand, face);
        if (materialIn != null) {
            materialIn = this.prepareMaterial(world, pos, state, player, hand, ray, materialIn);
        }
        if (materialIn == null) {
            return class_1269.field_5811;
        }
        class_2680 material = materialIn;
        ICopycatBlockEntity copycatBE = this.getCopycatBlockEntity((class_1922)world, pos);
        if (copycatBE == null) {
            return class_1269.field_5811;
        }
        if (copycatBE.getMaterial().method_27852(material.method_26204())) {
            if (!copycatBE.cycleMaterial()) {
                return class_1269.field_5811;
            }
            copycatBE.method_10997().method_8396(null, copycatBE.method_11016(), class_3417.field_14667, class_3419.field_15245, 0.75f, 0.95f);
            return class_1269.field_5812;
        }
        if (copycatBE.hasCustomMaterial()) {
            return class_1269.field_5811;
        }
        if (world.method_8608()) {
            return class_1269.field_5812;
        }
        copycatBE.setMaterial(material);
        copycatBE.setConsumedItem(itemInHand);
        copycatBE.method_10997().method_8396(null, copycatBE.method_11016(), material.method_26231().method_10598(), class_3419.field_15245, 1.0f, 0.75f);
        if (player.method_7337()) {
            return class_1269.field_5812;
        }
        itemInHand.method_7934(1);
        if (itemInHand.method_7960()) {
            player.method_6122(hand, class_1799.field_8037);
        }
        return class_1269.field_5812;
    }

    default public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        class_1657 player;
        if (placer == null) {
            return;
        }
        class_1799 offhandItem = placer.method_5998(class_1268.field_5810);
        class_2680 appliedState = this.getAcceptedBlockState(worldIn, pos, offhandItem, class_2350.method_10159((class_1297)placer)[0]);
        if (appliedState == null) {
            return;
        }
        ICopycatBlockEntity copycatBE = this.getCopycatBlockEntity((class_1922)worldIn, pos);
        if (copycatBE == null) {
            return;
        }
        if (copycatBE.hasCustomMaterial()) {
            return;
        }
        copycatBE.setMaterial(appliedState);
        copycatBE.setConsumedItem(offhandItem);
        if (placer instanceof class_1657 && (player = (class_1657)placer).method_7337()) {
            return;
        }
        offhandItem.method_7934(1);
        if (offhandItem.method_7960()) {
            placer.method_6122(class_1268.field_5810, class_1799.field_8037);
        }
    }

    default public void onRemove(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean isMoving, OnRemoveHandler handler) {
        ICopycatBlockEntity copycatBE;
        if (!state.method_31709() || state.method_26204() == newState.method_26204()) {
            return;
        }
        if (!isMoving && (copycatBE = this.getCopycatBlockEntity((class_1922)world, pos)) != null) {
            class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)copycatBE.getConsumedItem());
        }
        handler.handle(state, world, pos, newState, isMoving);
        world.method_8544(pos);
    }

    default public void method_9576(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        ICopycatBlockEntity copycatBE;
        if (player.method_7337() && (copycatBE = this.getCopycatBlockEntity((class_1922)level, pos)) != null) {
            copycatBE.setConsumedItem(class_1799.field_8037);
        }
    }

    public static class_2680 getAppearance(ICopycatBlock block, class_2680 state, class_1920 level, class_2338 pos, class_2350 side, class_2680 queryState, class_2338 queryPos) {
        if (block.isIgnoredConnectivitySide(level, state, side, pos, queryPos, queryState)) {
            return state;
        }
        class_2680 material = ICopycatBlock.getMaterial((class_1922)level, pos);
        return material.method_27852(class_2246.field_10124) ? AllBlocks.COPYCAT_BASE.getDefaultState() : material;
    }

    public static class_2680 getMaterial(class_1922 reader, class_2338 targetPos) {
        class_2586 class_25862 = reader.method_8321(targetPos);
        if (class_25862 instanceof ICopycatBlockEntity) {
            ICopycatBlockEntity cbe = (ICopycatBlockEntity)class_25862;
            return cbe.getMaterial();
        }
        return class_2246.field_10124.method_9564();
    }

    public static ItemRequirement getRequiredItemsForLayer(class_2680 state, class_2758 property) {
        int count = (Integer)state.method_11654((class_2769)property);
        if (count == 0) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(IntStream.range(0, count).mapToObj($ -> new ItemRequirement.StackRequirement(new class_1799((class_1935)state.method_26204().method_8389()), ItemRequirement.ItemUseType.CONSUME)).toList());
    }

    @NotNull
    default public class_2680 method_9598(@NotNull class_2680 pState, class_2470 pRot) {
        return this.transform(pState, new StructureTransform(class_2338.field_10980, class_2350.class_2351.field_11052, pRot, class_2415.field_11302));
    }

    @NotNull
    default public class_2680 method_9569(@NotNull class_2680 pState, @NotNull class_2415 pMirror) {
        return this.transform(pState, new StructureTransform(class_2338.field_10980, null, class_2470.field_11467, pMirror));
    }

    default public class_2680 transform(class_2680 state, StructureTransform transform) {
        boolean halfTurn;
        class_2350.class_2351 rotationAxis = transform.rotationAxis;
        class_2470 rotation = transform.rotation;
        class_2415 mirror = transform.mirror;
        class_2248 block = state.method_26204();
        if (mirror != null) {
            state = state.method_26185(mirror);
        }
        if (rotationAxis == class_2350.class_2351.field_11052) {
            if (block instanceof class_3709) {
                if (state.method_11654((class_2769)class_2741.field_17104) == class_3867.field_17101) {
                    state = (class_2680)state.method_11657((class_2769)class_2741.field_17104, (Comparable)class_3867.field_17100);
                }
                return (class_2680)state.method_11657((class_2769)class_3709.field_16324, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)class_3709.field_16324)));
            }
            return state.method_26186(rotation);
        }
        if (block instanceof class_2341) {
            class_2350 forcedAxis;
            class_2753 facingProperty = class_2341.field_11177;
            class_2754 faceProperty = class_2341.field_11007;
            class_2350 stateFacing = (class_2350)state.method_11654((class_2769)facingProperty);
            class_2738 stateFace = (class_2738)state.method_11654((class_2769)faceProperty);
            boolean z = rotationAxis == class_2350.class_2351.field_11051;
            class_2350 class_23502 = forcedAxis = z ? class_2350.field_11039 : class_2350.field_11035;
            if (stateFacing.method_10166() == rotationAxis && stateFace == class_2738.field_12471) {
                return state;
            }
            for (int i = 0; i < rotation.ordinal(); ++i) {
                stateFace = (class_2738)state.method_11654((class_2769)faceProperty);
                stateFacing = (class_2350)state.method_11654((class_2769)facingProperty);
                boolean b = state.method_11654((class_2769)faceProperty) == class_2738.field_12473;
                state = (class_2680)state.method_11657((class_2769)facingProperty, (Comparable)(b ? forcedAxis : forcedAxis.method_10153()));
                state = stateFace != class_2738.field_12471 ? (class_2680)state.method_11657((class_2769)faceProperty, (Comparable)class_2738.field_12471) : (stateFacing.method_10171() == (z ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056) ? (class_2680)state.method_11657((class_2769)faceProperty, (Comparable)class_2738.field_12475) : (class_2680)state.method_11657((class_2769)faceProperty, (Comparable)class_2738.field_12473));
            }
            return state;
        }
        boolean bl = halfTurn = rotation == class_2470.field_11464;
        if (block instanceof class_2510) {
            if (((class_2350)state.method_11654((class_2769)class_2510.field_11571)).method_10166() != rotationAxis) {
                for (int i = 0; i < rotation.ordinal(); ++i) {
                    class_2350 direction = (class_2350)state.method_11654((class_2769)class_2510.field_11571);
                    class_2760 half = (class_2760)state.method_11654((class_2769)class_2510.field_11572);
                    state = direction.method_10171() == class_2350.class_2352.field_11056 ^ half == class_2760.field_12617 ^ direction.method_10166() == class_2350.class_2351.field_11051 ? (class_2680)state.method_28493((class_2769)class_2510.field_11572) : (class_2680)state.method_11657((class_2769)class_2510.field_11571, (Comparable)direction.method_10153());
                }
            } else if (halfTurn) {
                state = (class_2680)state.method_28493((class_2769)class_2510.field_11572);
            }
            return state;
        }
        if (state.method_28498((class_2769)class_2741.field_12525)) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)transform.rotateFacing((class_2350)state.method_11654((class_2769)class_2741.field_12525)));
        } else if (state.method_28498((class_2769)class_2741.field_12496)) {
            state = (class_2680)state.method_11657((class_2769)class_2741.field_12496, (Comparable)transform.rotateAxis((class_2350.class_2351)state.method_11654((class_2769)class_2741.field_12496)));
        } else if (halfTurn) {
            class_2350 stateFacing;
            if (state.method_28498((class_2769)class_2741.field_12481) && (stateFacing = (class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10166() == rotationAxis) {
                return state;
            }
            if ((state = state.method_26186(rotation)).method_28498((class_2769)class_2482.field_11501) && state.method_11654((class_2769)class_2482.field_11501) != class_2771.field_12682) {
                state = (class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)(state.method_11654((class_2769)class_2482.field_11501) == class_2771.field_12681 ? class_2771.field_12679 : class_2771.field_12681));
            }
        }
        return state;
    }

    default public boolean isIgnoredConnectivitySide(class_1920 reader, class_2680 fromState, class_2350 face, class_2338 fromPos, class_2338 toPos, class_2680 toState) {
        if (CopycatExternalContext.isForBlockingLogic()) {
            return false;
        }
        toState = reader.method_8320(toPos);
        return !this.checkConnection(reader, toPos, fromPos, toState);
    }

    default public boolean canConnectTexturesToward(class_1920 reader, class_2338 fromPos, class_2338 toPos, class_2680 fromState) {
        class_2680 toState = reader.method_8320(toPos);
        if (toState.method_26204() instanceof ICopycatBlock) {
            return true;
        }
        return this.checkConnection(reader, fromPos, toPos, fromState);
    }

    default public boolean checkConnection(class_1920 reader, class_2338 fromPos, class_2338 toPos, class_2680 fromState) {
        class_2338 diff = toPos.method_10059((class_2382)fromPos);
        if (diff.equals((Object)class_2382.field_11176)) {
            return true;
        }
        class_2350 facing = class_2350.method_50026((int)diff.method_10263(), (int)diff.method_10264(), (int)diff.method_10260());
        class_2680 toState = reader.method_8320(toPos);
        if (facing != null) {
            return BlockFaceUtils.faceMatch((class_1922)reader, fromState, fromPos, toState, toPos, facing);
        }
        if (diff.method_10263() != 0 && diff.method_10264() != 0 && diff.method_10260() != 0) {
            return true;
        }
        for (class_2350.class_2351 axis : Iterate.axes) {
            class_2382 remainingDiff;
            class_2350 remainingFacing;
            if (diff.method_30558(axis) == 0) continue;
            class_2382 axisDiff = class_2382.field_11176;
            class_2338 midPos = fromPos.method_10081(axisDiff = axisDiff.method_35850(axis, diff.method_30558(axis)));
            class_2680 midState = reader.method_8320(midPos);
            if (BlockFaceUtils.faceMatch((class_1922)reader, midState, midPos, toState, toPos, remainingFacing = class_2350.method_50026((int)(remainingDiff = diff.method_35852(axisDiff)).method_10263(), (int)remainingDiff.method_10264(), (int)remainingDiff.method_10260()))) continue;
            return false;
        }
        return true;
    }

    default public boolean canOcclude(class_1922 level, class_2680 state, class_2338 pos) {
        class_2680 material = ICopycatBlock.getMaterial(level, pos);
        if (AllBlocks.COPYCAT_BASE.has(material)) {
            return false;
        }
        return material.method_26225();
    }

    default public Optional<Boolean> shapeCanOccludeNeighbor(class_1922 level, class_2338 pos, class_2680 state, class_2338 neighborPos, class_2350 dir) {
        return Optional.empty();
    }

    /*
     * Unable to fully structure code
     */
    public static boolean hidesNeighborFace(class_1922 level, class_2338 pos, class_2680 state, class_2680 neighborState, class_2350 dir) {
        toPos = pos.method_10093(dir);
        if (!(level instanceof ScaledBlockAndTintGetter)) ** GOTO lbl-1000
        scaledLevel = (ScaledBlockAndTintGetter)level;
        if (state.method_26204() instanceof IMultiStateCopycatBlock) {
            CopycatExternalContext.setPropertyForAppearance(scaledLevel.getPropertyForRender(state, pos));
        } else lbl-1000:
        // 2 sources

        {
            CopycatExternalContext.setPropertyForAppearance(null);
        }
        if (BlockFaceUtils.canOcclude(level, neighborState, toPos, state, pos, dir.method_10153())) {
            v0 = state.method_26204() instanceof IMultiStateCopycatBlock != false ? IMultiStateCopycatBlock.getMaterial(level, pos, CopycatExternalContext.getPropertyForAppearance()) : (material = state.method_26204() instanceof ICopycatBlock != false ? ICopycatBlock.getMaterial(level, pos) : state);
            if (neighborState.method_26204() instanceof IMultiStateCopycatBlock && level instanceof ScaledBlockAndTintGetter) {
                scaledLevel = (ScaledBlockAndTintGetter)level;
                v1 = IMultiStateCopycatBlock.getMaterial(level, toPos, scaledLevel.getPropertyForRender(neighborState, toPos));
            } else {
                v1 = neighborState.method_26204() instanceof ICopycatBlock != false ? ICopycatBlock.getMaterial(level, toPos) : neighborState;
            }
            neighborMaterial = v1;
            return material.method_26187(neighborMaterial, dir.method_10153());
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static class_322 wrappedColor() {
        return new WrappedBlockColor();
    }

    @FunctionalInterface
    public static interface OnRemoveHandler {
        public void handle(class_2680 var1, class_1937 var2, class_2338 var3, class_2680 var4, boolean var5);
    }

    @Environment(value=EnvType.CLIENT)
    public static class WrappedBlockColor
    implements class_322 {
        public int getColor(class_2680 pState, @Nullable class_1920 pLevel, @Nullable class_2338 pPos, int pTintIndex) {
            if (pLevel == null || pPos == null) {
                return class_1933.method_49724();
            }
            return class_310.method_1551().method_1505().method_1697(ICopycatBlock.getMaterial((class_1922)pLevel, pPos), pLevel, pPos, pTintIndex);
        }
    }
}

