/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core;

import java.nio.file.Path;
import java.util.ArrayList;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.ConfigTools;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.modpack.Modpack;
import pl.skidam.automodpack_core.modpack.ModpackContent;

public class Server {
    public static void main(String[] args) {
        ModpackContent modpackContent;
        Modpack modpack;
        boolean generated;
        Jsons.ServerCoreConfigFields serverCoreConfig;
        if (args.length < 1) {
            GlobalVariables.LOGGER.error("Modpack id not provided!");
            return;
        }
        String modpackDirStr = args[0];
        Path cwd = Path.of(System.getProperty("user.dir"), new String[0]);
        Path modpackDir = cwd.resolve("modpacks").resolve(modpackDirStr);
        modpackDir.toFile().mkdirs();
        GlobalVariables.hostModpackContentFile = modpackDir.resolve("automodpack-content.json");
        GlobalVariables.serverConfigFile = modpackDir.resolve("automodpack-server.json");
        GlobalVariables.serverCoreConfigFile = modpackDir.resolve("automodpack-core.json");
        GlobalVariables.serverConfig = ConfigTools.load(GlobalVariables.serverConfigFile, Jsons.ServerConfigFields.class);
        if (GlobalVariables.serverConfig != null) {
            GlobalVariables.serverConfig.syncedFiles = new ArrayList<String>();
            ConfigTools.save(GlobalVariables.serverConfigFile, GlobalVariables.serverConfig);
        }
        if ((serverCoreConfig = ConfigTools.load(GlobalVariables.serverCoreConfigFile, Jsons.ServerCoreConfigFields.class)) != null) {
            GlobalVariables.AM_VERSION = serverCoreConfig.automodpackVersion;
            GlobalVariables.LOADER = serverCoreConfig.loader;
            GlobalVariables.LOADER_VERSION = serverCoreConfig.loaderVersion;
            GlobalVariables.MC_VERSION = serverCoreConfig.mcVersion;
            ConfigTools.save(GlobalVariables.serverCoreConfigFile, serverCoreConfig);
        }
        if (generated = (modpack = new Modpack()).generateNew(modpackContent = new ModpackContent(GlobalVariables.serverConfig.modpackName, null, modpackDir, GlobalVariables.serverConfig.syncedFiles, GlobalVariables.serverConfig.allowEditsInFiles, modpack.CREATION_EXECUTOR))) {
            GlobalVariables.LOGGER.info("Modpack generated!");
        } else {
            GlobalVariables.LOGGER.error("Failed to generate modpack!");
        }
        modpack.CREATION_EXECUTOR.shutdownNow();
    }
}

