/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.modpack;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.modpack.ModpackContent;
import pl.skidam.automodpack_core.utils.CustomThreadFactoryBuilder;

public class Modpack {
    public final ThreadPoolExecutor CREATION_EXECUTOR = (ThreadPoolExecutor)Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors() * 2), new CustomThreadFactoryBuilder().setNameFormat("AutoModpackCreation-%d").build());
    public final Map<String, ModpackContent> modpacks = Collections.synchronizedMap(new HashMap());

    private ModpackContent init() {
        if (this.isGenerating()) {
            GlobalVariables.LOGGER.error("Called generate() twice!");
            return null;
        }
        try {
            if (!Files.exists(GlobalVariables.hostContentModpackDir, new LinkOption[0])) {
                Files.createDirectories(GlobalVariables.hostContentModpackDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Path cwd = Path.of(System.getProperty("user.dir"), new String[0]);
        return new ModpackContent(GlobalVariables.serverConfig.modpackName, cwd, GlobalVariables.hostContentModpackDir, GlobalVariables.serverConfig.syncedFiles, GlobalVariables.serverConfig.allowEditsInFiles, this.CREATION_EXECUTOR);
    }

    public boolean generateNew(ModpackContent content) {
        if (content == null) {
            return false;
        }
        boolean generated = content.create();
        this.modpacks.put(content.getModpackName(), content);
        return generated;
    }

    public boolean generateNew() {
        ModpackContent content = this.init();
        if (content == null) {
            return false;
        }
        boolean generated = content.create();
        this.modpacks.put(content.getModpackName(), content);
        return generated;
    }

    public boolean loadLast() {
        ModpackContent content = this.init();
        if (content == null) {
            return false;
        }
        boolean generated = content.loadPreviousContent();
        this.modpacks.put(content.getModpackName(), content);
        return generated;
    }

    public boolean generate(String modpackName) {
        if (this.isGenerating()) {
            GlobalVariables.LOGGER.error("Called generate() twice!");
            return false;
        }
        try {
            if (!Files.exists(GlobalVariables.hostContentModpackDir, new LinkOption[0])) {
                Files.createDirectories(GlobalVariables.hostContentModpackDir, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ModpackContent content = this.modpacks.get(modpackName);
        if (content == null) {
            GlobalVariables.LOGGER.error("Modpack with name " + modpackName + " does not exist!");
            return false;
        }
        boolean generated = content.create();
        this.modpacks.put(content.getModpackName(), content);
        return generated;
    }

    public boolean isGenerating() {
        int activeCount = this.CREATION_EXECUTOR.getActiveCount();
        int queueSize = this.CREATION_EXECUTOR.getQueue().size();
        return activeCount > 0 || queueSize > 0;
    }

    public void shutdownExecutor() {
        this.CREATION_EXECUTOR.shutdown();
        try {
            if (!this.CREATION_EXECUTOR.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.CREATION_EXECUTOR.shutdownNow();
                if (!this.CREATION_EXECUTOR.awaitTermination(3L, TimeUnit.SECONDS)) {
                    GlobalVariables.LOGGER.error("CREATION Executor did not terminate");
                }
            }
        }
        catch (InterruptedException e) {
            this.CREATION_EXECUTOR.shutdownNow();
        }
    }
}

