/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.ConfigTools;
import pl.skidam.automodpack_core.netty.HttpServerHandler;
import pl.skidam.automodpack_core.utils.CustomThreadFactoryBuilder;
import pl.skidam.automodpack_core.utils.Ip;
import pl.skidam.automodpack_core.utils.ObservableMap;

public class HttpServer {
    public static final String HTTP_REQUEST_BASE = "/automodpack/";
    public static final String HTTP_REQUEST_GET = "GET /automodpack/";
    public static final String HTTP_REQUEST_REFRESH = "POST /automodpack/refresh";
    public static final byte[] HTTP_REQUEST_GET_BASE_BYTES = "GET /automodpack/".getBytes(StandardCharsets.UTF_8);
    public static final byte[] HTTP_REQUEST_REFRESH_BYTES = "POST /automodpack/refresh".getBytes(StandardCharsets.UTF_8);
    private final Map<String, Path> paths = Collections.synchronizedMap(new HashMap());
    private ChannelFuture serverChannel;
    private Boolean shouldHost = false;

    public void addPaths(ObservableMap<String, Path> paths) {
        this.paths.putAll(paths.getMap());
        paths.addOnPutCallback(this.paths::put);
        paths.addOnRemoveCallback(this.paths::remove);
    }

    public void removePaths(ObservableMap<String, Path> paths) {
        paths.getMap().forEach(this.paths::remove);
    }

    public Optional<Path> getPath(String hash) {
        return Optional.ofNullable(this.paths.get(hash));
    }

    public Optional<ChannelFuture> start() {
        EpollEventLoopGroup eventLoopGroup;
        Class<EpollServerSocketChannel> socketChannelClass;
        if (!this.canStart()) {
            return Optional.empty();
        }
        int port = GlobalVariables.serverConfig.hostPort;
        InetAddress address = new InetSocketAddress(port).getAddress();
        if (Epoll.isAvailable()) {
            socketChannelClass = EpollServerSocketChannel.class;
            eventLoopGroup = new EpollEventLoopGroup(new CustomThreadFactoryBuilder().setNameFormat("AutoModpack Epoll Server IO #%d").setDaemon(true).build());
        } else {
            socketChannelClass = NioServerSocketChannel.class;
            eventLoopGroup = new NioEventLoopGroup(new CustomThreadFactoryBuilder().setNameFormat("AutoModpack Server IO #%d").setDaemon(true).build());
        }
        this.serverChannel = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(socketChannelClass)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                try {
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                HttpServer.this.shouldHost = true;
                channel.pipeline().addLast("automodpack_http", (ChannelHandler)new HttpServerHandler());
            }
        }).group((EventLoopGroup)eventLoopGroup).localAddress(address, port)).bind().syncUninterruptibly();
        return Optional.ofNullable(this.serverChannel);
    }

    public boolean stop() {
        if (this.serverChannel == null) {
            if (this.shouldHost.booleanValue()) {
                this.shouldHost = false;
                return true;
            }
            return false;
        }
        try {
            this.serverChannel.channel().close().sync();
        }
        catch (InterruptedException e) {
            GlobalVariables.LOGGER.error("Interrupted server channel", (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean isRunning() {
        if (this.serverChannel == null) {
            return this.shouldHost;
        }
        return this.serverChannel.channel().isOpen();
    }

    private boolean canStart() {
        if (this.isRunning()) {
            return false;
        }
        if (!GlobalVariables.serverConfig.modpackHost) {
            GlobalVariables.LOGGER.warn("Modpack hosting is disabled in config");
            return false;
        }
        if (this.paths.isEmpty()) {
            GlobalVariables.LOGGER.warn("No file to host. Can't start modpack host server.");
            return false;
        }
        if (GlobalVariables.serverConfig.hostModpackOnMinecraftPort) {
            this.shouldHost = true;
            GlobalVariables.LOGGER.info("Hosting modpack on Minecraft port");
            return false;
        }
        if (GlobalVariables.serverConfig.updateIpsOnEveryStart || GlobalVariables.serverConfig.hostIp == null || GlobalVariables.serverConfig.hostIp.isEmpty()) {
            String publicIp = Ip.getPublic();
            if (publicIp != null) {
                GlobalVariables.serverConfig.hostIp = publicIp;
                ConfigTools.save(GlobalVariables.serverConfigFile, GlobalVariables.serverConfig);
                GlobalVariables.LOGGER.warn("Setting Host IP to {}", (Object)GlobalVariables.serverConfig.hostIp);
            } else {
                GlobalVariables.LOGGER.error("Host IP isn't set in config, please change it manually! Couldn't get public IP");
                return false;
            }
        }
        if (GlobalVariables.serverConfig.updateIpsOnEveryStart || GlobalVariables.serverConfig.hostLocalIp == null || GlobalVariables.serverConfig.hostLocalIp.isEmpty()) {
            try {
                GlobalVariables.serverConfig.hostLocalIp = Ip.getLocal();
                ConfigTools.save(GlobalVariables.serverConfigFile, GlobalVariables.serverConfig);
                GlobalVariables.LOGGER.warn("Setting Host local IP to {}", (Object)GlobalVariables.serverConfig.hostLocalIp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }
}

