/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_core.utils;

import com.google.gson.JsonObject;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.utils.Json;

public class Ip {
    public static String getPublic() {
        JsonObject JSON = null;
        try {
            JSON = Json.fromUrl("https://ip.seeip.org/json");
        }
        catch (Exception e) {
            try {
                JSON = Json.fromUrl("https://api.ipify.org?format=json");
            }
            catch (Exception ex) {
                GlobalVariables.LOGGER.error("AutoModpack couldn't get your public IP address, you need to type it manually into config");
            }
        }
        if (JSON != null) {
            return JSON.get("ip").getAsString();
        }
        return null;
    }

    public static String getLocal() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (addr.isLinkLocalAddress() || !(addr instanceof Inet4Address)) continue;
                    return addr.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getLocalIpv6() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                if (networkInterface.isLoopback() || !networkInterface.isUp()) continue;
                Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (!(addr instanceof Inet6Address)) continue;
                    String hostAddress = addr.getHostAddress();
                    int idx = hostAddress.indexOf(37);
                    return idx < 0 ? hostAddress : hostAddress.substring(0, idx);
                }
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean areIpsEqual(String ip1, String ip2) {
        if (ip1 == null || ip2 == null) {
            return false;
        }
        try {
            InetAddress ia1 = InetAddress.getByName(ip1);
            InetAddress ia2 = InetAddress.getByName(ip2);
            return ia1.equals(ia2);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
    }

    public static String refactorToTrueIp(String mcIp) {
        int scopeIdx;
        int portIdx;
        if (mcIp == null) {
            return null;
        }
        String formattedPlayerIp = mcIp.trim();
        if (formattedPlayerIp.charAt(0) == '/') {
            formattedPlayerIp = formattedPlayerIp.substring(1);
        }
        if ((portIdx = formattedPlayerIp.lastIndexOf(58)) > 0) {
            formattedPlayerIp = formattedPlayerIp.substring(0, portIdx);
        }
        if (formattedPlayerIp.startsWith("[") && formattedPlayerIp.endsWith("]") && (scopeIdx = (formattedPlayerIp = formattedPlayerIp.substring(1, formattedPlayerIp.length() - 1)).indexOf(37)) > 0) {
            formattedPlayerIp = formattedPlayerIp.substring(0, scopeIdx);
        }
        return formattedPlayerIp;
    }

    public static boolean isLocal(String ipToCheck, String configLocalIp) {
        boolean isLocal2;
        boolean isLocal1;
        if (ipToCheck == null) {
            return true;
        }
        if (configLocalIp != null) {
            if (Ip.areIpsEqual(ipToCheck, configLocalIp)) {
                return true;
            }
            String reducedConfigLocalIp = configLocalIp;
            if (configLocalIp.split("\\.").length == 4) {
                reducedConfigLocalIp = configLocalIp.substring(0, configLocalIp.lastIndexOf("."));
            }
            if (ipToCheck.startsWith(reducedConfigLocalIp)) {
                return true;
            }
        }
        boolean bl = isLocal1 = ipToCheck.startsWith("192.168.") || ipToCheck.startsWith("0:0:0:0:") || ipToCheck.startsWith("::") || Ip.areIpsEqual(ipToCheck, "127.0.0.1");
        if (isLocal1) {
            return true;
        }
        boolean bl2 = isLocal2 = Ip.areIpsEqual(ipToCheck, Ip.getLocal()) || Ip.areIpsEqual(ipToCheck, Ip.getLocalIpv6());
        return isLocal2;
    }
}

