/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_core.config.ConfigTools;
import pl.skidam.automodpack_core.config.Jsons;
import pl.skidam.automodpack_core.loader.LoaderService;
import pl.skidam.automodpack_core.utils.CustomFileUtils;
import pl.skidam.automodpack_core.utils.FileInspection;
import pl.skidam.automodpack_core.utils.ManifestReader;
import pl.skidam.automodpack_core.utils.ModpackContentTools;
import pl.skidam.automodpack_loader_core.SelfUpdater;
import pl.skidam.automodpack_loader_core.client.ModpackUpdater;
import pl.skidam.automodpack_loader_core.client.ModpackUtils;
import pl.skidam.automodpack_loader_core.loader.LoaderManager;

public class Preload {
    public Preload() {
        try {
            long start = System.currentTimeMillis();
            GlobalVariables.LOGGER.info("Prelaunching AutoModpack...");
            this.initializeGlobalVariables();
            this.loadConfigs();
            this.createPaths();
            this.updateAll();
            GlobalVariables.LOGGER.info("AutoModpack prelaunched! took " + (System.currentTimeMillis() - start) + "ms");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void updateAll() {
        Optional<Path> optionalSelectedModpackDir = ModpackContentTools.getModpackDir(GlobalVariables.clientConfig.selectedModpack);
        if (GlobalVariables.LOADER_MANAGER.getEnvironmentType() == LoaderService.EnvironmentType.SERVER || optionalSelectedModpackDir.isEmpty()) {
            SelfUpdater.update();
            return;
        }
        GlobalVariables.selectedModpackDir = optionalSelectedModpackDir.get();
        String selectedModpackLink = "";
        if (!GlobalVariables.clientConfig.selectedModpack.isBlank() && GlobalVariables.clientConfig.installedModpacks.containsKey(GlobalVariables.clientConfig.selectedModpack)) {
            selectedModpackLink = GlobalVariables.clientConfig.installedModpacks.get(GlobalVariables.clientConfig.selectedModpack);
        }
        if (selectedModpackLink == null || selectedModpackLink.isBlank()) {
            SelfUpdater.update();
            return;
        }
        Optional<Jsons.ModpackContentFields> optionalLatestModpackContent = ModpackUtils.requestServerModpackContent(selectedModpackLink);
        Jsons.ModpackContentFields latestModpackContent = ConfigTools.loadModpackContent(GlobalVariables.selectedModpackDir.resolve(GlobalVariables.hostModpackContentFile.getFileName()));
        if (optionalLatestModpackContent.isPresent()) {
            latestModpackContent = optionalLatestModpackContent.get();
        }
        CustomFileUtils.deleteDummyFiles(Path.of(System.getProperty("user.dir"), new String[0]), latestModpackContent == null ? null : latestModpackContent.list);
        if (SelfUpdater.update(latestModpackContent)) {
            return;
        }
        new ModpackUpdater().startModpackUpdate(latestModpackContent, selectedModpackLink, GlobalVariables.selectedModpackDir);
    }

    private void initializeGlobalVariables() {
        GlobalVariables.preload = true;
        GlobalVariables.LOADER_MANAGER = new LoaderManager();
        GlobalVariables.MC_VERSION = GlobalVariables.LOADER_MANAGER.getModVersion("minecraft");
        GlobalVariables.AM_VERSION = ManifestReader.getAutoModpackVersion();
        GlobalVariables.LOADER_VERSION = GlobalVariables.LOADER_MANAGER.getLoaderVersion();
        GlobalVariables.LOADER = GlobalVariables.LOADER_MANAGER.getPlatformType().toString().toLowerCase();
        GlobalVariables.AUTOMODPACK_JAR = FileInspection.getAutoModpackJar();
        GlobalVariables.MODS_DIR = GlobalVariables.AUTOMODPACK_JAR.getParent();
        try (ZipFile zipFile = new ZipFile(GlobalVariables.AUTOMODPACK_JAR.toFile());){
            ZipEntry entry = zipFile.getEntry("overrides-automodpack-client.json");
            if (entry != null) {
                GlobalVariables.clientConfigOverride = new String(zipFile.getInputStream(entry).readAllBytes());
            }
        }
        catch (IOException e) {
            GlobalVariables.LOGGER.error("Failed to open the jar file", (Throwable)e);
        }
    }

    private void loadConfigs() {
        long startTime = System.currentTimeMillis();
        if (GlobalVariables.clientConfigOverride == null) {
            GlobalVariables.clientConfig = ConfigTools.load(GlobalVariables.clientConfigFile, Jsons.ClientConfigFields.class);
        } else {
            GlobalVariables.LOGGER.warn("You are using unofficial {} mod", (Object)"automodpack");
            GlobalVariables.LOGGER.warn("Using client config overrides! Editing the {} file will have no effect", (Object)GlobalVariables.clientConfigFile);
            GlobalVariables.LOGGER.warn("Remove the {} file from inside the jar or remove and download fresh {} mod jar from modrinth/curseforge", (Object)"overrides-automodpack-client.json", (Object)"automodpack");
            GlobalVariables.clientConfig = ConfigTools.load(GlobalVariables.clientConfigOverride, Jsons.ClientConfigFields.class);
        }
        GlobalVariables.serverConfig = ConfigTools.load(GlobalVariables.serverConfigFile, Jsons.ServerConfigFields.class);
        if (GlobalVariables.serverConfig != null) {
            int previousServerConfigVersion = GlobalVariables.serverConfig.DO_NOT_CHANGE_IT;
            GlobalVariables.serverConfig.DO_NOT_CHANGE_IT = new Jsons.ServerConfigFields().DO_NOT_CHANGE_IT;
            if (previousServerConfigVersion != GlobalVariables.serverConfig.DO_NOT_CHANGE_IT) {
                GlobalVariables.LOGGER.info("Updated server config version to {}", (Object)GlobalVariables.serverConfig.DO_NOT_CHANGE_IT);
            }
            if (GlobalVariables.serverConfig.acceptedLoaders == null) {
                GlobalVariables.serverConfig.acceptedLoaders = List.of(GlobalVariables.LOADER);
            } else if (!GlobalVariables.serverConfig.acceptedLoaders.contains(GlobalVariables.LOADER)) {
                GlobalVariables.serverConfig.acceptedLoaders.add(GlobalVariables.LOADER);
            }
            if (!GlobalVariables.serverConfig.modpackName.isEmpty() && FileInspection.isInValidFileName(GlobalVariables.serverConfig.modpackName)) {
                GlobalVariables.serverConfig.modpackName = FileInspection.fixFileName(GlobalVariables.serverConfig.modpackName);
                GlobalVariables.LOGGER.info("Changed modpack name to {}", (Object)GlobalVariables.serverConfig.modpackName);
            }
            ConfigTools.save(GlobalVariables.serverConfigFile, GlobalVariables.serverConfig);
        }
        if (GlobalVariables.clientConfig != null) {
            int previousClientConfigVersion = GlobalVariables.clientConfig.DO_NOT_CHANGE_IT;
            GlobalVariables.clientConfig.DO_NOT_CHANGE_IT = new Jsons.ClientConfigFields().DO_NOT_CHANGE_IT;
            if (previousClientConfigVersion != GlobalVariables.clientConfig.DO_NOT_CHANGE_IT) {
                if (GlobalVariables.clientConfigOverride == null) {
                    GlobalVariables.LOGGER.info("Updated client config version to {}", (Object)GlobalVariables.clientConfig.DO_NOT_CHANGE_IT);
                } else {
                    GlobalVariables.LOGGER.error("Client config version is outdated!");
                }
            }
            if (GlobalVariables.clientConfig.installedModpacks == null) {
                GlobalVariables.clientConfig.installedModpacks = new HashMap<String, String>();
            }
            ConfigTools.save(GlobalVariables.clientConfigFile, GlobalVariables.clientConfig);
        }
        GlobalVariables.LOGGER.info("Loaded config! took " + (System.currentTimeMillis() - startTime) + "ms");
    }

    private void createPaths() throws IOException {
        Path modpacks;
        Path AMDir = Paths.get("./automodpack/", new String[0]);
        if (!Files.exists(AMDir, new LinkOption[0])) {
            Files.createDirectories(AMDir, new FileAttribute[0]);
        }
        if (new LoaderManager().getEnvironmentType() == LoaderService.EnvironmentType.CLIENT && !Files.exists(modpacks = Paths.get("./automodpack/modpacks/", new String[0]), new LinkOption[0])) {
            Files.createDirectories(modpacks, new FileAttribute[0]);
        }
    }
}

