/*
 * Decompiled with CFR 0.152.
 */
package pl.skidam.automodpack_loader_core_15.mods;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.LanguageAdapter;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.ModContainerImpl;
import net.fabricmc.loader.impl.discovery.DirectoryModCandidateFinder;
import net.fabricmc.loader.impl.discovery.ModCandidate;
import net.fabricmc.loader.impl.discovery.ModDiscoverer;
import net.fabricmc.loader.impl.discovery.ModResolutionException;
import net.fabricmc.loader.impl.discovery.ModResolver;
import net.fabricmc.loader.impl.discovery.RuntimeModRemapper;
import net.fabricmc.loader.impl.gui.FabricGuiEntry;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.loader.impl.metadata.DependencyOverrides;
import net.fabricmc.loader.impl.metadata.VersionOverrides;
import pl.skidam.automodpack_core.GlobalVariables;
import pl.skidam.automodpack_loader_core.FabricLanguageAdapter;
import pl.skidam.automodpack_loader_core.FabricLoaderImplAccessor;
import pl.skidam.automodpack_loader_core.mods.ModpackLoaderService;
import pl.skidam.automodpack_loader_core_15.mods.ModContainerModCandidateFinder;

public class ModpackLoader15
implements ModpackLoaderService {
    private final Map<String, Set<ModCandidate>> envDisabledMods = new HashMap<String, Set<ModCandidate>>();

    @Override
    public void loadModpack(List<Path> modpackMods) {
        Path modpackDir = null;
        Iterator<Path> iterator = modpackMods.iterator();
        if (iterator.hasNext()) {
            Path path = iterator.next();
            modpackDir = path.toAbsolutePath().normalize().getParent();
        }
        if (modpackDir == null) {
            return;
        }
        try {
            List candidates = (List)this.discoverMods(modpackDir);
            candidates = (List)this.resolveMods(candidates);
            FabricLoaderImplAccessor.METHOD_DUMP_MOD_LIST.invoke((Object)FabricLoaderImpl.INSTANCE, candidates);
            this.addMods(candidates);
            this.setupLanguageAdapters(candidates);
        }
        catch (Exception e) {
            FabricGuiEntry.displayCriticalError((Throwable)e, (boolean)true);
        }
    }

    private Collection<ModCandidate> discoverMods(Path modpackModsDir) throws ModResolutionException, IllegalAccessException, IOException {
        ModDiscoverer discoverer = new ModDiscoverer(new VersionOverrides(), new DependencyOverrides(FabricLoaderImpl.INSTANCE.getConfigDir()));
        GlobalVariables.LOGGER.info("Discovering mods from {}", (Object)(String.valueOf(modpackModsDir.getParent().getFileName()) + "/" + String.valueOf(modpackModsDir.getFileName())));
        List<DirectoryModCandidateFinder> candidateFinders = List.of(new ModContainerModCandidateFinder(FabricLanguageAdapter.getAllMods().stream().toList()), new DirectoryModCandidateFinder(modpackModsDir, FabricLoaderImpl.INSTANCE.isDevelopmentEnvironment()));
        FabricLoaderImplAccessor.FIELD_CANDIDATE_FINDERS.set(discoverer, candidateFinders);
        return discoverer.discoverMods(FabricLoaderImpl.INSTANCE, this.envDisabledMods);
    }

    private Collection<ModCandidate> resolveMods(Collection<ModCandidate> modCandidates) throws ModResolutionException {
        HashSet<String> modIds = new HashSet<String>();
        for (ModContainer mod : FabricLanguageAdapter.getAllMods().stream().toList()) {
            ModContainerImpl container = (ModContainerImpl)mod;
            modIds.add(container.getMetadata().getId());
        }
        List candidates = ModResolver.resolve(modCandidates, (EnvType)FabricLoaderImpl.INSTANCE.getEnvironmentType(), this.envDisabledMods);
        candidates.removeIf(it -> modIds.contains(it.getId()));
        candidates.forEach(this::applyPaths);
        return candidates;
    }

    private void addMods(Collection<ModCandidate> candidates) {
        try {
            for (ModCandidate candidate : candidates) {
                this.addMod(candidate);
            }
        }
        catch (Exception e) {
            FabricGuiEntry.displayCriticalError((Throwable)e, (boolean)true);
        }
    }

    public void addMod(ModCandidate candidate) throws IllegalAccessException {
        ModContainerImpl container = new ModContainerImpl(candidate);
        FabricLanguageAdapter.addMod(container);
        Map modMap = (Map)FabricLoaderImplAccessor.FIELD_MOD_MAP.get(FabricLoaderImpl.INSTANCE);
        modMap.put(candidate.getId(), container);
        for (String provides : candidate.getProvides()) {
            modMap.put(provides, container);
        }
        FabricLoaderImplAccessor.FIELD_MOD_MAP.set(FabricLoaderImpl.INSTANCE, modMap);
        if (!candidate.hasPath() && !candidate.isBuiltin()) {
            this.applyPaths(candidate);
        }
        for (Path it : candidate.getPaths()) {
            FabricLauncherBase.getLauncher().addToClassPath(it, new String[0]);
        }
    }

    private void applyPaths(ModCandidate candidate) {
        try {
            Path cacheDir = FabricLoaderImpl.INSTANCE.getGameDir().resolve(".fabric");
            Path processedModsDir = cacheDir.resolve("processedMods");
            if (FabricLoaderImpl.INSTANCE.isDevelopmentEnvironment() && System.getProperty("fabric.remapClasspathFile") != null) {
                RuntimeModRemapper.remap(Collections.singleton(candidate), (Path)cacheDir.resolve("tmp"), (Path)processedModsDir);
            }
            if (!candidate.hasPath() && !candidate.isBuiltin()) {
                candidate.setPaths(Collections.singletonList(candidate.copyToDir(processedModsDir, false)));
            }
        }
        catch (Exception e) {
            FabricGuiEntry.displayCriticalError((Throwable)e, (boolean)true);
        }
    }

    private void setupLanguageAdapters(Collection<ModCandidate> candidates) throws IllegalAccessException {
        Map adapterMap = (Map)FabricLoaderImplAccessor.FIELD_ADAPTER_MAP.get(FabricLoaderImpl.INSTANCE);
        for (ModCandidate candidate : candidates) {
            Map definitions = candidate.getMetadata().getLanguageAdapterDefinitions();
            if (definitions.isEmpty()) continue;
            GlobalVariables.LOGGER.info("Setting up language adapter for {}", (Object)candidate.getId());
            for (Map.Entry entry : definitions.entrySet()) {
                if (!candidate.getId().equals("automodpack") && adapterMap.containsKey(entry.getKey())) {
                    FabricGuiEntry.displayCriticalError((Throwable)new IllegalArgumentException("Duplicate language adapter ID: " + (String)entry.getKey()), (boolean)true);
                }
                try {
                    Class<?> adapterClass = Class.forName((String)entry.getValue(), true, FabricLauncherBase.getLauncher().getTargetClassLoader());
                    LanguageAdapter adapter = (LanguageAdapter)adapterClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                    adapterMap.put((String)entry.getKey(), adapter);
                }
                catch (Exception e) {
                    FabricGuiEntry.displayCriticalError((Throwable)new RuntimeException("Error setting up language adapter for " + (String)entry.getKey(), e), (boolean)true);
                }
            }
        }
    }
}

