/*
 * Decompiled with CFR 0.152.
 */
package reloc.org.tomlj;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import reloc.org.tomlj.JsonOptions;
import reloc.org.tomlj.TomlArray;
import reloc.org.tomlj.TomlTable;
import reloc.org.tomlj.TomlType;

final class JsonSerializer {
    private JsonSerializer() {
    }

    static void toJson(TomlTable table, Appendable appendable, Set<JsonOptions> options) throws IOException {
        Objects.requireNonNull(table);
        Objects.requireNonNull(appendable);
        JsonSerializer.toJson(table, appendable, options, 0);
        appendable.append(System.lineSeparator());
    }

    private static void toJson(TomlTable table, Appendable appendable, Set<JsonOptions> options, int indent) throws IOException {
        if (table.isEmpty()) {
            appendable.append("{}");
            return;
        }
        JsonSerializer.appendLine(appendable, "{");
        Iterator iterator = table.entrySet().stream().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)entry.getKey();
            JsonSerializer.append(appendable, indent + 2, "\"" + JsonSerializer.escape(key) + "\" : ");
            Object value = entry.getValue();
            assert (value != null);
            JsonSerializer.appendTomlValue(value, appendable, options, indent);
            if (!iterator.hasNext()) continue;
            appendable.append(",");
            appendable.append(System.lineSeparator());
        }
        appendable.append(System.lineSeparator());
        JsonSerializer.append(appendable, indent, "}");
    }

    static void toJson(TomlArray array, Appendable appendable, Set<JsonOptions> options) throws IOException {
        JsonSerializer.toJson(array, appendable, options, 0);
        appendable.append(System.lineSeparator());
    }

    private static void toJson(TomlArray array, Appendable appendable, Set<JsonOptions> options, int indent) throws IOException {
        if (array.isEmpty()) {
            appendable.append("[]");
            return;
        }
        appendable.append("[");
        Optional<Object> tomlType = Optional.empty();
        Iterator<Object> iterator = array.toList().iterator();
        while (iterator.hasNext()) {
            Object tomlValue = iterator.next();
            tomlType = TomlType.typeFor(tomlValue);
            assert (tomlType.isPresent());
            if (((TomlType)((Object)tomlType.get())).equals((Object)TomlType.TABLE)) {
                JsonSerializer.toJson((TomlTable)tomlValue, appendable, options, indent);
            } else {
                appendable.append(System.lineSeparator());
                JsonSerializer.indentLine(appendable, indent + 2);
                JsonSerializer.appendTomlValue(tomlValue, appendable, options, indent);
            }
            if (iterator.hasNext()) {
                appendable.append(",");
                continue;
            }
            if (((TomlType)((Object)tomlType.get())).equals((Object)TomlType.TABLE)) continue;
            appendable.append(System.lineSeparator());
        }
        if (tomlType.isPresent() && ((TomlType)((Object)tomlType.get())).equals((Object)TomlType.TABLE)) {
            appendable.append("]");
        } else {
            JsonSerializer.append(appendable, indent, "]");
        }
    }

    private static void appendTomlValue(Object value, Appendable appendable, Set<JsonOptions> options, int indent) throws IOException {
        Optional<TomlType> tomlType = TomlType.typeFor(value);
        assert (tomlType.isPresent());
        switch (tomlType.get()) {
            case ARRAY: {
                JsonSerializer.toJson((TomlArray)value, appendable, options, indent + 2);
                return;
            }
            case TABLE: {
                JsonSerializer.toJson((TomlTable)value, appendable, options, indent + 2);
                return;
            }
        }
        if (options.contains((Object)JsonOptions.VALUES_AS_OBJECTS_WITH_TYPE)) {
            appendable.append("{ \"type\": \"");
            appendable.append(JsonSerializer.typeName(tomlType.get()));
            appendable.append("\", \"value\": ");
            JsonSerializer.appendTomlValueLiteral(tomlType.get(), value, appendable, options);
            appendable.append(" }");
        } else {
            JsonSerializer.appendTomlValueLiteral(tomlType.get(), value, appendable, options);
        }
    }

    private static String typeName(TomlType tomlType) {
        switch (tomlType) {
            case BOOLEAN: {
                return "bool";
            }
            case OFFSET_DATE_TIME: {
                return "datetime";
            }
            case LOCAL_DATE_TIME: {
                return "datetime-local";
            }
            case LOCAL_DATE: {
                return "date-local";
            }
            case LOCAL_TIME: {
                return "time-local";
            }
        }
        return tomlType.typeName();
    }

    private static void appendTomlValueLiteral(TomlType tomlType, Object value, Appendable appendable, Set<JsonOptions> options) throws IOException {
        switch (tomlType) {
            case STRING: {
                appendable.append('\"');
                appendable.append(JsonSerializer.escape((String)value));
                appendable.append('\"');
                break;
            }
            case INTEGER: {
                if (options.contains((Object)JsonOptions.ALL_VALUES_AS_STRINGS)) {
                    appendable.append('\"');
                }
                appendable.append(value.toString());
                if (!options.contains((Object)JsonOptions.ALL_VALUES_AS_STRINGS)) break;
                appendable.append('\"');
                break;
            }
            case FLOAT: {
                if (options.contains((Object)JsonOptions.ALL_VALUES_AS_STRINGS)) {
                    appendable.append('\"');
                }
                if (Double.isNaN((Double)value)) {
                    appendable.append("nan");
                } else if ((Double)value == Double.POSITIVE_INFINITY) {
                    appendable.append("+inf");
                } else if ((Double)value == Double.NEGATIVE_INFINITY) {
                    appendable.append("-inf");
                } else {
                    appendable.append(value.toString());
                }
                if (!options.contains((Object)JsonOptions.ALL_VALUES_AS_STRINGS)) break;
                appendable.append('\"');
                break;
            }
            case BOOLEAN: {
                if (options.contains((Object)JsonOptions.ALL_VALUES_AS_STRINGS)) {
                    appendable.append('\"');
                }
                appendable.append((Boolean)value != false ? "true" : "false");
                if (!options.contains((Object)JsonOptions.ALL_VALUES_AS_STRINGS)) break;
                appendable.append('\"');
                break;
            }
            case OFFSET_DATE_TIME: {
                appendable.append('\"');
                appendable.append(((OffsetDateTime)value).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
                appendable.append('\"');
                break;
            }
            case LOCAL_DATE_TIME: {
                appendable.append('\"');
                appendable.append(((LocalDateTime)value).format(DateTimeFormatter.ISO_DATE_TIME));
                appendable.append('\"');
                break;
            }
            case LOCAL_DATE: {
                appendable.append('\"');
                appendable.append(((LocalDate)value).format(DateTimeFormatter.ISO_DATE));
                appendable.append('\"');
                break;
            }
            case LOCAL_TIME: {
                appendable.append('\"');
                appendable.append(((LocalTime)value).format(DateTimeFormatter.ISO_TIME));
                appendable.append('\"');
                break;
            }
            default: {
                throw new AssertionError((Object)("Attempted to output literal form of non-literal type " + tomlType.typeName()));
            }
        }
    }

    private static void append(Appendable appendable, int indent, String line) throws IOException {
        JsonSerializer.indentLine(appendable, indent);
        appendable.append(line);
    }

    private static void appendLine(Appendable appendable, String line) throws IOException {
        appendable.append(line);
        appendable.append(System.lineSeparator());
    }

    private static void indentLine(Appendable appendable, int indent) throws IOException {
        for (int i = 0; i < indent; ++i) {
            appendable.append(' ');
        }
    }

    private static StringBuilder escape(String text) {
        StringBuilder out = new StringBuilder(text.length());
        block7: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\"') {
                out.append("\\\"");
                continue;
            }
            if (ch == '\\') {
                out.append("\\\\");
                continue;
            }
            if (ch >= ' ') {
                out.append(ch);
                continue;
            }
            switch (ch) {
                case '\t': {
                    out.append("\\t");
                    continue block7;
                }
                case '\b': {
                    out.append("\\b");
                    continue block7;
                }
                case '\n': {
                    out.append("\\n");
                    continue block7;
                }
                case '\r': {
                    out.append("\\r");
                    continue block7;
                }
                case '\f': {
                    out.append("\\f");
                    continue block7;
                }
                default: {
                    out.append("\\u").append(String.format("%04x", text.codePointAt(i)));
                }
            }
        }
        return out;
    }
}

