/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.tinkerers_smithing.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import folk.sisby.tinkerers_smithing.TinkerersSmithing;
import folk.sisby.tinkerers_smithing.TinkerersSmithingMaterial;
import folk.sisby.tinkerers_smithing.data.MultiJsonDataLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3545;
import net.minecraft.class_3695;
import net.minecraft.class_7923;

public abstract class SmithingMaterialLoader
extends MultiJsonDataLoader {
    public static final String KEY_INHERIT_FROM_ITEM = "inheritFromItem";
    public static final String KEY_REPAIR_MATERIALS = "repairMaterials";
    public static final String KEY_ADD_ITEM = "addItem";
    public static final String KEY_REMOVE_ITEM = "removeItem";
    public static final String KEY_UPGRADES_FROM = "upgradesFrom";
    public static final String KEY_UPGRADES_TO = "upgradesTo";
    public static final String KEY_SACRIFICE_VIA = "sacrificesVia";
    public final TinkerersSmithingMaterial.EQUIPMENT_TYPE type;

    public SmithingMaterialLoader(Gson gson, String dataType, TinkerersSmithingMaterial.EQUIPMENT_TYPE type) {
        super(gson, dataType);
        this.type = type;
    }

    public static class_1792 getOrWarnItem(class_2960 id, class_2960 resourceId) {
        class_1792 item = class_7923.field_41178.method_17966(id).orElse(null);
        if (item == null) {
            TinkerersSmithing.LOGGER.warn("[Tinkerer's Smithing] Couldn't load item {} from {} as it wasn't registered!", (Object)id, (Object)resourceId);
        }
        return item;
    }

    public static void addOrWarnItem(Collection<class_1792> collection, class_2960 id, class_2960 resourceId) {
        class_1792 item = SmithingMaterialLoader.getOrWarnItem(id, resourceId);
        if (item != null) {
            collection.add(item);
        }
    }

    public static void removeOrWarnItem(Collection<class_1792> collection, class_2960 id, class_2960 resourceId) {
        class_1792 item = SmithingMaterialLoader.getOrWarnItem(id, resourceId);
        if (item != null) {
            collection.remove(item);
        }
    }

    protected void apply(Map<class_2960, Collection<class_3545<JsonElement, String>>> prepared, class_3300 manager, class_3695 profiler) {
        TinkerersSmithing.LOGGER.info("[Tinkerer's Smithing] Loading Materials!");
        Map<class_2960, TinkerersSmithingMaterial> outputMap = this.getOutputMap();
        outputMap.clear();
        HashMap<class_2960, List> upgradeFromMap = new HashMap<class_2960, List>();
        prepared.forEach((id, jsons) -> {
            HashSet<class_2960> upgradesTo = new HashSet<class_2960>();
            ArrayList<class_1856> repairMaterials = new ArrayList<class_1856>();
            HashSet<class_1792> items = new HashSet<class_1792>();
            class_2960 sacrificesVia = null;
            for (class_3545 entry : jsons) {
                JsonObject baseObject = ((JsonElement)entry.method_15442()).getAsJsonObject();
                if (baseObject.has(KEY_INHERIT_FROM_ITEM)) {
                    baseObject.get(KEY_INHERIT_FROM_ITEM).getAsJsonArray().forEach(inheritElement -> {
                        class_1792 inheritItem;
                        class_2960 inheritItemId = class_2960.method_12829((String)inheritElement.getAsString());
                        if (inheritItemId != null && (inheritItem = SmithingMaterialLoader.getOrWarnItem(inheritItemId, id)) != null) {
                            class_1856 repairIngredient = this.getDefaultRepairIngredient(inheritItem);
                            if (repairIngredient != null) {
                                repairMaterials.add(repairIngredient);
                            }
                            class_7923.field_41178.forEach(matchingItem -> {
                                if (this.matchingMaterials(inheritItem, (class_1792)matchingItem)) {
                                    items.add((class_1792)matchingItem);
                                }
                            });
                        }
                    });
                }
                if (baseObject.has(KEY_REPAIR_MATERIALS)) {
                    baseObject.get(KEY_REPAIR_MATERIALS).getAsJsonArray().forEach(jsonIngredient -> repairMaterials.add(class_1856.method_52177((JsonElement)jsonIngredient)));
                }
                if (baseObject.has(KEY_ADD_ITEM)) {
                    baseObject.get(KEY_ADD_ITEM).getAsJsonArray().forEach(jsonItemId -> SmithingMaterialLoader.addOrWarnItem(items, new class_2960(jsonItemId.getAsString()), id));
                }
                if (baseObject.has(KEY_REMOVE_ITEM)) {
                    baseObject.get(KEY_REMOVE_ITEM).getAsJsonArray().forEach(jsonItemId -> SmithingMaterialLoader.removeOrWarnItem(items, new class_2960(jsonItemId.getAsString()), id));
                }
                if (baseObject.has(KEY_UPGRADES_FROM)) {
                    baseObject.get(KEY_UPGRADES_FROM).getAsJsonArray().forEach(jsonMaterialId -> upgradeFromMap.computeIfAbsent(new class_2960(jsonMaterialId.getAsString()), k -> new ArrayList()).add(id));
                }
                if (baseObject.has(KEY_UPGRADES_TO)) {
                    baseObject.get(KEY_UPGRADES_TO).getAsJsonArray().forEach(jsonMaterialId -> upgradesTo.add(new class_2960(jsonMaterialId.getAsString())));
                }
                if (!baseObject.has(KEY_SACRIFICE_VIA)) continue;
                sacrificesVia = new class_2960(baseObject.get(KEY_SACRIFICE_VIA).getAsString());
            }
            outputMap.put((class_2960)id, new TinkerersSmithingMaterial(this.type, upgradesTo, repairMaterials, items, sacrificesVia));
        });
        upgradeFromMap.forEach((identifier, identifiers) -> {
            if (outputMap.containsKey(identifier)) {
                ((TinkerersSmithingMaterial)outputMap.get((Object)identifier)).upgradesTo.addAll((Collection<class_2960>)identifiers);
            }
        });
        outputMap.forEach((id, material) -> {
            material.upgradesTo.stream().filter(i -> !outputMap.containsKey(i)).toList().forEach(removeId -> {
                TinkerersSmithing.LOGGER.warn("[Tinkerer's Smithing] Invalid upgrade {} in {}", removeId, id);
                material.upgradesTo.remove(removeId);
            });
            if (material.sacrificesVia != null && !outputMap.containsKey(material.sacrificesVia)) {
                TinkerersSmithing.LOGGER.warn("[Tinkerer's Smithing] Invalid via {} in {}", (Object)material.sacrificesVia, id);
                material.sacrificesVia = null;
            }
        });
        TinkerersSmithing.LOGGER.info("[Tinkerer's Smithing] Reloaded a set of {} materials", (Object)outputMap.size());
    }

    public abstract class_1856 getDefaultRepairIngredient(class_1792 var1);

    public abstract boolean matchingMaterials(class_1792 var1, class_1792 var2);

    public abstract Map<class_2960, TinkerersSmithingMaterial> getOutputMap();
}

