/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.tinkerers_smithing.data;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import folk.sisby.tinkerers_smithing.TinkerersSmithing;
import folk.sisby.tinkerers_smithing.TinkerersSmithingLoader;
import folk.sisby.tinkerers_smithing.data.MultiJsonDataLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3503;
import net.minecraft.class_3545;
import net.minecraft.class_3695;
import net.minecraft.class_7475;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class SmithingTypeLoader
extends MultiJsonDataLoader {
    public static final SmithingTypeLoader INSTANCE = new SmithingTypeLoader(new Gson());
    public static final class_2960 ID = new class_2960("tinkerers_smithing", "smithing_type_loader");
    public static final class_3503<class_1792> ITEM_TAG_LOADER = new class_3503(arg_0 -> ((class_7922)class_7923.field_41178).method_17966(arg_0), "tags/items");
    public static final String AVOIDANCE_PREFIX = "tinkerers_smithing_types/";

    public SmithingTypeLoader(Gson gson) {
        super(gson, "smithing_types");
    }

    public static void addToTag(Map<class_2960, Collection<class_1792>> tags, String path, class_1792 item) {
        class_2960 id = new class_2960(path);
        HashSet<class_1792> mutable = new HashSet<class_1792>(tags.computeIfAbsent(id, k -> new HashSet()));
        mutable.add(item);
        tags.put(id, (Collection<class_1792>)ImmutableList.copyOf(mutable));
    }

    public String method_22322() {
        return ID.toString();
    }

    protected void apply(Map<class_2960, Collection<class_3545<JsonElement, String>>> prepared, class_3300 manager, class_3695 profiler) {
        TinkerersSmithing.LOGGER.info("[Tinkerer's Smithing] Loading Types!");
        TinkerersSmithingLoader.INSTANCE.SMITHING_TYPES.clear();
        HashMap typeTags = new HashMap();
        prepared.forEach((id, jsons) -> {
            class_2960 collisionAvoidingID = new class_2960(id.method_12836(), AVOIDANCE_PREFIX + id.method_12832());
            jsons.forEach(jsonEntry -> {
                List list = typeTags.computeIfAbsent(collisionAvoidingID, k -> new ArrayList());
                class_7475 tagFile = (class_7475)class_7475.field_39269.parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)jsonEntry.method_15442()))).getOrThrow(false, arg_0 -> ((Logger)TinkerersSmithing.LOGGER).error(arg_0));
                if (tagFile.comp_812()) {
                    list.clear();
                }
                tagFile.comp_811().forEach(entry -> list.add(new class_3503.class_5145(entry, (String)jsonEntry.method_15441())));
            });
        });
        Map itemTags = ITEM_TAG_LOADER.method_33174(manager);
        HashMap allTags = new HashMap();
        allTags.putAll(itemTags);
        allTags.putAll(typeTags);
        Map<class_2960, Collection<class_1792>> tags = ITEM_TAG_LOADER.method_18242(allTags);
        tags.entrySet().removeIf(e -> !typeTags.containsKey(e.getKey()));
        tags = tags.entrySet().stream().collect(Collectors.toMap(e -> new class_2960(((class_2960)e.getKey()).method_12836(), StringUtils.removeStart((String)((class_2960)e.getKey()).method_12832(), (String)AVOIDANCE_PREFIX)), Map.Entry::getValue));
        for (class_1792 item : class_7923.field_41178) {
            if (!(item instanceof class_1738)) continue;
            class_1738 ai = (class_1738)item;
            switch (ai.method_48398()) {
                case field_41937: {
                    SmithingTypeLoader.addToTag(tags, "boots", item);
                    break;
                }
                case field_41936: {
                    SmithingTypeLoader.addToTag(tags, "leggings", item);
                    break;
                }
                case field_41935: {
                    SmithingTypeLoader.addToTag(tags, "chestplate", item);
                    break;
                }
                case field_41934: {
                    SmithingTypeLoader.addToTag(tags, "helmet", item);
                }
            }
        }
        TinkerersSmithingLoader.INSTANCE.SMITHING_TYPES.putAll(tags);
        TinkerersSmithing.LOGGER.info("[Tinkerer's Smithing] Reloaded smithing types");
    }
}

