/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.tinkerers_smithing.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import folk.sisby.tinkerers_smithing.TinkerersSmithing;
import folk.sisby.tinkerers_smithing.TinkerersSmithingLoader;
import folk.sisby.tinkerers_smithing.recipe.ServerRecipe;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class ShapelessRepairRecipe
extends class_1867
implements ServerRecipe<class_1867> {
    public final class_1792 baseItem;
    public final class_1856 addition;
    public final int additionCount;

    public ShapelessRepairRecipe(class_1792 baseItem, class_1856 addition, int additionCount) {
        super(TinkerersSmithingLoader.repairRecipeId(baseItem, addition), "", class_7710.field_40250, ShapelessRepairRecipe.getPreviewResult(baseItem), ShapelessRepairRecipe.assembleIngredients(baseItem, addition, additionCount));
        this.baseItem = baseItem;
        this.addition = addition;
        this.additionCount = additionCount;
    }

    private static class_1799 getPreviewResult(class_1792 baseItem) {
        class_1799 stack = baseItem.method_7854().method_7972();
        stack.method_7974(1);
        return stack;
    }

    private static class_2371<class_1856> assembleIngredients(class_1792 item, class_1856 addition, int additionCount) {
        class_2371 ingredients = class_2371.method_10211();
        class_1856 additionWithAir = class_1856.method_8092(Arrays.stream((class_1856.class_1859[])ArrayUtils.addAll((Object[])addition.field_9019, (Object[])class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8162}).field_9019)));
        ingredients.add((Object)class_1856.method_8091((class_1935[])new class_1935[]{item}));
        for (int i = 0; i < additionCount; ++i) {
            ingredients.add((Object)(i > 0 ? additionWithAir : addition));
        }
        return ingredients;
    }

    private class_1799 findBase(class_8566 inventory) {
        List<class_1799> bases = inventory.method_51305().stream().filter(s -> s.method_31574(this.baseItem)).toList();
        return bases.size() == 1 && !bases.get(0).method_7942() && bases.get(0).method_7986() ? bases.get(0) : null;
    }

    public boolean method_17730(class_8566 inventory, class_1937 world) {
        class_1799 base = this.findBase(inventory);
        long units = inventory.method_51305().stream().filter(this.addition).count();
        long empty = inventory.method_51305().stream().filter(class_1799::method_7960).count();
        if (base == null || units <= 0L || units > (long)this.additionCount || empty != (long)inventory.method_5439() - units - 1L) {
            return false;
        }
        return base.method_7919() - (int)Math.ceil((double)((long)base.method_7936() * (units - 1L)) / (double)this.additionCount) > 0;
    }

    public class_1799 method_17729(class_8566 inventory, class_5455 registryManager) {
        class_1799 base = this.findBase(inventory);
        long units = inventory.method_51305().stream().filter(this.addition).count();
        if (base == null || units <= 0L || units > (long)this.additionCount) {
            return class_1799.field_8037;
        }
        class_1799 output = super.method_17729(inventory, registryManager);
        output.method_7980(base.method_7948().method_10553());
        output.method_7974(Math.max(0, base.method_7919() - (int)Math.ceil((double)((long)base.method_7936() * units) / (double)this.additionCount)));
        return output;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    public boolean method_8118() {
        return true;
    }

    public class_1865<?> method_8119() {
        return TinkerersSmithing.SHAPELESS_REPAIR_SERIALIZER;
    }

    @Override
    @Nullable
    public class_1865<class_1867> getFallbackSerializer() {
        return class_1865.field_9031;
    }

    public static class Serializer
    implements class_1865<ShapelessRepairRecipe> {
        public ShapelessRepairRecipe read(class_2960 id, JsonObject json) {
            class_1792 baseItem = class_3518.method_15288((JsonObject)json, (String)"base");
            class_1856 addition = class_1856.method_52177((JsonElement)class_3518.method_15296((JsonObject)json, (String)"addition"));
            int additionCount = class_3518.method_15260((JsonObject)json, (String)"additionCount");
            return new ShapelessRepairRecipe(baseItem, addition, additionCount);
        }

        public ShapelessRepairRecipe read(class_2960 id, class_2540 buf) {
            class_1792 baseItem = class_1792.method_7875((int)buf.method_10816());
            class_1856 addition = class_1856.method_8086((class_2540)buf);
            int additionCount = buf.method_10816();
            return new ShapelessRepairRecipe(baseItem, addition, additionCount);
        }

        public void write(class_2540 buf, ShapelessRepairRecipe recipe) {
            buf.method_10804(class_1792.method_7880((class_1792)recipe.baseItem));
            if (recipe.addition.method_8105().length == 0) {
                TinkerersSmithing.LOGGER.error("No matching stacks while serializing repair recipe {}!", (Object)recipe.method_8114());
            }
            recipe.addition.method_8088(buf);
            buf.method_10804(recipe.additionCount);
        }
    }
}

