/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.tinkerers_smithing.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import folk.sisby.tinkerers_smithing.TinkerersSmithing;
import folk.sisby.tinkerers_smithing.TinkerersSmithingLoader;
import folk.sisby.tinkerers_smithing.recipe.ServerRecipe;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5455;
import net.minecraft.class_8060;
import org.jetbrains.annotations.Nullable;

public class SmithingUpgradeRecipe
extends class_8060
implements ServerRecipe<class_8060> {
    public final class_1792 baseItem;
    public final int additionCount;
    public final class_1792 resultItem;

    public SmithingUpgradeRecipe(class_1792 baseItem, class_1856 addition, int additionCount, class_1792 resultItem) {
        super(TinkerersSmithingLoader.recipeId("smithing", resultItem, baseItem), class_1856.method_35226(), class_1856.method_8091((class_1935[])new class_1935[]{baseItem}), addition, SmithingUpgradeRecipe.getPreviewResult(resultItem, additionCount));
        this.baseItem = baseItem;
        this.additionCount = additionCount;
        this.resultItem = resultItem;
    }

    private static class_1799 getPreviewResult(class_1792 resultItem, int additionCount) {
        class_1799 stack = resultItem.method_7854().method_7972();
        stack.method_7974(SmithingUpgradeRecipe.resultDamage(resultItem, additionCount, 1));
        return stack;
    }

    public static int resultDamage(class_1792 resultItem, int additionCount, int usedCount) {
        if (resultItem.method_7854().method_7936() == 0) {
            return additionCount == usedCount ? 0 : 1;
        }
        return Math.min(resultItem.method_7841() - 1, (int)Math.floor((double)resultItem.method_7841() * ((double)(additionCount - usedCount) / 4.0)));
    }

    public class_1799 method_8116(class_1263 inventory, class_5455 registryManager) {
        class_1799 output = super.method_8116(inventory, registryManager);
        int usedCount = Math.min(this.additionCount, inventory.method_5438(2).method_7947());
        int damage = SmithingUpgradeRecipe.resultDamage(output.method_7909(), this.additionCount, usedCount);
        if (damage > output.method_7936()) {
            return class_1799.field_8037;
        }
        output.method_7974(damage);
        return output;
    }

    public class_1865<?> method_8119() {
        return TinkerersSmithing.SMITHING_UPGRADE_SERIALIZER;
    }

    @Override
    @Nullable
    public class_1865<class_8060> getFallbackSerializer() {
        return class_1865.field_42027;
    }

    public static class Serializer
    implements class_1865<SmithingUpgradeRecipe> {
        public SmithingUpgradeRecipe read(class_2960 id, JsonObject json) {
            class_1792 baseItem = class_3518.method_15288((JsonObject)json, (String)"base");
            class_1856 addition = class_1856.method_52177((JsonElement)class_3518.method_15296((JsonObject)json, (String)"addition"));
            int additionCount = class_3518.method_15260((JsonObject)json, (String)"additionCount");
            class_1792 resultItem = class_3518.method_15288((JsonObject)json, (String)"result");
            return new SmithingUpgradeRecipe(baseItem, addition, additionCount, resultItem);
        }

        public SmithingUpgradeRecipe read(class_2960 id, class_2540 buf) {
            class_1792 baseItem = class_1792.method_7875((int)buf.method_10816());
            class_1856 addition = class_1856.method_8086((class_2540)buf);
            int additionCount = buf.method_10816();
            class_1792 resultItem = class_1792.method_7875((int)buf.method_10816());
            return new SmithingUpgradeRecipe(baseItem, addition, additionCount, resultItem);
        }

        public void write(class_2540 buf, SmithingUpgradeRecipe recipe) {
            buf.method_10804(class_1792.method_7880((class_1792)recipe.baseItem));
            recipe.field_42032.method_8088(buf);
            buf.method_10804(recipe.additionCount);
            buf.method_10804(class_1792.method_7880((class_1792)recipe.resultItem));
        }
    }
}

