/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdynlights.mixin.retrofit;

import dev.lambdaurora.lambdynlights.LambDynLights;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandler;
import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import dev.lambdaurora.lambdynlights.api.entity.luminance.EntityLuminance;
import dev.lambdaurora.lambdynlights.api.entity.luminance.WaterSensitiveEntityLuminance;
import dev.lambdaurora.lambdynlights.api.item.ItemLightSourceManager;
import dev.lambdaurora.lambdynlights.engine.DynamicLightingEngine;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DynamicLightHandlers.class}, remap=false)
public final class DynamicLightHandlersMixin {
    @Unique
    private static final EntityLuminance.Type DUMMY_RETROFIT_TYPE = new EntityLuminance.Type(LambDynLights.id("dummy/old_dynamic_light_handlers"), null);

    @Accessor(remap=false, value="HANDLERS")
    private static Map<class_1299<?>, DynamicLightHandler<?>> getHANDLERS() {
        throw new IllegalStateException("Injection failed.");
    }

    @Inject(method={"registerDefaultHandlers()V"}, at={@At(value="TAIL")}, remap=false)
    private static void onRegisterDefaultHandlers(CallbackInfo ci) {
        LambDynLights.get().entityLightSourceManager().onRegisterEvent().register(context -> DynamicLightHandlersMixin.getHANDLERS().forEach((type, handler) -> {
            DynamicLightHandler actualHandler = handler;
            context.register(type, new EntityLuminance[]{new WaterSensitiveEntityLuminance(List.of(DynamicLightHandlersMixin.lambdynlights$retrofitHandler((DynamicLightHandler<class_1297>)actualHandler, false)), List.of(DynamicLightHandlersMixin.lambdynlights$retrofitHandler((DynamicLightHandler<class_1297>)actualHandler, true)))});
        }));
    }

    @Overwrite(remap=false)
    public static <T extends class_1297> boolean canLightUp(T entity) {
        return DynamicLightingEngine.canLightUp(entity);
    }

    @Overwrite(remap=false)
    public static <T extends class_1297> int getLuminanceFrom(T entity) {
        return LambDynLights.getLuminanceFrom(entity);
    }

    @Unique
    private static EntityLuminance lambdynlights$retrofitHandler(final DynamicLightHandler<class_1297> handler, final boolean inWater) {
        return new EntityLuminance(){

            @NotNull
            public EntityLuminance.Type type() {
                return DUMMY_RETROFIT_TYPE;
            }

            public @Range(from=0L, to=15L) int getLuminance(@NotNull ItemLightSourceManager itemLightSourceManager, @NotNull class_1297 entity) {
                if (handler.isWaterSensitive((Object)entity) && inWater) {
                    return 0;
                }
                return handler.getLuminance((Object)entity);
            }
        };
    }
}

