/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.custom_tracks.narrow_gauge.fabric;

import com.google.common.collect.ImmutableSet;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.custom_tracks.narrow_gauge.NarrowGaugeTrackBlockStateGenerator;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackShape;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import io.github.fabricators_of_create.porting_lib.models.generators.ModelFile;
import io.github.fabricators_of_create.porting_lib.models.generators.block.BlockModelBuilder;
import java.util.HashMap;
import java.util.Set;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;

public class NarrowGaugeTrackBlockStateGeneratorImpl
extends NarrowGaugeTrackBlockStateGenerator {
    private static final Set<String> COMPAT_MODS = ImmutableSet.of((Object)"create");

    public <T extends class_2248> ModelFile getModel(DataGenContext<class_2248, T> ctx, RegistrateBlockstateProvider prov, class_2680 state) {
        TrackShape value = (TrackShape)state.method_11654((class_2769)TrackBlock.SHAPE);
        TrackMaterial material = ((TrackBlock)ctx.getEntry()).getMaterial();
        if (value == TrackShape.NONE) {
            return prov.models().getExistingFile(prov.mcLoc("block/air"));
        }
        String textureModId = "railways";
        String resName = material.resourceName().replaceFirst("_narrow", "");
        for (String modPrefix : COMPAT_MODS) {
            if (!resName.startsWith(modPrefix + "_")) continue;
            textureModId = modPrefix;
            resName = resName.replaceFirst(modPrefix + "_", "");
            break;
        }
        String prefix = "block/track/" + material.resourceName() + "/";
        String texturePrefix = "block/track/" + resName + "/";
        HashMap<String, String> textureMap = new HashMap<String, String>();
        switch (value) {
            case TE: 
            case TN: 
            case TS: 
            case TW: {
                textureMap.put("1", "portal_track_");
                textureMap.put("2", "portal_track_mip_");
                textureMap.put("3", "standard_track_");
                break;
            }
            case AE: 
            case AW: 
            case AN: 
            case AS: {
                textureMap.put("0", "standard_track_");
                textureMap.put("1", "standard_track_mip_");
                break;
            }
            case CR_O: 
            case XO: 
            case ZO: 
            case ND: 
            case PD: 
            case CR_D: 
            case CR_NDX: 
            case CR_NDZ: 
            case CR_PDX: 
            case CR_PDZ: {
                textureMap.put("1", "standard_track_");
                textureMap.put("2", "standard_track_mip_");
                textureMap.put("3", "standard_track_crossing_");
                break;
            }
            default: {
                textureMap.put("0", "standard_track_");
                textureMap.put("1", "standard_track_mip_");
                textureMap.put("2", "standard_track_crossing_");
            }
        }
        if (material == CRTrackMaterials.NARROW_GAUGE_ANDESITE) {
            BlockModelBuilder builder = (BlockModelBuilder)prov.models().withExistingParent(prefix + value.getModel(), Railways.asResource("block/narrow_gauge_base/" + value.getModel()));
            for (String k : new String[]{"segment_left", "segment_right", "tie"}) {
                ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(prefix + k, Railways.asResource("block/narrow_gauge_base/" + k))).texture("0", Create.asResource((String)"block/standard_track"))).texture("1", Create.asResource((String)"block/standard_track_mip"))).texture("particle", material.particle);
            }
            return builder;
        }
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(prefix + value.getModel(), Railways.asResource("block/narrow_gauge_base/" + value.getModel()))).texture("particle", material.particle);
        for (String k : textureMap.keySet()) {
            builder = (BlockModelBuilder)builder.texture(k, new class_2960(textureModId, texturePrefix + (String)textureMap.get(k) + resName));
        }
        for (String k : new String[]{"segment_left", "segment_right", "tie"}) {
            ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(prefix + k, Railways.asResource("block/narrow_gauge_base/" + k))).texture("0", new class_2960(textureModId, texturePrefix + "standard_track_" + resName))).texture("1", new class_2960(textureModId, texturePrefix + "standard_track_mip_" + resName))).texture("particle", material.particle);
        }
        return builder;
    }

    public static NarrowGaugeTrackBlockStateGenerator create() {
        return new NarrowGaugeTrackBlockStateGeneratorImpl();
    }
}

