/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.net;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.Unpooled;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.config.LimitedModConfigServer;
import nl.enjarai.doabarrelroll.config.ModConfigServer;
import nl.enjarai.doabarrelroll.net.ServerConfigHolder;
import nl.enjarai.doabarrelroll.util.DelayedRunnable;
import org.slf4j.Logger;

public class HandshakeServer {
    public static final int PROTOCOL_VERSION = 3;
    private final ServerConfigHolder<ModConfigServer> configHolder;
    private final Map<class_3244, ClientInfo> syncStates = new WeakHashMap<class_3244, ClientInfo>();
    private final Map<class_3244, DelayedRunnable> scheduledKicks = new WeakHashMap<class_3244, DelayedRunnable>();
    private final Function<class_3244, Boolean> getsLimitedCheck;
    private final Codec<ModConfigServer> transferCodec = ModConfigServer.CODEC;
    private final Codec<LimitedModConfigServer> limitedTransferCodec = LimitedModConfigServer.getCodec();

    public HandshakeServer(ServerConfigHolder<ModConfigServer> configHolder, Function<class_3244, Boolean> getsLimitedCheck) {
        this.configHolder = configHolder;
        this.getsLimitedCheck = getsLimitedCheck;
    }

    public void tick(MinecraftServer server) {
        Iterator<Map.Entry<class_3244, DelayedRunnable>> it = this.scheduledKicks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<class_3244, DelayedRunnable> entry = it.next();
            if (entry.getValue().isDone()) {
                it.remove();
                continue;
            }
            entry.getValue().tick();
        }
    }

    public ClientInfo getHandshakeState(class_3222 player) {
        return this.getHandshakeState(player.field_13987);
    }

    public ClientInfo getHandshakeState(class_3244 handler) {
        return this.syncStates.computeIfAbsent(handler, key -> new ClientInfo(HandshakeState.NOT_SENT, 3, true));
    }

    public class_2540 getConfigSyncBuf(class_3244 handler) {
        return this.getConfigSyncBuf(handler, this.getHandshakeState((class_3244)handler).protocolVersion);
    }

    public class_2540 getConfigSyncBuf(class_3244 handler, int protocolVersion) {
        DataResult data;
        protocolVersion = Math.min(protocolVersion, 3);
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.writeInt(protocolVersion);
        Boolean isLimited = this.getsLimitedCheck.apply(handler);
        this.getHandshakeState((class_3244)handler).isLimited = isLimited;
        ModConfigServer config = (ModConfigServer)this.configHolder.instance;
        if (protocolVersion == 2) {
            Codec<LimitedModConfigServer> codec = isLimited != false ? this.limitedTransferCodec : this.transferCodec;
            data = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config);
        } else {
            data = this.limitedTransferCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config.getLimited(handler));
        }
        try {
            buf.method_10814(((JsonElement)data.getOrThrow(false, arg_0 -> ((Logger)DoABarrelRoll.LOGGER).error(arg_0))).toString());
        }
        catch (RuntimeException e) {
            DoABarrelRoll.LOGGER.error("Failed to encode config", (Throwable)e);
            buf.method_10814("{}");
        }
        if (protocolVersion >= 2) {
            buf.writeBoolean(isLimited.booleanValue());
        }
        if (protocolVersion >= 3 && !isLimited.booleanValue()) {
            DataResult data2 = this.transferCodec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)config);
            try {
                buf.method_10814(((JsonElement)data2.getOrThrow(false, arg_0 -> ((Logger)DoABarrelRoll.LOGGER).error(arg_0))).toString());
            }
            catch (RuntimeException e) {
                DoABarrelRoll.LOGGER.error("Failed to encode config", (Throwable)e);
                buf.method_10814("{}");
            }
        }
        return buf;
    }

    public void configSentToClient(class_3244 handler) {
        this.getHandshakeState((class_3244)handler).state = HandshakeState.SENT;
        ModConfigServer config = (ModConfigServer)this.configHolder.instance;
        if (config.getSyncTimeout() != null) {
            this.scheduledKicks.put(handler, new DelayedRunnable(config.getSyncTimeout(), () -> {
                if (this.getHandshakeState((class_3244)handler).state != HandshakeState.ACCEPTED) {
                    DoABarrelRoll.LOGGER.warn("{} did not accept config syncing, config indicates we kick them.", (Object)handler.method_32311().method_5477().getString());
                    handler.method_14367(config.getSyncTimeoutMessage());
                }
            }));
        }
    }

    public HandshakeState clientReplied(class_3244 handler, class_2540 buf) {
        ClientInfo info = this.getHandshakeState(handler);
        class_3222 player = handler.method_32311();
        if (info.state == HandshakeState.SENT) {
            try {
                int protocolVersion = buf.readInt();
                if (protocolVersion < 1 || protocolVersion > 3) {
                    DoABarrelRoll.LOGGER.warn("Client of {} sent unknown protocol version, expected range 1-{}, got {}. Will attempt to proceed anyway.", new Object[]{player.method_5477().getString(), 3, protocolVersion});
                }
                if (protocolVersion == 2 && info.protocolVersion != 2) {
                    DoABarrelRoll.LOGGER.info("Client of {} is using an older protocol version, resending.", (Object)player.method_5477().getString());
                    info.state = HandshakeState.RESEND;
                } else if (buf.readBoolean()) {
                    DoABarrelRoll.LOGGER.info("Client of {} accepted server config.", (Object)player.method_5477().getString());
                    info.state = HandshakeState.ACCEPTED;
                } else {
                    DoABarrelRoll.LOGGER.warn("Client of {} failed to process server config, check client logs find what went wrong.", (Object)player.method_5477().getString());
                    info.state = HandshakeState.FAILED;
                }
                info.protocolVersion = protocolVersion;
            }
            catch (Exception e) {
                DoABarrelRoll.LOGGER.warn("Client of {} sent invalid config reply.", (Object)player.method_5477().getString());
                DoABarrelRoll.LOGGER.warn("Error parsing config reply:", (Throwable)e);
                info.state = HandshakeState.FAILED;
            }
        }
        return info.state;
    }

    public void playerDisconnected(class_3244 handler) {
        this.syncStates.remove(handler);
    }

    public static class ClientInfo {
        public HandshakeState state;
        public int protocolVersion;
        public boolean isLimited;

        public ClientInfo(HandshakeState state, int protocolVersion, boolean isLimited) {
            this.state = state;
            this.protocolVersion = protocolVersion;
            this.isLimited = isLimited;
        }
    }

    public static enum HandshakeState {
        NOT_SENT,
        SENT,
        ACCEPTED,
        FAILED,
        RESEND;

    }
}

