/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.net;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiConsumer;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.config.ModConfigServer;
import nl.enjarai.doabarrelroll.net.HandshakeServer;
import nl.enjarai.doabarrelroll.net.ValidatableConfig;
import org.slf4j.Logger;

public class ServerConfigHolder<T extends ValidatableConfig> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public final Path configFile;
    public final Codec<T> codec;
    public final T defaultConfig;
    private BiConsumer<MinecraftServer, T> updateCallback;
    public T instance;

    public ServerConfigHolder(Path configFile, Codec<T> codec, T defaultConfig, BiConsumer<MinecraftServer, T> updateCallback) {
        this.configFile = configFile;
        this.codec = codec;
        this.defaultConfig = defaultConfig;
        this.updateCallback = updateCallback;
        this.load();
    }

    public void load() {
        ValidatableConfig config = null;
        if (Files.exists(this.configFile, new LinkOption[0])) {
            try (BufferedReader fileReader = new BufferedReader(new InputStreamReader(Files.newInputStream(this.configFile, new OpenOption[0]), StandardCharsets.UTF_8));){
                config = (ValidatableConfig)((Pair)this.codec.decode((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)fileReader)).getOrThrow(false, e -> {
                    throw new RuntimeException((String)e);
                })).getFirst();
            }
            catch (IOException | RuntimeException e2) {
                DoABarrelRoll.LOGGER.error("Failed to parse server config file, regenerating: ", (Throwable)e2);
            }
        }
        if (config == null || !config.isValid()) {
            config = this.defaultConfig;
        }
        this.instance = config;
        this.save();
    }

    public void save() {
        try {
            Files.createDirectories(this.configFile.getParent(), new FileAttribute[0]);
            Files.writeString(this.configFile, (CharSequence)GSON.toJson((JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, this.instance).getOrThrow(false, e -> {
                throw new RuntimeException((String)e);
            })), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException | RuntimeException e2) {
            DoABarrelRoll.LOGGER.error("Failed to save server config file: ", (Throwable)e2);
        }
    }

    public class_2540 clientSendsUpdate(class_3222 player, class_2540 buf) {
        HandshakeServer.ClientInfo info = DoABarrelRoll.HANDSHAKE_SERVER.getHandshakeState(player);
        boolean accepted = info.state == HandshakeServer.HandshakeState.ACCEPTED;
        boolean hasPermission = ModConfigServer.canModify(player.field_13987);
        if (!accepted || !hasPermission) {
            DoABarrelRoll.LOGGER.warn("Client of {} tried to update the server config, but is not allowed to. Rejecting.", (Object)player.method_5477().getString());
            return this.getFailureBuf();
        }
        try {
            int protocolVersion = buf.readInt();
            if (protocolVersion != 1) {
                DoABarrelRoll.LOGGER.warn("Client of {} sent unknown protocol version for server config update, expected 1, got {}. Will attempt to proceed anyway.", (Object)player.method_5477().getString(), (Object)protocolVersion);
            }
            String data = buf.method_19772();
            ValidatableConfig newConfig = (ValidatableConfig)this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)data)).getOrThrow(false, arg_0 -> ((Logger)DoABarrelRoll.LOGGER).error(arg_0));
            if (!newConfig.isValid()) {
                throw new RuntimeException("Config arrived, but contains invalid values");
            }
            try {
                data = ((JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)newConfig).getOrThrow(false, arg_0 -> ((Logger)DoABarrelRoll.LOGGER).error(arg_0))).toString();
                class_2540 res = DoABarrelRoll.createBuf();
                res.writeInt(1);
                res.writeBoolean(true);
                res.method_10814(data);
                DoABarrelRoll.LOGGER.info("{} updated the server config.", (Object)player.method_5477().getString());
                this.instance = newConfig;
                this.updateCallback.accept(player.method_5682(), (MinecraftServer)this.instance);
                this.save();
                return res;
            }
            catch (RuntimeException e) {
                DoABarrelRoll.LOGGER.error("Failed to encode config", (Throwable)e);
                return this.getFailureBuf();
            }
        }
        catch (RuntimeException e) {
            DoABarrelRoll.LOGGER.warn("Client of {} sent invalid server config update, rejecting.", (Object)player.method_5477().getString(), (Object)e);
            return this.getFailureBuf();
        }
    }

    private class_2540 getFailureBuf() {
        class_2540 res = DoABarrelRoll.createBuf();
        res.writeInt(1);
        res.writeBoolean(false);
        return res;
    }
}

